/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.script.recorder;

import com.vmware.vide.utils.script.recorder.IScriptRecording;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.eclipse.core.runtime.IProgressMonitor;

public class ShellScriptBatchFileRecording
implements IScriptRecording {
    private static final String EOL = "\n";
    File file;
    boolean isBatchFile;
    private StringBuffer buffer = new StringBuffer(2048);
    private Object mutex = this;

    public ShellScriptBatchFileRecording(File file, boolean isBatchFile) {
        this.file = file;
        this.isBatchFile = isBatchFile;
        this.append(this.getScriptFileHeader());
        this.append(this.getScriptEOL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IScriptRecording append(String s) {
        Object object = this.mutex;
        synchronized (object) {
            this.buffer.append(s);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IScriptRecording append(CharSequence s) {
        Object object = this.mutex;
        synchronized (object) {
            this.buffer.append(s);
        }
        return this;
    }

    @Override
    public String getScriptFileHeader() {
        StringBuilder buffer = new StringBuilder(256);
        if (!this.isBatchFile) {
            buffer.append("#!/bin/sh").append(this.getScriptEOL());
        }
        buffer.append(this.getScriptCommentPrefix());
        buffer.append("**********************************************************").append(this.getScriptEOL());
        buffer.append(this.getScriptCommentPrefix());
        buffer.append("VMware log browser recorder generated script").append(this.getScriptEOL());
        return buffer.toString();
    }

    @Override
    public String getScriptCommentPrefix() {
        if (this.isBatchFile) {
            return "REM ";
        }
        return "# ";
    }

    @Override
    public String getScriptEOL() {
        return EOL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(IProgressMonitor progressMonitor) {
        Object object = this.mutex;
        synchronized (object) {
            try {
                if (progressMonitor != null) {
                    progressMonitor.beginTask("Appending script content", -1);
                }
                String unflushedContent = this.buffer.toString();
                if (this.file.exists()) {
                    this.file.delete();
                }
                FileWriter writer = new FileWriter(this.file, true);
                writer.write(unflushedContent);
                ((Writer)writer).close();
                this.buffer.delete(0, this.buffer.length() - 1);
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }
}

