/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import org.eclipse.osgi.internal.signedcontent.Base64;

public class NetUtils {
    private static String LOCALHOST_NAME = null;
    private static String LOCALHOST_CANONICAL_NAME = null;
    private static String LOCALHOST_IP = null;

    static {
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            LOCALHOST_IP = localMachine.getHostAddress();
            LOCALHOST_NAME = localMachine.getHostName();
            LOCALHOST_CANONICAL_NAME = localMachine.getCanonicalHostName();
        }
        catch (Exception exception) {}
    }

    public static String getLocalHostIP() {
        return LOCALHOST_IP;
    }

    public static String getLocalHostName() {
        return LOCALHOST_NAME;
    }

    public static String getLocalHostCanonicalName() {
        return LOCALHOST_CANONICAL_NAME;
    }

    public static boolean isLocalHost(String host) {
        InetAddress hostAddress;
        block8: {
            if (host == null) {
                return false;
            }
            if (host.equals("localhost") || host.equals("127.0.0.1")) {
                return true;
            }
            if (host.equals(LOCALHOST_IP)) {
                return true;
            }
            if (host.equals(LOCALHOST_NAME)) {
                return true;
            }
            if (host.equals(LOCALHOST_CANONICAL_NAME)) {
                return true;
            }
            try {
                hostAddress = InetAddress.getByName(host);
                if (!hostAddress.isLoopbackAddress() && !hostAddress.isAnyLocalAddress()) break block8;
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return NetworkInterface.getByInetAddress(hostAddress) != null;
    }

    public static String base64decode(String b64) {
        byte[] decoded = Base64.decode((byte[])b64.getBytes());
        StringBuilder decodedString = new StringBuilder();
        int i = 0;
        while (i < decoded.length) {
            decodedString.append((char)decoded[i]);
            ++i;
        }
        return decodedString.toString();
    }

    public static String base64encode(String decoded) {
        byte[] encoded = Base64.encode((byte[])decoded.getBytes());
        StringBuilder b64 = new StringBuilder();
        int i = 0;
        while (i < encoded.length) {
            b64.append((char)encoded[i]);
            ++i;
        }
        return b64.toString();
    }

    private NetUtils() {
    }
}

