/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.mail;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.commons.net.smtp.SimpleSMTPHeader;

public class MailMessage {
    private final String server;
    private final String sender;
    private final String[] recipients;
    private final String subject;
    private final String message;
    private final boolean isHtml;

    public MailMessage(String server, String sender, String[] recipients, String subject, String message, boolean isHtml) {
        this.server = server;
        this.sender = sender;
        this.recipients = recipients;
        this.subject = subject;
        this.message = message;
        this.isHtml = isHtml;
    }

    private String getToField(String[] recipients) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(recipients[0]);
        int i = 1;
        while (i < recipients.length) {
            buffer.append(";");
            buffer.append(recipients[i]);
            ++i;
        }
        return buffer.toString();
    }

    public void send() throws IOException {
        SMTPClient client = new SMTPClient();
        client.setConnectTimeout(5000);
        try {
            client.connect(this.server);
            if (!SMTPReply.isPositiveCompletion((int)client.getReplyCode())) {
                throw new IOException("SMTP Error: (" + client.getReplyCode() + ") " + client.getReplyString());
            }
            if (!client.login()) {
                throw new IOException("SMTP Error: Unable to log in");
            }
            if (!client.setSender(this.sender)) {
                throw new IOException("SMTP Error: Unable to set sender field");
            }
            String[] stringArray = this.recipients;
            int n = this.recipients.length;
            int n2 = 0;
            while (n2 < n) {
                String recipient = stringArray[n2];
                if (!client.addRecipient(recipient)) {
                    throw new IOException("SMTP Error: Unable to add recipient " + recipient);
                }
                ++n2;
            }
            Writer writer = client.sendMessageData();
            if (writer == null) {
                throw new IOException("SMTP Error: DATA command failed");
            }
            SimpleSMTPHeader header = new SimpleSMTPHeader(this.sender, this.getToField(this.recipients), this.subject);
            if (this.isHtml) {
                header.addHeaderField("Content-Type", "text/html");
            }
            writer.write(header.toString());
            writer.write(this.message);
            writer.close();
            if (!client.completePendingCommand()) {
                throw new IOException("SMTP Error: Unable to complete mail message");
            }
        }
        finally {
            if (client.isConnected()) {
                client.disconnect();
            }
        }
    }
}

