/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.local;

import com.vmware.vide.utils.VIDEUtilPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ArchiveUtils {
    private static final byte[] PAX_USTAR_MAGIC;
    private static final int PAX_USTAR_MAGIC_OFFSET = 257;
    private static final byte[] GNU_TAR_MAGIC;
    private static final int GNU_TAR_MAGIC_OFFSET = 257;
    private static final int TAR_MIN_HEADER_SIZE = 512;
    private static final byte[] BZIP2_MAGIC1;
    private static final int BZIP2_MAGIC1_OFFSET = 0;
    private static final byte[] BZIP2_MAGIC2;
    private static final int BZIP2_MAGIC2_OFFSET = 4;
    private static final int BZIP2_MIN_HEADER_SIZE = 20;
    private static final byte[] GZIP_MAGIC;
    private static final int GZIP_MAGIC_OFFSET = 0;
    private static final int GZIP_MIN_HEADER_SIZE = 10;
    private static final byte[] ZIP_MAGIC;
    private static final int ZIP_MAGIC_OFFSET = 0;
    private static final int ZIP_MIN_HEADER_SIZE = 30;
    private static final String READ_IO_ERROR_MSG = "I/O Error on reading the archive file [%s].";

    static {
        byte[] byArray = new byte[6];
        byArray[0] = 117;
        byArray[1] = 115;
        byArray[2] = 116;
        byArray[3] = 97;
        byArray[4] = 114;
        PAX_USTAR_MAGIC = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[0] = 117;
        byArray2[1] = 115;
        byArray2[2] = 116;
        byArray2[3] = 97;
        byArray2[4] = 114;
        byArray2[5] = 32;
        byArray2[6] = 32;
        GNU_TAR_MAGIC = byArray2;
        BZIP2_MAGIC1 = new byte[]{66, 90};
        BZIP2_MAGIC2 = new byte[]{49, 65, 89, 38, 83, 89};
        GZIP_MAGIC = new byte[]{31, -117};
        ZIP_MAGIC = new byte[]{80, 75, 3, 4};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String findFileNamePatternInArchive(File file, String[] filePatterns) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        Object object = filePatterns;
        int n = filePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = object[n2];
            patterns.add(Pattern.compile(pattern));
            ++n2;
        }
        try {
            TarInputStream tis;
            if (ArchiveUtils.isZipFile(file)) {
                try (ZipFile zFile = null;){
                    zFile = new ZipFile(file);
                    String string = ArchiveUtils.searchFileNamePatternsInZipEntries(zFile, patterns);
                    return string;
                }
            }
            if (ArchiveUtils.isTarFile(file)) {
                tis = null;
                try {
                    tis = new TarInputStream((InputStream)new FileInputStream(file));
                    String string = ArchiveUtils.searchFileNamePatternsInTarEntries(tis, patterns);
                    return string;
                }
                finally {
                    if (tis != null) {
                        tis.close();
                    }
                }
            }
            if (ArchiveUtils.isGZipTarFile(file)) {
                tis = null;
                try {
                    tis = new TarInputStream((InputStream)new GZIPInputStream(new FileInputStream(file)));
                    String string = ArchiveUtils.searchFileNamePatternsInTarEntries(tis, patterns);
                    return string;
                }
                finally {
                    if (tis != null) {
                        tis.close();
                    }
                }
            }
            if (!ArchiveUtils.isBZip2TarFile(file)) return null;
            tis = null;
            try {
                FileInputStream fis = new FileInputStream(file);
                fis.read(new byte[2]);
                tis = new TarInputStream((InputStream)new CBZip2InputStream((InputStream)fis));
                object = ArchiveUtils.searchFileNamePatternsInTarEntries(tis, patterns);
                return object;
            }
            finally {
                if (tis != null) {
                    tis.close();
                }
            }
        }
        catch (IOException e) {
            ILog log = VIDEUtilPlugin.getDefault().getLog();
            Status status = new Status(4, "com.vmware.vide.utils", String.format(READ_IO_ERROR_MSG, file.getName()), (Throwable)e);
            log.log((IStatus)status);
        }
        return null;
    }

    public static boolean isArchive(File f) {
        if (ArchiveUtils.isZipFile(f)) {
            return true;
        }
        if (ArchiveUtils.isTarFile(f)) {
            return true;
        }
        if (ArchiveUtils.isGZipTarFile(f)) {
            return true;
        }
        return ArchiveUtils.isBZip2TarFile(f);
    }

    public static boolean isArchive(String path) {
        return ArchiveUtils.isArchive(new File(path));
    }

    public static boolean isSupportedArchiveFilename(String path) {
        return (path = path.toLowerCase()).endsWith(".zip") || path.endsWith(".tgz") || path.endsWith(".tar.gz") || path.endsWith(".tar.bz2") || path.endsWith(".tar");
    }

    private static String searchFileNamePatternsInZipEntries(ZipFile zFile, List<Pattern> patterns) throws IOException {
        Enumeration e = zFile.getEntries();
        while (e.hasMoreElements()) {
            ZipEntry ze = (ZipEntry)e.nextElement();
            String name = ze.getName();
            Path path = new Path(name);
            for (Pattern p : patterns) {
                if (!p.matcher(path.lastSegment()).matches()) continue;
                return path.removeLastSegments(1).toOSString();
            }
        }
        return null;
    }

    public static String searchFileNamePatternsInZipEntries(File archiveFile, List<Pattern> patterns) throws IOException {
        return ArchiveUtils.searchFileNamePatternsInZipEntries(new ZipFile(archiveFile), patterns);
    }

    private static String searchFileNamePatternsInTarEntries(TarInputStream tis, List<Pattern> patterns) throws IOException {
        TarEntry te = null;
        while ((te = tis.getNextEntry()) != null) {
            Path path = new Path(te.getName());
            for (Pattern p : patterns) {
                if (!p.matcher(path.lastSegment()).matches()) continue;
                return path.removeLastSegments(1).toOSString();
            }
        }
        return null;
    }

    private static void logFileReadError(File f, Exception e) {
        ILog log = VIDEUtilPlugin.getDefault().getLog();
        Status status = new Status(4, "com.vmware.vide.utils", String.format(READ_IO_ERROR_MSG, f.getName()), (Throwable)e);
        log.log((IStatus)status);
    }

    public static boolean isZipFile(File f) {
        byte[] b = null;
        try {
            b = ArchiveUtils.readBytes(f, 30);
        }
        catch (IOException e) {
            ArchiveUtils.logFileReadError(f, e);
            return false;
        }
        if (b == null) {
            return false;
        }
        return ArchiveUtils.compareBytes(b, 0, ZIP_MAGIC);
    }

    public static boolean isTarFile(File f) {
        byte[] b = null;
        try {
            b = ArchiveUtils.readBytes(f, 512);
        }
        catch (IOException e) {
            ArchiveUtils.logFileReadError(f, e);
            return false;
        }
        if (b == null) {
            return false;
        }
        return ArchiveUtils.compareBytes(b, 257, GNU_TAR_MAGIC) || ArchiveUtils.compareBytes(b, 257, PAX_USTAR_MAGIC);
    }

    public static boolean isGZipFile(File f) {
        byte[] b = null;
        try {
            b = ArchiveUtils.readBytes(f, 10);
        }
        catch (IOException e) {
            ArchiveUtils.logFileReadError(f, e);
            return false;
        }
        if (b == null) {
            return false;
        }
        return ArchiveUtils.compareBytes(b, 0, GZIP_MAGIC);
    }

    public static boolean isBZip2File(File f) {
        byte[] b = null;
        try {
            b = ArchiveUtils.readBytes(f, 20);
        }
        catch (IOException e) {
            ArchiveUtils.logFileReadError(f, e);
            return false;
        }
        if (b == null) {
            return false;
        }
        return ArchiveUtils.compareBytes(b, 0, BZIP2_MAGIC1) && ArchiveUtils.compareBytes(b, 4, BZIP2_MAGIC2);
    }

    private static byte[] readBytes(File f, int num) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);){
            byte[] b = new byte[num];
            int n = fis.read(b);
            if (n < num) {
                return null;
            }
            byte[] byArray = b;
            return byArray;
        }
    }

    private static boolean compareBytes(byte[] buff, int offset, byte[] pattern) {
        byte[] byArray = pattern;
        int n = pattern.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (offset >= buff.length) {
                return false;
            }
            if (buff[offset] != b) {
                return false;
            }
            ++offset;
            ++n2;
        }
        return true;
    }

    /*
     * Loose catch block
     */
    public static boolean isGZipTarFile(File f) {
        if (ArchiveUtils.isGZipFile(f)) {
            byte[] b;
            block18: {
                GZIPInputStream gzis;
                block16: {
                    block17: {
                        gzis = null;
                        b = null;
                        gzis = new GZIPInputStream(new FileInputStream(f));
                        b = new byte[512];
                        int n = gzis.read(b);
                        if (n >= 512) break block16;
                        if (gzis == null) break block17;
                        try {
                            gzis.close();
                        }
                        catch (IOException iOException) {
                            return false;
                        }
                    }
                    return false;
                    catch (IOException e) {
                        try {
                            ArchiveUtils.logFileReadError(f, e);
                            if (gzis == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (gzis != null) {
                                try {
                                    gzis.close();
                                }
                                catch (IOException iOException) {
                                    return false;
                                }
                            }
                            throw throwable;
                        }
                        try {
                            gzis.close();
                            break block18;
                        }
                        catch (IOException iOException) {
                            return false;
                        }
                    }
                }
                if (gzis != null) {
                    try {
                        gzis.close();
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
            }
            if (b == null) {
                return false;
            }
            return ArchiveUtils.compareBytes(b, 257, GNU_TAR_MAGIC) || ArchiveUtils.compareBytes(b, 257, PAX_USTAR_MAGIC);
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public static boolean isBZip2TarFile(File f) {
        if (ArchiveUtils.isBZip2File(f)) {
            byte[] b;
            block18: {
                CBZip2InputStream bz2is;
                block16: {
                    block17: {
                        bz2is = null;
                        b = null;
                        FileInputStream fis = new FileInputStream(f);
                        fis.read(new byte[2]);
                        bz2is = new CBZip2InputStream((InputStream)fis);
                        b = new byte[512];
                        int n = bz2is.read(b);
                        if (n >= 512) break block16;
                        if (bz2is == null) break block17;
                        try {
                            bz2is.close();
                        }
                        catch (IOException iOException) {
                            return false;
                        }
                    }
                    return false;
                    catch (IOException e) {
                        try {
                            ArchiveUtils.logFileReadError(f, e);
                            if (bz2is == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (bz2is != null) {
                                try {
                                    bz2is.close();
                                }
                                catch (IOException iOException) {
                                    return false;
                                }
                            }
                            throw throwable;
                        }
                        try {
                            bz2is.close();
                            break block18;
                        }
                        catch (IOException iOException) {
                            return false;
                        }
                    }
                }
                if (bz2is != null) {
                    try {
                        bz2is.close();
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
            }
            if (b == null) {
                return false;
            }
            return ArchiveUtils.compareBytes(b, 257, GNU_TAR_MAGIC) || ArchiveUtils.compareBytes(b, 257, PAX_USTAR_MAGIC);
        }
        return false;
    }
}

