/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.json;

enum Token {
    BEGIN_ARRAY("["),
    BEGIN_OBJECT("{"),
    END_ARRAY("]"),
    END_OBJECT("}"),
    NAME_SEPARATOR(":"),
    VALUE_SEPARATOR(","),
    WHITE_SPACE(" "),
    FALSE("false"),
    NULL("null"),
    TRUE("true"),
    NUMBER("number"),
    STRING("string"),
    EOS("eos");

    Object value;
    String name;

    private Token(String name) {
        if (name.equals("false")) {
            this.value = Boolean.FALSE;
        } else if (name.equals("true")) {
            this.value = Boolean.TRUE;
        } else if (name.equals("null")) {
            this.value = null;
        }
        this.name = name;
    }

    void setValue(Object value) {
        this.value = value;
    }

    Object getValue() {
        return this.value;
    }

    boolean isValue() {
        return this == STRING || this == FALSE || this == TRUE || this == NULL || this == NUMBER;
    }

    String getName() {
        return this.name;
    }
}

