/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.target.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpProgressMonitor;
import com.vmware.vide.target.util.PathUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.OperationCanceledException;

public class ScpHelper {
    public static void scpTo(Session session, String srcFile, String dstFile, SftpProgressMonitor monitor) throws Exception {
        Channel channel = null;
        FileInputStream fis = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            int len;
            String command = "scp -p -t " + PathUtility.enQuoteUnix(dstFile);
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            out = channel.getOutputStream();
            in = channel.getInputStream();
            channel.connect();
            if (ScpHelper.checkAck(in) != 0) {
                throw new IOException("Failed to connect to ssh channel");
            }
            long size = new File(srcFile).length();
            command = "C0644 " + size + " ";
            command = srcFile.lastIndexOf(File.separatorChar) > 0 ? String.valueOf(command) + srcFile.substring(srcFile.lastIndexOf(File.separator) + 1) : String.valueOf(command) + srcFile;
            command = String.valueOf(command) + "\n";
            out.write(command.getBytes());
            out.flush();
            if (ScpHelper.checkAck(in) != 0) {
                throw new IOException("Failed to send file size and name");
            }
            if (monitor != null) {
                monitor.init(0, srcFile, dstFile, size);
            }
            fis = new FileInputStream(srcFile);
            byte[] buf = new byte[1024];
            int count = 0;
            int written = 0;
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
                written += len;
                if (++count != 48) continue;
                if (monitor != null && !monitor.count((long)written)) {
                    throw new OperationCanceledException();
                }
                written = 0;
                count = 0;
            }
            ScpHelper.sendAck(out);
            ScpHelper.checkAck(in);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (fis != null) {
                fis.close();
            }
            if (channel != null) {
                channel.disconnect();
            }
            if (monitor != null) {
                monitor.end();
            }
        }
    }

    public static void scpFrom(Session session, String srcFile, String dstFile, SftpProgressMonitor monitor) throws Exception {
        Channel channel = null;
        FileOutputStream fos = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            String command = "scp -f " + PathUtility.enQuoteUnix(srcFile);
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            out = channel.getOutputStream();
            in = channel.getInputStream();
            channel.connect();
            ScpHelper.sendAck(out);
            if (ScpHelper.checkAck(in) != 67) {
                throw new IOException("Asking sink mode from remote failed");
            }
            in.skip(5L);
            long filesize = 0L;
            while (true) {
                int b;
                if ((b = in.read()) < 0) {
                    throw new IOException("Error reading file size");
                }
                if (b == 32) break;
                filesize = filesize * 10L + (long)(b - 48);
            }
            byte[] buf = new byte[1024];
            int i = 0;
            while (true) {
                in.read(buf, i, 1);
                if (buf[i] == 10) break;
                ++i;
            }
            String filename = new String(buf, 0, i);
            ScpHelper.sendAck(out);
            if (monitor != null) {
                monitor.init(1, srcFile, dstFile, filesize);
            }
            fos = new File(dstFile).isDirectory() ? new FileOutputStream(String.valueOf(dstFile) + File.separator + filename) : new FileOutputStream(dstFile);
            int count = 0;
            int written = 0;
            while (filesize > 0L) {
                int readSize = (long)buf.length < filesize ? buf.length : (int)filesize;
                if ((readSize = in.read(buf, 0, readSize)) < 0) {
                    throw new IOException("Error during remote file read");
                }
                fos.write(buf, 0, readSize);
                filesize -= (long)readSize;
                written += readSize;
                if (++count != 48) continue;
                if (monitor != null && !monitor.count((long)written)) {
                    throw new OperationCanceledException();
                }
                written = 0;
                count = 0;
            }
            ScpHelper.checkAck(in);
            ScpHelper.sendAck(out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (channel != null) {
                channel.disconnect();
            }
            if (monitor != null) {
                monitor.end();
            }
        }
    }

    public static byte[] scpFrom(Session session, String srcFile, long size, SftpProgressMonitor monitor) throws Exception {
        if (size > Integer.MAX_VALUE) {
            throw new Exception("The requested length is too large to process");
        }
        Channel channel = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            int readSize;
            String command = "scp -f " + PathUtility.enQuoteUnix(srcFile);
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            out = channel.getOutputStream();
            in = channel.getInputStream();
            channel.connect();
            ScpHelper.sendAck(out);
            if (ScpHelper.checkAck(in) != 67) {
                throw new IOException("Asking sink mode from remote failed");
            }
            in.skip(5L);
            long filesize = 0L;
            while (true) {
                int b;
                if ((b = in.read()) < 0) {
                    throw new IOException("Error reading file size");
                }
                if (b == 32) break;
                filesize = filesize * 10L + (long)(b - 48);
            }
            byte[] buf = new byte[1024];
            int i = 0;
            while (true) {
                in.read(buf, i, 1);
                if (buf[i] == 10) break;
                ++i;
            }
            ScpHelper.sendAck(out);
            if (monitor != null) {
                monitor.init(1, srcFile, null, filesize);
            }
            byte[] buffer = new byte[(int)(filesize > size ? size : filesize)];
            for (int offset = 0; offset < buffer.length; offset += readSize) {
                readSize = in.read(buffer, offset, buffer.length - offset);
                if (readSize >= 0) continue;
                throw new IOException("Error during remote file read");
            }
            if (filesize <= size) {
                ScpHelper.checkAck(in);
                ScpHelper.sendAck(out);
            }
            byte[] byArray = buffer;
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (channel != null) {
                channel.disconnect();
            }
            if (monitor != null) {
                monitor.end();
            }
        }
    }

    private static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
        }
        return b;
    }

    private static void sendAck(OutputStream out) throws IOException {
        out.write(0);
        out.flush();
    }
}

