/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.target.api.impl.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetProcess;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RemoteProcess
implements ITargetProcess {
    private final ITarget target;
    private final ChannelExec channel;

    public RemoteProcess(ITarget target, Session session, String command) throws JSchException {
        this.target = target;
        this.channel = (ChannelExec)session.openChannel("exec");
        this.channel.setCommand(command);
    }

    public ITarget getTarget() {
        return this.target;
    }

    public void run() throws Exception {
        this.channel.connect();
    }

    public void destroy() throws Exception {
        this.channel.sendSignal("KILL");
        this.channel.disconnect();
    }

    public boolean isActive() {
        return this.channel.isConnected();
    }

    public int exitValue() throws Exception {
        return this.channel.getExitStatus();
    }

    public int waitFor() throws Exception {
        while (this.channel.isConnected()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.channel.getExitStatus();
    }

    public InputStream getErrorStream() throws IOException {
        return this.channel.getErrStream();
    }

    public void setErrorStream(OutputStream stream) {
        this.channel.setErrStream(stream);
    }

    public InputStream getInputStream() throws IOException {
        return this.channel.getInputStream();
    }

    public void setInputStream(InputStream stream) {
        this.channel.setInputStream(stream);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.channel.getOutputStream();
    }

    public void setOutputStream(OutputStream stream) {
        this.channel.setOutputStream(stream);
    }

    public void setEnv(byte[] name, byte[] value) {
        this.channel.setEnv(name, value);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(ChannelExec.class)) {
            return this.channel;
        }
        return null;
    }
}

