/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.target.api.impl.sdk;

import com.vmware.vide.target.api.impl.AbstractConnectionManager;
import com.vmware.vide.target.api.impl.sdk.ISdkConnectionLostListener;
import com.vmware.vide.target.api.impl.sdk.SdkConnectionKeeperTask;
import com.vmware.vim25.mo.ServiceInstance;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;

public class SdkConnectionManager
extends AbstractConnectionManager
implements ISdkConnectionLostListener {
    private static final long SDK_PING_INTERVAL = 1500000L;
    private ServiceInstance serviceInstance;
    private boolean isConnected = false;
    private Timer connectionTimer = new Timer();
    private TimerTask connectionTask;

    public SdkConnectionManager(String host, String user, String password) {
        super(host, user, password);
    }

    public ServiceInstance getServiceInstance() throws Exception {
        if (!this.isConnected) {
            StringBuffer url = new StringBuffer("https://");
            url.append(this.host);
            url.append("/sdk");
            this.serviceInstance = new ServiceInstance(new URL(url.toString()), this.user, this.password, true);
            this.isConnected = true;
            this.connectionTask = new SdkConnectionKeeperTask(this.serviceInstance, this);
            this.connectionTimer.schedule(this.connectionTask, 1500000L, 1500000L);
        }
        return this.serviceInstance;
    }

    @Override
    public void connect() throws Exception {
    }

    @Override
    public void disconnect() throws Exception {
        if (this.isConnected) {
            try {
                this.serviceInstance.getServerConnection().logout();
            }
            finally {
                this.serviceInstance = null;
                this.isConnected = false;
                this.connectionTask.cancel();
                this.properties.clear();
            }
        }
    }

    @Override
    public void onSdkConnectionLost() {
        try {
            this.disconnect();
        }
        catch (Exception exception) {}
    }
}

