/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.target.api.impl;

import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetFile;
import com.vmware.vide.target.api.impl.FileAttributes;
import com.vmware.vide.target.api.impl.ssh.RemoteProcess;
import com.vmware.vide.target.util.PathUtility;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;

public class TargetFile
implements ITargetFile {
    private static final String COMMAND_FAILED_FORMAT = "Command failed (RC %d) - %s: %s";
    private static final String ENOENT_MESSAGE = "No such file or directory";
    private static final Pattern ENOENT_PATTERN = Pattern.compile("No such file or directory", 2);
    private ITarget target;
    private String path;
    private String quotedPath;
    private String canonicalPath;
    private FileAttributes attributes;
    private FileAttributes canonicalAttributes;

    public TargetFile(ITarget target, String path) throws Exception {
        this.target = target;
        this.path = path;
        this.quotedPath = PathUtility.enQuoteUnix(path);
        this.attributes = this.getAttributes(path, this.quotedPath);
        if (this.attributes != null) {
            if (this.isLink()) {
                String command = "readlink -f " + this.quotedPath;
                List<String> output = this.runCommand(command);
                if (output.isEmpty()) {
                    throw new Exception("No output returned from readlink: " + this.quotedPath);
                }
                this.canonicalPath = output.get(0);
                this.canonicalAttributes = this.getAttributes(this.canonicalPath, PathUtility.enQuoteUnix(this.canonicalPath));
            } else {
                this.canonicalPath = this.getCanonicalPath(path);
            }
        } else {
            this.canonicalPath = this.getCanonicalPath(path);
        }
    }

    private List<String> runCommand(String command) throws Exception {
        ArrayList<String> output = new ArrayList<String>();
        RemoteProcess process = (RemoteProcess)this.target.getTargetProcess(command);
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            process.setErrorStream(stream);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            process.run();
            String line = null;
            while ((line = reader.readLine()) != null) {
                output.add(line);
            }
            int rc = process.waitFor();
            if (rc != 0) {
                throw new Exception(String.format(COMMAND_FAILED_FORMAT, rc, command, stream.toString()));
            }
        }
        finally {
            if (process.isActive()) {
                process.destroy();
            }
        }
        return output;
    }

    private FileAttributes getAttributes(String path, String quotedPath) throws Exception {
        FileAttributes attributes;
        block3: {
            attributes = null;
            String command = "stat -t " + quotedPath;
            try {
                List<String> output = this.runCommand(command);
                if (!output.isEmpty()) {
                    attributes = new FileAttributes(path, output.get(0));
                }
            }
            catch (Exception e) {
                if (ENOENT_PATTERN.matcher(e.getMessage()).find()) break block3;
                throw e;
            }
        }
        return attributes;
    }

    private String getCanonicalPath(String path) {
        String[] parts;
        Stack<String> stack = new Stack<String>();
        String[] stringArray = parts = path.split("/");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!part.isEmpty() && !part.equals(".")) {
                if (part.equals("..")) {
                    if (!stack.isEmpty()) {
                        stack.pop();
                    }
                } else {
                    stack.push(part);
                }
            }
            ++n2;
        }
        StringBuffer buffer = new StringBuffer();
        for (String part : stack) {
            buffer.append("/");
            buffer.append(part);
        }
        if (buffer.length() == 0) {
            buffer.append("/");
        }
        return buffer.toString();
    }

    public ITarget getTarget() {
        return this.target;
    }

    public String getParent() {
        return new File(this.path).getParent();
    }

    public ITargetFile getParentTargetFile(IProgressMonitor monitor) throws Exception {
        return this.target.getTargetFile(this.getParent(), monitor);
    }

    public String getAbsolutePath() {
        return this.path;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public boolean canRead() {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.isReadable();
    }

    public boolean canWrite() {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.isWriteable();
    }

    public boolean isDirectory() {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.isDir();
    }

    public boolean isLink() {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.isLink();
    }

    public boolean isCanonicalDirectory() {
        if (this.canonicalAttributes == null) {
            return false;
        }
        return this.canonicalAttributes.isDir();
    }

    public boolean isFile() {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.isFile();
    }

    public long lastModified() {
        if (this.attributes == null) {
            return 0L;
        }
        return this.attributes.getModifiedTime();
    }

    public boolean exists() {
        return this.attributes != null;
    }

    public long length() {
        return this.attributes.getSize();
    }

    public void delete(IProgressMonitor monitor) throws Exception {
        int rc;
        String command = null;
        if (this.exists()) {
            command = this.isDirectory() ? "rm -rf " + this.quotedPath : "rm -f " + this.quotedPath;
        }
        if ((rc = this.target.executeCommand(command, null, monitor)) != 0) {
            throw new Exception("Unable to delete file: " + this.quotedPath);
        }
    }

    public String[] list(IProgressMonitor monitor) throws Exception {
        String[] files = null;
        String path = null;
        if (this.exists()) {
            if (this.isDirectory()) {
                path = this.quotedPath;
            } else if (this.isLink() && this.isCanonicalDirectory()) {
                path = PathUtility.enQuoteUnix(this.canonicalPath);
            }
            if (path != null) {
                String command = "ls -1 " + path;
                List<String> output = this.runCommand(command);
                files = output.toArray(new String[output.size()]);
            }
        }
        return files;
    }

    public ITargetFile[] listFiles(IProgressMonitor monitor) throws Exception {
        TargetFile[] targetFiles = null;
        String[] files = this.list(monitor);
        if (files != null) {
            targetFiles = new TargetFile[files.length];
            int i = 0;
            while (i < files.length) {
                targetFiles[i] = this.target.getTargetFile((ITargetFile)this, files[i], monitor);
                ++i;
            }
        }
        return targetFiles;
    }

    public boolean mkdir(IProgressMonitor monitor) throws Exception {
        String command;
        int rc;
        boolean created = false;
        if (!this.exists() && (rc = this.target.executeCommand(command = "mkdir " + this.quotedPath, null, monitor)) == 0) {
            created = true;
        }
        return created;
    }

    public boolean mkdirs(IProgressMonitor monitor) throws Exception {
        String command;
        int rc;
        boolean created = false;
        if (!this.exists() && (rc = this.target.executeCommand(command = "mkdir -p " + this.quotedPath, null, monitor)) == 0) {
            created = true;
        }
        return created;
    }
}

