/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.target.api.impl;

public class FileAttributes {
    private static final int ATTR_FILESIZE = 0;
    private static final int ATTR_RAWMODE = 2;
    private static final int ATTR_MTIME = 11;
    private static final int NUM_TOKENS = 14;
    private static final int S_IFMT = 61440;
    private static final int S_IFLNK = 40960;
    private static final int S_IFREG = 32768;
    private static final int S_IFDIR = 16384;
    private static final int S_IRUSR = 256;
    private static final int S_IWUSR = 128;
    private String[] buffer;
    private int permissions;

    public FileAttributes(String name, String buf) throws Exception {
        String tmpBuf = buf.trim();
        if (!tmpBuf.startsWith(name)) {
            throw new Exception("stat output must start with the file name");
        }
        tmpBuf = tmpBuf.substring(name.length()).trim();
        this.buffer = tmpBuf.split("\\s+");
        if (this.buffer.length < 14) {
            throw new Exception("stat output must contain 14 tokens");
        }
        this.permissions = Integer.parseInt(this.buffer[2], 16);
    }

    public boolean isFile() {
        return (this.permissions & 0xF000) == 32768;
    }

    public boolean isDir() {
        return (this.permissions & 0xF000) == 16384;
    }

    public boolean isLink() {
        return (this.permissions & 0xF000) == 40960;
    }

    public boolean isReadable() {
        return (this.permissions & 0x100) == 256;
    }

    public boolean isWriteable() {
        return (this.permissions & 0x80) == 128;
    }

    public long getSize() {
        return Long.parseLong(this.buffer[0]);
    }

    public long getModifiedTime() {
        return Long.parseLong(this.buffer[11]) * 1000L;
    }
}

