/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard;

import com.vmware.vide.dashboard.Activator;
import com.vmware.vide.dashboard.PortalEditorInput;
import com.vmware.vide.dashboard.VMWBPageEditor;
import com.vmware.vide.utils.net.NetworkHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class NetworkChecker
extends Job {
    private boolean connected = true;
    private static final List<String> URLS_TO_TEST = Arrays.asList("http://partnerweb.vmware.com/cva_results/cert_result_upload.php", "https://vdc-repo.vmware.com/api");
    private static ILog logger = Activator.getDefault().getLog();

    public NetworkChecker() {
        super("Check Network Connections");
    }

    private List<Exception> checkAllNetworkConnections() {
        ArrayList<Exception> problems = new ArrayList<Exception>();
        for (String url : URLS_TO_TEST) {
            Exception problem = NetworkHelper.checkURL((String)url);
            problems.add(problem);
        }
        return problems;
    }

    public void reportNotConnected(Shell shell) {
        Point centerLocation = this.getCenterLocation(shell);
        shell.setLocation(centerLocation);
        MessageDialog.openError((Shell)shell, (String)"Connection to VMware servers failed", (String)"VMware Workbench could not establish the server connection required to successfully complete this action. Please click \"OK\", and read the \"Troubleshooting Connection Issues\" tab for instructions on how to solve this problem.");
        this.openConnectionHelpPage(shell);
    }

    private File getResourceFile(String filePath) {
        try {
            File scriptfile;
            URL path = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource(filePath));
            if (path != null && path.getFile() != null && (scriptfile = new File(path.getFile())).exists()) {
                return scriptfile;
            }
        }
        catch (IOException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.dashboard", "Cannot get resource file", (Throwable)e));
        }
        return null;
    }

    public void openConnectionHelpPage(Shell shell) {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IEditorPart editor = page.getActiveEditor();
            PortalEditorInput input = new PortalEditorInput();
            VMWBPageEditor vmwbEditor = (VMWBPageEditor)page.openEditor((IEditorInput)input, "com.vmware.vide.dashboard.vmwbpageeditor");
            vmwbEditor.setOldEditor(editor);
            File file = this.getResourceFile("/resources/vmwb_connections.html");
            String filePath = file.getPath();
            vmwbEditor.show(filePath);
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Not able to display text on troubleshooting network connections.  Press \"OK\" to continue.");
            logger.log((IStatus)new Status(4, "com.vmware.vide.dashboard", "Not able to display text on troubleshooting network connections", (Throwable)e));
        }
    }

    public boolean getConnected() {
        return this.connected;
    }

    public IStatus run(IProgressMonitor monitor) {
        List<Exception> problems = this.checkAllNetworkConnections();
        for (Exception e : problems) {
            if (e == null) continue;
            this.connected = false;
        }
        return Status.OK_STATUS;
    }

    private Point getCenterPoint() {
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Rectangle shellBounds = parentShell.getBounds();
        return new Point(shellBounds.x + shellBounds.width / 2, shellBounds.y + shellBounds.height / 2);
    }

    private Point getCenterLocation(Shell shell) {
        Point shellSize = shell.getSize();
        Point shellCenter = this.getCenterPoint();
        return new Point(shellCenter.x - shellSize.x / 2, shellCenter.y - shellSize.y / 2);
    }
}

