/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard;

import com.vmware.vide.dashboard.Activator;
import com.vmware.vide.dashboard.ContentCategory;
import com.vmware.vide.dashboard.ContentPanel;
import com.vmware.vide.dashboard.LoginDialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class ContentProvider
extends Observable {
    private static List<ContentPanel> panels;
    List<String> paths;
    List<String> pathsDescriptions;
    List<ContentCategory> categories;
    public static final String LINK_HOME = "vide:home";
    public static final String LINK_HOME_DESCRIPTION = "Home";
    public static final String LINK_LOGIN = "vide:login";
    private static String loginId;
    private static String loginPassword;
    private static String sessionToken;
    String homePage = "";
    String currentCat;
    String currentPanel;
    private static boolean isSessionCreated;
    private static String[] positions;

    static {
        loginId = null;
        loginPassword = null;
        sessionToken = null;
        positions = new String[]{"top", "top-left", "top-right", "center-left", "center", "center-right", "bottom-left", "bottom-right", "bottom"};
    }

    public ContentProvider() {
        IConfigurationElement element;
        isSessionCreated = false;
        panels = new ArrayList<ContentPanel>();
        this.paths = new ArrayList<String>();
        this.pathsDescriptions = new ArrayList<String>();
        this.categories = new ArrayList<ContentCategory>();
        try {
            this.homePage = this.readResourceFile("/resources/wb-dashboard.html");
            this.homePage = this.replaceResourceReferences(this.homePage, "href=\"file:");
            this.homePage = this.replaceResourceReferences(this.homePage, "src=\"file:");
        }
        catch (Exception exception) {}
        IConfigurationElement[] extensions = Activator.getDefault().findExtensions("com.vmware.vide.dashboard.category");
        Object object = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            element = object[n2];
            if (element != null && element.getAttribute("category") != null) {
                ContentCategory cat = new ContentCategory(element.getAttribute("category"), element.getAttribute("icon"), element.getAttribute("position"));
                this.categories.add(cat);
            }
            ++n2;
        }
        extensions = Activator.getDefault().findExtensions("com.vmware.vide.dashboard.panel");
        object = extensions;
        n = extensions.length;
        n2 = 0;
        while (n2 < n) {
            block19: {
                element = object[n2];
                if (element != null && element.getAttribute("class") != null) {
                    try {
                        Object obj = element.createExecutableExtension("class");
                        if (!(obj instanceof ContentPanel)) break block19;
                        ContentPanel panel = (ContentPanel)obj;
                        panel.setCategory(element.getAttribute("category"));
                        panel.setIcon(element.getAttribute("icon"));
                        String order = element.getAttribute("order");
                        if (order == null) {
                            panel.setOrder(100);
                        } else {
                            try {
                                int panelOrder = Integer.parseInt(order);
                                panel.setOrder(panelOrder);
                            }
                            catch (NumberFormatException numberFormatException) {
                                panel.setOrder(100);
                            }
                        }
                        if (panel.init()) {
                            panels.add(panel);
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.toString());
                    }
                }
            }
            ++n2;
        }
        Collections.sort(this.categories, new Comparator<ContentCategory>(){

            @Override
            public int compare(ContentCategory arg0, ContentCategory arg1) {
                int i1;
                int i0 = ContentProvider.this.getPositionScore(arg0);
                if (i0 == (i1 = ContentProvider.this.getPositionScore(arg1))) {
                    return 0;
                }
                return i0 > i1 ? 1 : -1;
            }
        });
        for (ContentPanel pan : panels) {
            boolean found = false;
            for (ContentCategory cat : this.categories) {
                if (pan.getCategory() == null || !pan.getCategory().equals(cat.getName())) continue;
                cat.addPanel(pan);
                found = true;
                break;
            }
            if (!found && this.categories.size() > 0) {
                ContentCategory cat;
                cat = this.categories.get(this.categories.size() - 1);
                cat.addPanel(pan);
            }
            for (ContentCategory cat : this.categories) {
                Collections.sort(cat.getPanels());
            }
        }
        this.addHomeLink();
        ContentCategory cat = this.categories.get(0);
        ContentPanel panel = cat.getPanels().get(0);
        this.switchToPanel(cat, panel);
        panel = this.isLoggedIn();
        if (panel != null && (loginId = panel.getUserName()) != null && !loginId.isEmpty()) {
            for (ContentPanel pan : panels) {
                if (pan == panel) continue;
                pan.setCredentials(panel.getUserName(), panel.getPassword());
            }
        }
    }

    public String readResourceFile(String name) {
        StringBuffer fileContent;
        block15: {
            Bundle bundle = Activator.getDefault().getBundle();
            URL url = bundle.getResource(name);
            BufferedReader in = null;
            fileContent = new StringBuffer();
            try {
                try {
                    String inputLine;
                    url = FileLocator.toFileURL((URL)url);
                    FileInputStream inputStream = new FileInputStream(url.getPath());
                    in = new BufferedReader(new InputStreamReader(inputStream));
                    while ((inputLine = in.readLine()) != null) {
                        fileContent.append(inputLine);
                        fileContent.append("\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return fileContent.toString();
    }

    public void addHomeLink() {
        this.addPath(LINK_HOME, LINK_HOME_DESCRIPTION);
    }

    public void addPath(String link, String description) {
        this.paths.add(link);
        this.pathsDescriptions.add(description);
    }

    public void update() {
        this.setChanged();
        this.notifyObservers("");
    }

    private ContentPanel isLoggedIn() {
        if (panels == null) {
            return null;
        }
        for (ContentPanel panel : panels) {
            if (!panel.isLoggedIn()) continue;
            return panel;
        }
        return null;
    }

    protected void switchToPanel(ContentCategory cat, ContentPanel panel) {
        this.currentCat = cat.getName();
        this.currentPanel = panel.getPrefix();
        this.paths.clear();
        this.pathsDescriptions.clear();
        this.addHomeLink();
        this.paths.add(panel.getPrefix());
        this.pathsDescriptions.add(panel.getHeader());
        panel.handleClick(panel.getPrefix());
        this.forceUpdate();
    }

    public boolean isSessionCreated() {
        return isSessionCreated;
    }

    public String toHtml() {
        String html = this.homePage;
        html = this.replaceLoginInHeader(html);
        html = this.replaceBreadcrumbs(html);
        html = this.replaceNavigation(html);
        html = this.replaceContent(html);
        return html;
    }

    private String replaceBreadcrumbs(String html) {
        StringBuilder bcRow = new StringBuilder();
        int cnt = 0;
        for (String loc : this.paths) {
            StringBuilder sb = new StringBuilder();
            if (cnt != this.paths.size() - 1) {
                sb.append("<a href=\"");
                sb.append(loc);
                sb.append("\">");
                sb.append(this.pathsDescriptions.get(cnt));
                sb.append("</a>\n");
            } else {
                sb.append(this.pathsDescriptions.get(cnt));
            }
            bcRow.append("<li class='breadcrumbItem'>").append(sb.toString()).append("</li>\n");
            ++cnt;
        }
        html = this.replaceMarker(html, "<!--@@list:breadcrumbs@@-->", bcRow.toString());
        return html;
    }

    private String replaceLoginInHeader(String html) {
        StringBuilder sb = new StringBuilder();
        if (loginId != null && !loginId.isEmpty() && this.isLoggedIn() != null) {
            sb.append("<span class='login-trigger'>Signed&nbsp;in&nbsp;as&nbsp;");
            sb.append(loginId);
            sb.append("&nbsp;-&nbsp;");
            sb.append("<b><a href=\"vide:login\" class=\"btn\">");
            sb.append("Sign&nbsp;Out</a></b></span>\n");
        } else {
            sb.append("<span class='login-trigger'><b>");
            sb.append("<a href=\"vide:login\" class=\"btn\">");
            sb.append("Sign&nbsp;In</a></b></td></span>\n");
        }
        html = this.replaceMarker(html, "<!--@@loginButton@@-->", sb.toString());
        return html;
    }

    private String replaceNavigation(String html) {
        String content = "";
        StringBuilder sb = new StringBuilder("<ul class='panel' id='navHome'>\n");
        for (ContentCategory cat : this.categories) {
            sb.append("<li class='active'>");
            sb.append(cat.getName()).append("</li>\n");
            for (ContentPanel panel : cat.getPanels()) {
                if (panel.getPrefix().equals(this.currentPanel)) {
                    sb.append("<li class='contentListItemActive'>").append("<a href=\"").append(panel.getPrefix()).append("\">").append(panel.getHeader()).append("</a></li>\n");
                    continue;
                }
                sb.append("<li class='contentListItem'>").append("<a href=\"").append(panel.getPrefix()).append("\">").append(panel.getHeader()).append("</a></li>\n");
            }
        }
        sb.append("</ul>\n");
        content = sb.toString();
        html = this.replaceMarker(html, "<!--@@list:navigation@@-->", content);
        return html;
    }

    private String replaceContent(String html) {
        String content = "";
        String link = this.paths.get(this.paths.size() - 1);
        for (ContentPanel panel : panels) {
            String panelPrefix = panel.getPrefix();
            if (!link.startsWith(panelPrefix)) continue;
            content = panel.getHtml();
            break;
        }
        html = this.replaceMarker(html, "<!--@@list:content@@-->", content);
        return html;
    }

    private String replaceMarker(String html, String marker, String content) {
        int sindex = html.indexOf(marker);
        int eindex = sindex + marker.length();
        html = String.valueOf(html.substring(0, sindex)) + content + html.substring(eindex);
        return html;
    }

    public static boolean loginOrLogout() {
        if (isSessionCreated) {
            for (ContentPanel panel : panels) {
                panel.setCredentials(null, null);
            }
            isSessionCreated = false;
            return true;
        }
        Display myDisplay = Display.getDefault();
        Shell myShell = new Shell(myDisplay);
        LoginDialog login = new LoginDialog(myShell);
        login.create();
        if (login.open() == 1) {
            return true;
        }
        loginId = login.getUserAccount();
        sessionToken = login.getSessionToken();
        loginPassword = login.getPassword();
        for (ContentPanel panel : panels) {
            panel.setCredentials(loginId, sessionToken);
        }
        isSessionCreated = true;
        return true;
    }

    public boolean handleClick(String link) {
        if (link.startsWith(LINK_LOGIN)) {
            return ContentProvider.loginOrLogout();
        }
        if (link.startsWith("vide:open?h=")) {
            String id = link.substring(12);
            for (final ContentPanel panel : panels) {
                String panelPrefix = panel.getPrefix();
                if (!id.startsWith(panelPrefix)) continue;
                panel.setClosed(false);
                this.setChanged();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        panel.notifyObservers("");
                        ContentProvider.this.notifyObservers("");
                    }
                });
                break;
            }
            return true;
        }
        if (link.startsWith("vide:close?h=")) {
            String id = link.substring(13).replace("%20", " ");
            for (ContentCategory cat : this.categories) {
                String name = cat.getName();
                if (!id.equals(name)) continue;
                cat.setClosed(!cat.isClosed());
                this.setChanged();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ContentProvider.this.notifyObservers("");
                    }
                });
                break;
            }
            return true;
        }
        if (link.startsWith(LINK_HOME)) {
            this.paths.clear();
            this.pathsDescriptions.clear();
            this.addHomeLink();
            this.forceUpdate();
            return true;
        }
        for (ContentPanel panel : panels) {
            if (panel.handleActionClick(link)) {
                return true;
            }
            if (!panel.handleClick(link)) continue;
            if (!this.currentCat.equals(panel.getCategory()) || link.equals(panel.getPrefix())) {
                for (ContentCategory cat : this.categories) {
                    if (!cat.getName().equals(this.currentCat)) continue;
                    this.currentCat = panel.getCategory();
                    this.currentPanel = panel.getPrefix();
                    this.paths.clear();
                    this.pathsDescriptions.clear();
                    this.addHomeLink();
                    this.paths.add(panel.getPrefix());
                    this.pathsDescriptions.add(panel.getHeader());
                    break;
                }
            }
            int i = 0;
            for (String path : this.paths) {
                if (path.equals(link)) {
                    while (this.paths.size() > i + 1) {
                        this.pathsDescriptions.remove(this.paths.size() - 1);
                        this.paths.remove(this.paths.size() - 1);
                    }
                    return true;
                }
                ++i;
            }
            this.paths.add(link);
            this.pathsDescriptions.add(panel.getLinkDescription(link));
            this.currentPanel = panel.getPrefix();
            this.forceUpdate();
            return true;
        }
        return false;
    }

    public void setObserver(Observer observer) {
        this.addObserver(observer);
        for (ContentPanel panel : panels) {
            panel.addObserver(observer);
        }
    }

    public void dispose() {
        for (ContentPanel panel : panels) {
            panel.dispose();
        }
    }

    private void forceUpdate() {
        this.setChanged();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ContentProvider.this.notifyObservers("");
            }
        });
    }

    private int getPositionScore(ContentCategory cat) {
        String position = cat.getPosition();
        if (position == null) {
            return 100;
        }
        int index = 0;
        String[] stringArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (position.equalsIgnoreCase(s)) {
                return index;
            }
            ++index;
            ++n2;
        }
        return 100;
    }

    public File getResourceFile(String fileName) {
        try {
            File scriptfile;
            Class<?> cl = this.getClass();
            URL res = cl.getResource(fileName);
            URL path = FileLocator.toFileURL((URL)res);
            if (path != null && path.getFile() != null && (scriptfile = new File(path.getFile())).exists()) {
                return scriptfile;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String replaceResourceReferences(String homePage, String toReplace) {
        int index = 0;
        int length = toReplace.length();
        while ((index = homePage.indexOf(toReplace, index)) >= 0) {
            int eindex = homePage.indexOf("\"", index + length);
            File ref = this.getResourceFile("/resources/" + homePage.substring(index + length, eindex));
            if (ref != null) {
                String resPath = ref.getParent();
                homePage = String.valueOf(homePage.substring(0, index + length)) + "//" + resPath + "/" + homePage.substring(index + length);
            }
            index += length;
        }
        return homePage;
    }

    public static String getSessionToken() {
        return sessionToken;
    }

    public static String getLoginPassword() {
        return loginPassword;
    }

    public static String getLoginId() {
        return loginId;
    }
}

