/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.ws.model;

import com.vmware.vide.vlogbrowser.core.ws.model.LogFileResult;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="ProgressResult")
public class ProgressResult {
    private LogFileResult logFileResult = new LogFileResult();
    private ProgressStatus status = ProgressStatus.DONE;
    private int progressPercentage = 0;
    private long work = 0L;
    private long totalWork = 0L;

    public void setLogFileResult(LogFileResult logFileResult) {
        this.logFileResult = logFileResult;
    }

    public LogFileResult getLogFileResult() {
        return this.logFileResult;
    }

    @XmlElement
    public synchronized int getProgressPercentage() {
        return this.progressPercentage > 100 ? 100 : this.progressPercentage;
    }

    public void setProgressPercentage(int progressPercentage) {
        this.progressPercentage = progressPercentage;
    }

    @XmlElement
    public ProgressStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProgressStatus status) {
        this.status = status;
    }

    public synchronized void incrementWork(int i) {
        this.work += (long)i;
        this.progressPercentage = (int)((double)this.work / (double)this.totalWork * 100.0);
    }

    public void setTotalWork(long progressTotalWork) {
        this.totalWork = progressTotalWork;
    }

    public static enum ProgressStatus {
        BUSY,
        DONE,
        ERROR;

    }
}

