/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.utils;

import com.vmware.vide.utils.xml.XMLUtil;
import com.vmware.vide.vlogbrowser.core.consts.LogBrowserConsts;
import com.vmware.vide.vlogbrowser.core.model.FilterItem;
import com.vmware.vide.vlogbrowser.core.model.LogFilter;
import com.vmware.vide.vlogbrowser.core.utils.Utils;
import com.vmware.vide.vlogbrowser.core.ws.model.FilterConditionResult;
import com.vmware.vide.vlogbrowser.core.ws.model.FilterConditionRowResult;
import com.vmware.vide.vlogbrowser.core.ws.model.FilterResult;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WsUtils {
    public static FilterResult createFilterResult(String filterName, LogFilter filter) {
        FilterResult result = new FilterResult();
        if (filterName != null) {
            result.setFilterName(filterName);
        } else {
            result.setFilterName(filter.getName());
        }
        int nRows = filter.getFilterRowCount();
        ArrayList<FilterConditionRowResult> conditions = new ArrayList<FilterConditionRowResult>();
        result.setConditions(conditions);
        int row = 0;
        while (row < nRows) {
            int nCols = filter.getFilterColumnCount(row);
            if (nCols >= 1) {
                FilterConditionRowResult condRow = new FilterConditionRowResult();
                int col = 0;
                while (col < nCols) {
                    FilterConditionResult cond = new FilterConditionResult();
                    try {
                        FilterItem item = filter.getFilterItem(row, col);
                        LogBrowserConsts.BooleanConnector op = item.getBoolConnector();
                        switch (op) {
                            case AND: {
                                cond.setOperator("AND");
                                break;
                            }
                            case OR: {
                                cond.setOperator("OR");
                            }
                        }
                        if (item.isNegateFlagSet()) {
                            cond.setIsNot(Boolean.TRUE);
                        }
                        if (item.isRegexFlagSet()) {
                            cond.setIsRegEx(Boolean.TRUE);
                        }
                        cond.setPattern(item.getKeyword());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    condRow.addCondition(cond);
                    ++col;
                }
                conditions.add(condRow);
            }
            ++row;
        }
        return result;
    }

    public static List<LogFilter> createLogFilters(InputStream filterResultXmlInputStream) throws Exception {
        ArrayList<LogFilter> returnList = new ArrayList<LogFilter>(1);
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        dbf.setIgnoringComments(true);
        doc = db.parse(filterResultXmlInputStream);
        FilterItem item1 = null;
        int row = 0;
        int i = 0;
        while (i < doc.getChildNodes().getLength()) {
            String tag;
            Node node = doc.getChildNodes().item(i);
            if (node.getNodeType() == 1 && (tag = node.getNodeName()).equalsIgnoreCase("Filter")) {
                ArrayList nameNodes = XMLUtil.getAllChildrenNamed((String)"Name", (Node)node);
                if (nameNodes == null || nameNodes.size() == 0) {
                    throw new IllegalArgumentException("XML must contain a 'Name' element");
                }
                String filterName = Utils.stripQuotes(XMLUtil.getTextNodeValue((Node)((Node)nameNodes.get(0))));
                LogFilter filter = new LogFilter(filterName, 0, 2);
                returnList.add(filter);
                int conditionsProcessed = 0;
                ArrayList rowNodes = XMLUtil.getAllChildrenNamed((String)"conditions", (Node)node);
                for (Node rowNode : rowNodes) {
                    int col = 0;
                    ArrayList condNodes = XMLUtil.getAllChildrenNamed((String)"Condition", (Node)rowNode);
                    for (Node condNode : condNodes) {
                        if (col > 1) break;
                        item1 = new FilterItem();
                        filter.setFilterItem(row, col, item1);
                        ++conditionsProcessed;
                        int cc = 0;
                        while (cc < condNode.getChildNodes().getLength()) {
                            Node opNode = condNode.getChildNodes().item(cc);
                            if (XMLUtil.isTextNode((Node)opNode)) {
                                String val = XMLUtil.getTextNodeValue((Node)opNode);
                                tag = opNode.getNodeName();
                                if (tag.equalsIgnoreCase("operator")) {
                                    LogBrowserConsts.BooleanConnector oper = LogBrowserConsts.BooleanConnector.SKIP;
                                    if (val != null && val.equalsIgnoreCase("AND")) {
                                        oper = LogBrowserConsts.BooleanConnector.AND;
                                    } else if (val != null && val.equalsIgnoreCase("OR")) {
                                        oper = LogBrowserConsts.BooleanConnector.OR;
                                    }
                                    item1.setBoolConnector(oper);
                                } else if (tag.equalsIgnoreCase("isNot")) {
                                    item1.setNegateFlag(true);
                                } else if (tag.equalsIgnoreCase("isRegEx")) {
                                    item1.setRegexFlag(true);
                                } else if (tag.equalsIgnoreCase("pattern") && val != null) {
                                    item1.setKeyword(val);
                                }
                            }
                            ++cc;
                        }
                        ++col;
                    }
                    ++row;
                }
                if (conditionsProcessed == 0) {
                    throw new Exception("There are no child 'Condition' elements for filter '" + filterName + "'");
                }
            }
            ++i;
        }
        return returnList;
    }

    private WsUtils() {
    }
}

