/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.utils;

import com.vmware.vide.target.api.ITarget;
import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;

public class Utils {
    private static final boolean isWindows;
    private static final boolean isMac;

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        isWindows = osName.contains("win");
        isMac = osName.contains("mac");
    }

    public static String getPathSep(String hostname) {
        if (hostname.equalsIgnoreCase("localhost")) {
            return System.getProperty("file.separator");
        }
        return "/";
    }

    public static boolean isPlatformWindows() {
        return isWindows;
    }

    public static boolean isPlatformMac() {
        return isMac;
    }

    public static String getSafeEsxVersion(ITarget target, String hostType) throws Exception {
        String hostVer = "";
        if (target != null && !"Error contacting host".equals(hostType) && hostType.contains("ESX")) {
            hostVer = target.getESXVersion();
        }
        return hostVer;
    }

    public static File getTemplateFile(Class<?> c, String fileName) {
        try {
            File file;
            URL resourceUrl = c.getResource("/templates/" + fileName);
            URL path = FileLocator.toFileURL((URL)resourceUrl);
            if (path != null && path.getFile() != null && (file = new File(path.getFile())).exists()) {
                return file;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String stripQuotes(String s) {
        if (s == null || s.length() < 1) {
            return s;
        }
        if (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            s = s.substring(1, s.length() - 1);
        } else if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }
}

