/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.script.recorder;

import com.vmware.vide.utils.script.recorder.IScriptRecording;
import com.vmware.vide.utils.script.recorder.ShellScriptBatchFileRecording;
import com.vmware.vide.vlogbrowser.core.script.api.LogBrowserScriptRecorderManager;
import com.vmware.vide.vlogbrowser.core.script.recorder.LogBrowserShellScriptRecorder;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class ScriptRecorderManager {
    private static ScriptRecorderManager instance = new ScriptRecorderManager();
    private boolean isRecording = false;
    private File recordingFile = null;
    private IScriptRecording recording = null;

    public static ScriptRecorderManager getInstance() {
        return instance;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startRecording(File file) {
        ScriptRecorderManager scriptRecorderManager = this;
        synchronized (scriptRecorderManager) {
            block4: {
                if (!this.isRecording) break block4;
                return false;
            }
            this.recordingFile = file;
            String extension = FilenameUtils.getExtension((String)file.getName());
            boolean isBatchFile = extension != null && extension.endsWith("bat");
            this.recording = new ShellScriptBatchFileRecording(this.recordingFile, isBatchFile);
            this.recording.append(String.valueOf(this.recording.getScriptCommentPrefix()) + "Enable echoing all commands issued in the script. Delete this line if you do not want that...");
            this.recording.append(this.recording.getScriptEOL());
            this.recording.append("set -x");
            this.recording.append(this.recording.getScriptEOL());
            this.recording.append(this.recording.getScriptEOL());
            this.recording.append(String.valueOf(this.recording.getScriptCommentPrefix()) + "Recording started at " + this.getCurrentTimeString() + this.recording.getScriptEOL());
            this.recording.append(this.recording.getScriptEOL());
            LogBrowserShellScriptRecorder lbShellScriptRecorder = new LogBrowserShellScriptRecorder(this.recording);
            LogBrowserScriptRecorderManager.getInstance().setImplementationRecorder(lbShellScriptRecorder);
            this.isRecording = true;
        }
        return true;
    }

    private String getCurrentTimeString() {
        return DateFormat.getDateTimeInstance().format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stopRecording(IProgressMonitor progressMonitor) {
        ScriptRecorderManager scriptRecorderManager = this;
        synchronized (scriptRecorderManager) {
            block4: {
                if (this.isRecording) break block4;
                return null;
            }
            LogBrowserScriptRecorderManager.getInstance().setImplementationRecorder(null);
            this.recording.append(this.recording.getScriptEOL());
            this.recording.append(String.valueOf(this.recording.getScriptCommentPrefix()) + "Recording stopped at " + this.getCurrentTimeString() + this.recording.getScriptEOL());
            this.recording.flush(progressMonitor);
            String scriptFilePath = this.recordingFile.getAbsolutePath();
            this.recording = null;
            this.recordingFile = null;
            this.isRecording = false;
            return scriptFilePath;
        }
    }

    private ScriptRecorderManager() {
    }
}

