/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.parser;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SolFileParser {
    private static final Logger logger = LoggerFactory.getLogger(SolFileParser.class);

    public static void decode(File inputFile, File outputFile) throws IOException, ClassNotFoundException, ParserConfigurationException, SAXException {
        StringBuffer resultStrBuff = new StringBuffer();
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(inputFile));
        byte amfVersion = SolFileParser.skipHeader(dataInputStream);
        if (amfVersion != 3) {
            throw new IOException("Support only AMF3 records at: " + inputFile.getAbsolutePath());
        }
        AmfReader reader = new AmfReader(dataInputStream);
        byte enc = dataInputStream.readByte();
        if ((enc & 1) == 0) {
            throw new IOException("SOL Format not supported at: " + inputFile.getAbsolutePath());
        }
        byte[] nam = new byte[enc >> 1];
        dataInputStream.read(nam);
        boolean done = false;
        block7: while (!done) {
            try {
                byte typ = dataInputStream.readByte();
                switch (typ) {
                    case 9: {
                        int count = SolFileParser.readU29AValue(dataInputStream);
                        byte utf8empty = dataInputStream.readByte();
                        if (utf8empty != 1) {
                            throw new IOException("SOL Format not supported at: " + inputFile.getAbsolutePath());
                        }
                        count >>= 1;
                        int i = 0;
                        while (i < count) {
                            String entry;
                            Object object = null;
                            try {
                                object = reader.readObject();
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                            if (object != null && !(entry = object.toString()).isEmpty()) {
                                entry = SolFileParser.cleanEntry(entry);
                                resultStrBuff.append(entry);
                            }
                            ++i;
                        }
                        continue block7;
                    }
                    default: {
                        reader.readObject(dataInputStream, typ);
                        break;
                    }
                }
            }
            catch (EOFException eOFException) {
                done = true;
            }
        }
        outputFile.createNewFile();
        FileUtils.writeStringToFile((File)outputFile, (String)resultStrBuff.toString());
    }

    private static String cleanEntry(String entry) {
        String result = "";
        result = entry.replaceAll("\\nnull", "");
        int index = result.indexOf("\n");
        if (index == 0) {
            result = result.substring(1);
        }
        return String.valueOf(result) + "\n";
    }

    private static byte skipHeader(DataInputStream f) throws IOException {
        f.readByte();
        f.readByte();
        f.readInt();
        byte[] signature = new byte[10];
        f.read(signature);
        f.readUTF();
        byte[] padding = new byte[3];
        f.read(padding);
        byte amfVersion = f.readByte();
        return amfVersion;
    }

    private static int readU29AValue(DataInputStream f) throws IOException {
        int val = 0;
        byte b = f.readByte();
        if ((b & 0x80) != 0) {
            val = b & 0x7F;
            b = f.readByte();
        }
        if ((b & 0x80) != 0) {
            b = (byte)(b & 0x7F);
            val <<= 7;
            val |= b;
            b = f.readByte();
        }
        if ((b & 0x80) != 0) {
            b = (byte)(b & 0x7F);
            val <<= 7;
            val |= b;
            b = f.readByte();
        }
        val <<= 7;
        return val |= b & 0xFF;
    }

    static String readUTF8String(DataInputStream is, int len) throws IOException {
        byte[] utf8bytes = new byte[len];
        if (is.read(utf8bytes) != len) {
            throw new IOException("Buffer under flow.");
        }
        int index = 0;
        StringBuilder sb = new StringBuilder();
        while (index < len) {
            if ((utf8bytes[index] & 0x80) == 0) {
                sb.append((char)utf8bytes[index]);
                ++index;
                continue;
            }
            if ((utf8bytes[index] & 0xE0) == 192) {
                sb.append((char)((utf8bytes[index] & 0x1F) << 6 | utf8bytes[index + 1] & 0x3F));
                index += 2;
                continue;
            }
            if ((utf8bytes[index] & 0xF0) == 224) {
                sb.append((char)((utf8bytes[index] & 0xF) << 12 | (utf8bytes[index + 1] & 0x3F) << 6 | utf8bytes[index + 2] & 0x3F));
                index += 3;
                continue;
            }
            if ((utf8bytes[index] & 0xF8) == 240) {
                int codePoint = (utf8bytes[index] & 7) << 18 | (utf8bytes[index + 1] & 0x3F) << 12 | (utf8bytes[index + 2] & 0x3F) << 6 | utf8bytes[index + 3] & 0x3F;
                char[] c = Character.toChars(codePoint);
                sb.append(c);
                index += 4;
                continue;
            }
            throw new IOException("Bad UTF-8");
        }
        return sb.toString();
    }

    private static Document convertToDocument(String text) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(new StringReader(text)));
    }

    static class AmfReader {
        DataInputStream is;
        List<String> sTable = new ArrayList<String>();
        List<Object> oTable = new ArrayList<Object>();

        AmfReader(DataInputStream is) {
            this.is = is;
        }

        Object readObject() throws IOException, ParserConfigurationException, SAXException {
            byte type = this.is.readByte();
            return this.readObject(this.is, type);
        }

        String readString() throws IOException {
            int u29s = SolFileParser.readU29AValue(this.is);
            if ((u29s & 1) == 0) {
                int ref = u29s >> 1;
                return this.sTable.get(ref);
            }
            int len = u29s >> 1;
            if (len == 0) {
                return "";
            }
            String s = SolFileParser.readUTF8String(this.is, len);
            this.sTable.add(s);
            return s;
        }

        Object readObject(DataInputStream is, int type) throws IOException, ParserConfigurationException, SAXException {
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return Boolean.FALSE;
                }
                case 3: {
                    return Boolean.TRUE;
                }
                case 4: {
                    return new Integer(SolFileParser.readU29AValue(is));
                }
                case 5: {
                    return new Double(is.readDouble());
                }
                case 6: {
                    int u29s = SolFileParser.readU29AValue(is);
                    if ((u29s & 1) == 0) {
                        int ref = u29s >> 1;
                        return this.sTable.get(ref);
                    }
                    int len = u29s >> 1;
                    if (len == 0) {
                        return "";
                    }
                    String s = SolFileParser.readUTF8String(is, len);
                    this.sTable.add(s);
                    return s;
                }
                case 7: 
                case 11: {
                    int u29x = SolFileParser.readU29AValue(is);
                    String xml = null;
                    if ((u29x & 1) == 0) {
                        int ref = u29x >> 1;
                        xml = (String)this.oTable.get(ref);
                    } else {
                        int len = u29x >> 1;
                        xml = len == 0 ? "" : SolFileParser.readUTF8String(is, len);
                        this.oTable.add(xml);
                    }
                    return SolFileParser.convertToDocument(xml);
                }
                case 8: {
                    int u29d = SolFileParser.readU29AValue(is);
                    if ((u29d & 1) == 0) {
                        int ref = u29d >> 1;
                        return this.oTable.get(ref);
                    }
                    long t = (long)is.readDouble();
                    Date date = new Date(t);
                    this.oTable.add(date);
                    return date;
                }
                case 9: {
                    String name;
                    int u29a = SolFileParser.readU29AValue(is);
                    if ((u29a & 1) == 0) {
                        int ref = u29a >> 1;
                        return this.oTable.get(ref);
                    }
                    int len = u29a >> 1;
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    while (!(name = this.readString()).isEmpty()) {
                        Object value = this.readObject();
                        m.put(name, value);
                    }
                    if (m.isEmpty()) {
                        Object[] objs = new Object[len];
                        int i = 0;
                        while (i < len) {
                            objs[i] = this.readObject();
                            ++i;
                        }
                        this.oTable.add(objs);
                        return objs;
                    }
                    int i = 0;
                    while (i < len) {
                        m.put(Integer.toString(i), this.readObject());
                        ++i;
                    }
                    this.oTable.add(m);
                    return m;
                }
                case 10: {
                    throw new IOException("Action script object is not supported.");
                }
                case 12: {
                    int u29b = SolFileParser.readU29AValue(is);
                    if ((u29b & 1) == 0) {
                        int ref = u29b >> 1;
                        return this.oTable.get(ref);
                    }
                    int len = u29b >> 1;
                    byte[] byteArray = new byte[len];
                    if (is.read(byteArray) != len) {
                        throw new IOException("Buffer underflow.");
                    }
                    this.oTable.add(byteArray);
                    return byteArray;
                }
                default: {
                    throw new IOException("Unknown marker.");
                }
            }
            return null;
        }
    }
}

