/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.parser;

import com.vmware.vide.vlogbrowser.core.model.LogDate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogDateFormat {
    private DateFormat dateFormat;
    private int lastCalendarMonth;
    private Calendar currentCalendar;
    private boolean yearMissing;
    private Date logFilenameDate;
    private int logfileBeginningYear;
    private int numYearRollovers;
    private String datePattern;
    private long dateDelta;

    public LogDateFormat(String datePattern, Date fileTimestamp) throws IllegalArgumentException {
        this.dateFormat = new SimpleDateFormat(datePattern);
        this.datePattern = datePattern;
        this.dateDelta = 0L;
        this.yearMissing = true;
        boolean checkForY = true;
        int i = 0;
        while (i < datePattern.length()) {
            if (datePattern.charAt(i) == '\'') {
                checkForY = !checkForY;
            } else if (checkForY && datePattern.charAt(i) == 'y') {
                this.yearMissing = false;
                break;
            }
            ++i;
        }
        this.initLogDate(fileTimestamp);
    }

    public LogDateFormat(LogDateFormat other, Date time, String filename) {
        this(other.datePattern, time);
        Pattern pattern;
        Matcher matcher;
        if (filename.length() > 0 && (matcher = (pattern = Pattern.compile("(\\d\\d\\d\\d[_-]\\d\\d[_-]\\d\\d)")).matcher(filename)).find()) {
            String dateStr = matcher.group(1);
            String[] DATE_FORMATS = new String[]{"yyyy-MM-dd", "yyyy_MM_dd"};
            int i = 0;
            while (i < DATE_FORMATS.length) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMATS[i]);
                try {
                    this.logFilenameDate = dateFormat.parse(dateStr);
                    break;
                }
                catch (ParseException parseException) {
                    ++i;
                }
            }
        }
    }

    public void initLogDate(Date fileTimestamp) {
        GregorianCalendar tempCalendar = new GregorianCalendar();
        tempCalendar.setTime(fileTimestamp);
        this.logfileBeginningYear = tempCalendar.get(1);
        this.lastCalendarMonth = -1;
        this.currentCalendar = new GregorianCalendar();
        this.numYearRollovers = 0;
    }

    public Date parse(String source) throws ParseException {
        long currentDate = this.dateFormat.parse(source).getTime();
        if (this.yearMissing && this.logFilenameDate != null) {
            currentDate += this.logFilenameDate.getTime();
        }
        if (this.yearMissing && this.yearRolledOver(currentDate)) {
            ++this.numYearRollovers;
        }
        return new LogDate(currentDate, this, this.numYearRollovers);
    }

    private boolean yearRolledOver(long currentDate) {
        this.currentCalendar.setTimeInMillis(currentDate);
        boolean rolledOver = false;
        if (this.lastCalendarMonth >= 0 && this.lastCalendarMonth > this.currentCalendar.get(2)) {
            rolledOver = true;
            --this.logfileBeginningYear;
        }
        this.lastCalendarMonth = this.currentCalendar.get(2);
        return rolledOver;
    }

    public boolean isYearMissing() {
        return this.yearMissing;
    }

    public int getYear() {
        return this.logfileBeginningYear;
    }

    public long correctYearlessDate(long dateInMillis, int numRollovers) {
        if (!this.yearMissing) {
            return dateInMillis;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(dateInMillis);
        calendar.set(1, this.logfileBeginningYear + numRollovers);
        return calendar.getTimeInMillis();
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDateDelta(long dateDelta) {
        this.dateDelta = dateDelta;
    }

    public long getDateDelta() {
        return this.dateDelta;
    }
}

