/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.parser;

import com.vmware.vide.vlogbrowser.core.parser.ILineReader;
import com.vmware.vide.vlogbrowser.core.parser.LFLineReader;
import com.vmware.vide.vlogbrowser.core.parser.LineReader;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Set;

public class LineReaderFactory {
    private static final String[] lfLineReaderSupport = new String[]{"UTF8", "UTF-8", "ISO-8859-1", "ISO8859_1", "US-ASCII", "ASCII", "windows-1252", "Cp1252"};
    private static Set<String> lfCharset = new HashSet<String>();

    static {
        String[] stringArray = lfLineReaderSupport;
        int n = lfLineReaderSupport.length;
        int n2 = 0;
        while (n2 < n) {
            String cs = stringArray[n2];
            lfCharset.add(cs);
            ++n2;
        }
    }

    private static boolean isLfLineReaderSupport(String charEncode) {
        return lfCharset.contains(charEncode);
    }

    static ILineReader createLineReader(FileInputStream fis, String charEncode) {
        if (LineReaderFactory.isLfLineReaderSupport(charEncode)) {
            return new LFLineReader(fis, charEncode);
        }
        return new LineReader(fis, charEncode);
    }
}

