/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.parser;

import com.vmware.vide.vlogbrowser.core.parser.ILineReader;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class LFLineReader
implements ILineReader {
    private static final int EXPAND_DELTA = 1024;
    private static final int INITIAL_BUFFER_SIZE = 1024;
    private final BufferedInputStream bis;
    private final String charEncode;
    private byte[] bytebuffer = new byte[1024];
    private int inPtr = 0;

    LFLineReader(FileInputStream fis, String charEncode) {
        this.bis = new BufferedInputStream(fis);
        this.charEncode = charEncode;
    }

    @Override
    public int readLine(StringBuilder sb) throws IOException {
        int b;
        while ((b = this.bis.read()) != -1) {
            if (b == 10) {
                int len = this.inPtr + 1;
                this.fillLineContents(sb);
                return len;
            }
            if (this.inPtr >= this.bytebuffer.length) {
                this.expandBuffer();
            }
            this.bytebuffer[this.inPtr] = (byte)b;
            ++this.inPtr;
        }
        if (this.inPtr > 0) {
            int len = this.inPtr;
            this.fillLineContents(sb);
            return len;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.bis.close();
    }

    private void fillLineContents(StringBuilder sb) throws UnsupportedEncodingException {
        if (this.inPtr > 0 && this.bytebuffer[this.inPtr - 1] == 13) {
            sb.append(new String(this.bytebuffer, 0, this.inPtr - 1, this.charEncode));
        } else {
            sb.append(new String(this.bytebuffer, 0, this.inPtr, this.charEncode));
        }
        this.inPtr = 0;
    }

    private void expandBuffer() {
        byte[] newarray = new byte[this.bytebuffer.length + 1024];
        System.arraycopy(this.bytebuffer, 0, newarray, 0, this.bytebuffer.length);
        this.bytebuffer = newarray;
    }
}

