/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.parser;

import com.vmware.vide.vlogbrowser.core.model.ISingleMatcher;
import com.vmware.vide.vlogbrowser.core.model.LogItem;
import java.util.Date;

public class DateMatcher
implements ISingleMatcher {
    private long filterDateMillis;
    private long tolerance;
    private int closestMatchDateIdx;
    private long filterDateClosestDateDiff;

    public DateMatcher(Date filterDate, Long tolerance) {
        this.filterDateMillis = filterDate.getTime();
        this.tolerance = tolerance;
        this.filterDateClosestDateDiff = Long.MAX_VALUE;
        this.closestMatchDateIdx = 0;
    }

    public DateMatcher(Date filterDate) {
        this(filterDate, new Long(0L));
    }

    @Override
    public boolean matches(LogItem logItem) {
        long diff = Math.abs(logItem.getLogDate().getTime() - this.filterDateMillis);
        return diff <= this.tolerance;
    }

    public void submitMatchCandidate(LogItem logItem, int listIndex) {
        long diff = Math.abs(logItem.getLogDate().getTime() - this.filterDateMillis);
        if (diff < this.filterDateClosestDateDiff) {
            this.filterDateClosestDateDiff = diff;
            this.closestMatchDateIdx = listIndex;
        }
    }

    public int getClosestMatchIndex() {
        return this.closestMatchDateIdx;
    }
}

