/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.parser;

import com.vmware.vide.vlogbrowser.core.parser.LogFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AutoDetectLogType {
    private String filename;
    private InputStream logInputStream;
    private List<LogFormat> knownLogFormats;
    HashMap<LogFormat, Integer> logFormatScores;
    public static int SCORE_LIMIT = 50;
    public static int READ_BUFFER_LIMIT = 50000;
    public static final String VMSUPPORT_REGEX = "esx.+\\.tgz$";
    public static final String VMSUPPORT_TYPE = "vm-support_log";
    public static String newline = System.getProperty("line.separator");

    public AutoDetectLogType(String filename, InputStream logInputStream, List<LogFormat> knownLogFormats) {
        this.filename = filename;
        this.logInputStream = logInputStream;
        this.knownLogFormats = knownLogFormats;
        this.logFormatScores = new HashMap();
    }

    public AutoDetectLogType(File logfile, List<LogFormat> knownLogFormats) throws FileNotFoundException {
        this.filename = logfile.getName();
        this.knownLogFormats = knownLogFormats;
        this.logInputStream = new FileInputStream(logfile);
        this.logFormatScores = new HashMap();
    }

    public static boolean storedInsideVMSuppLog(String fileStr) {
        if (fileStr != null && fileStr.length() > 0) {
            Pattern nameRegexPattern = Pattern.compile(VMSUPPORT_REGEX);
            return nameRegexPattern.matcher(fileStr).find();
        }
        return false;
    }

    public String getLogType() throws IOException {
        if (AutoDetectLogType.storedInsideVMSuppLog(this.filename)) {
            return VMSUPPORT_TYPE;
        }
        this.computeScoresFromName();
        if (this.logFormatScores.size() == 1) {
            return this.logFormatScores.keySet().toArray(new LogFormat[1])[0].getName();
        }
        this.computeScoresFromStream();
        LogFormat bestMatchingFormat = null;
        Integer highestScore = 0;
        for (LogFormat logFormat : this.logFormatScores.keySet()) {
            int currentScore = this.logFormatScores.get(logFormat);
            if (currentScore <= highestScore) continue;
            highestScore = currentScore;
            bestMatchingFormat = logFormat;
        }
        if (bestMatchingFormat != null) {
            return bestMatchingFormat.getName();
        }
        return "";
    }

    private void computeScoresFromName() {
        block0: for (LogFormat logFormat : this.knownLogFormats) {
            List<String> filenames = logFormat.getKnownFilenames();
            for (String regexFilename : filenames) {
                Pattern regexMatch = Pattern.compile(regexFilename);
                Matcher matcher = regexMatch.matcher(this.filename);
                if (!matcher.find()) continue;
                this.logFormatScores.put(logFormat, 1);
                continue block0;
            }
        }
    }

    private void computeScoresFromStream() throws IOException {
        String logline;
        InputStreamReader logReader = new InputStreamReader(this.logInputStream);
        BufferedReader buffRdr = new BufferedReader(logReader, READ_BUFFER_LIMIT);
        char[] myCharArr = new char[READ_BUFFER_LIMIT];
        int fileLen = buffRdr.read(myCharArr);
        if (fileLen <= 0) {
            return;
        }
        String myStr = new String(myCharArr);
        myStr = myStr.substring(0, fileLen);
        StringReader strRdr = new StringReader(myStr);
        BufferedReader buffStrRdr = new BufferedReader(strRdr);
        boolean scoreLimitReached = false;
        block0: while ((logline = buffStrRdr.readLine()) != null && !scoreLimitReached) {
            for (LogFormat logFormat : this.knownLogFormats) {
                if (!logFormat.matchesCompletely(logline)) continue;
                Integer previousScore = this.logFormatScores.get(logFormat);
                int currentScore = previousScore != null ? previousScore + 1 : 1;
                this.logFormatScores.put(logFormat, currentScore);
                if (currentScore != SCORE_LIMIT) continue;
                scoreLimitReached = true;
                continue block0;
            }
        }
        buffRdr.close();
    }
}

