/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.model.util;

import com.vmware.vide.vlogbrowser.core.model.util.ISerializable;
import com.vmware.vide.vlogbrowser.core.model.util.ISerializator;
import com.vmware.vide.vlogbrowser.core.model.util.SerializablePersistentList;
import com.vmware.vide.vlogbrowser.core.model.util.SerializatorPersistentList;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistentList<E>
implements List<E> {
    private RandomAccessFile itemFile;
    private int size = 0;
    private byte[] buffer;
    protected static final Logger logger = LoggerFactory.getLogger(PersistentList.class);

    PersistentList(RandomAccessFile file) {
        this.itemFile = file;
    }

    public static <T> PersistentList<T> create(RandomAccessFile file, ISerializator<T> s) {
        return new SerializatorPersistentList<T>(file, s);
    }

    public static <T extends ISerializable<?>> PersistentList<T> create(RandomAccessFile file, Class<T> c) {
        return new SerializablePersistentList<T>(file, c);
    }

    @Override
    public boolean add(E element) {
        try {
            this.itemFile.seek(this.getOffset(this.size));
            this.itemFile.write(this.getBytes(element));
            ++this.size;
            return true;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E element : c) {
            if (this.add(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    protected abstract byte[] getBytes(E var1);

    protected abstract E getElement(byte[] var1);

    @Override
    public void clear() {
        try {
            this.itemFile.setLength(0L);
            this.size = 0;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.buffer == null) {
            this.buffer = new byte[this.getElementLength()];
        }
        E element = null;
        try {
            this.itemFile.seek(this.getOffset(index));
            this.itemFile.read(this.buffer);
            element = this.getElement(this.buffer);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return element;
    }

    @Override
    public int indexOf(Object o) {
        int i = -1;
        ListIterator<E> it = this.listIterator();
        while (it.hasNext()) {
            i = it.nextIndex();
            if (!o.equals(it.next())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ItemListIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = -1;
        int i = -1;
        ListIterator<E> it = this.listIterator();
        while (it.hasNext()) {
            i = it.nextIndex();
            if (!o.equals(it.next())) continue;
            index = i;
        }
        return index;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ItemListIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ItemListIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (index != this.size - 1) {
            throw new IllegalArgumentException("The index should be the list's last element only.");
        }
        try {
            this.itemFile.seek(this.getOffset(index));
            this.itemFile.write(this.getBytes(element));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    private long getOffset(int index) {
        return index * this.getElementLength();
    }

    protected abstract int getElementLength();

    private class ItemListIterator
    implements ListIterator<E> {
        private int index;

        public ItemListIterator(int startIndex) {
            this.index = startIndex;
        }

        public ItemListIterator() {
            this(0);
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < PersistentList.this.size;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return PersistentList.this.get(this.index++);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return PersistentList.this.get(--this.index);
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

