/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.model.util;

import com.vmware.vide.vlogbrowser.core.model.util.IFilter;
import com.vmware.vide.vlogbrowser.core.model.util.IFilteredList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class FilteredList<E>
implements IFilteredList<E> {
    protected List<E> allItems;
    protected List<E> filteredItems;
    private List<IFilter<E>> filters = new ArrayList<IFilter<E>>();
    private static final int NUM_INC_STEPS = 10;

    public FilteredList() {
        this.allItems = new LinkedList();
        this.filteredItems = new LinkedList();
    }

    @Override
    public boolean add(E arg0) {
        this.allItems.add(arg0);
        return this.filteredItems.add(arg0);
    }

    @Override
    public void add(int arg0, E arg1) {
        this.allItems.add(arg0, arg1);
        this.filteredItems.add(arg0, arg1);
    }

    @Override
    public boolean addAll(Collection<? extends E> arg0) {
        this.allItems.addAll(arg0);
        return this.filteredItems.addAll(arg0);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends E> arg1) {
        this.allItems.addAll(arg0, arg1);
        return this.filteredItems.addAll(arg0, arg1);
    }

    @Override
    public void clear() {
        this.allItems.clear();
        this.filteredItems.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.filteredItems.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.filteredItems.containsAll(arg0);
    }

    @Override
    public E get(int arg0) {
        return this.filteredItems.get(arg0);
    }

    @Override
    public int indexOf(Object arg0) {
        return this.filteredItems.indexOf(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.filteredItems.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.filteredItems.iterator();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.filteredItems.lastIndexOf(arg0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.filteredItems.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int arg0) {
        return this.filteredItems.listIterator(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        this.allItems.remove(arg0);
        return this.filteredItems.remove(arg0);
    }

    @Override
    public E remove(int arg0) {
        this.allItems.remove(arg0);
        return this.filteredItems.remove(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        this.allItems.removeAll(arg0);
        return this.filteredItems.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        this.allItems.retainAll(arg0);
        return this.filteredItems.retainAll(arg0);
    }

    @Override
    public E set(int arg0, E arg1) {
        this.allItems.set(arg0, arg1);
        return this.filteredItems.set(arg0, arg1);
    }

    @Override
    public int size() {
        return this.filteredItems.size();
    }

    @Override
    public List<E> subList(int arg0, int arg1) {
        return this.filteredItems.subList(arg0, arg1);
    }

    @Override
    public Object[] toArray() {
        return this.filteredItems.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.filteredItems.toArray(arg0);
    }

    @Override
    public void addFilter(IFilter<E> filter) {
        this.filters.add(filter);
    }

    @Override
    public void removeFilter(IFilter<E> filter) {
        this.filters.remove(filter);
    }

    @Override
    public void setFilters(Collection<? extends IFilter<E>> c) {
        this.filters.clear();
        this.filters.addAll(c);
    }

    @Override
    public Collection<IFilter<E>> getFilters() {
        return this.filters;
    }

    @Override
    public List<E> getUnfiltered() {
        return Collections.unmodifiableList(this.allItems);
    }

    @Override
    public void refresh(IProgressMonitor monitor) {
        this.filteredItems.clear();
        int allItemsSize = this.allItems.size();
        monitor.beginTask("", allItemsSize);
        int inc = allItemsSize > 10 ? allItemsSize / 10 : 1;
        int i = 0;
        for (E item : this.allItems) {
            boolean shouldAdd = true;
            for (IFilter<E> filter : this.filters) {
                if (filter.select(item)) continue;
                shouldAdd = false;
                break;
            }
            if (shouldAdd) {
                this.filteredItems.add(item);
            }
            if (i++ % inc != 0) continue;
            monitor.worked(inc);
        }
        monitor.done();
    }

    @Override
    public void refresh() {
        this.refresh((IProgressMonitor)new NullProgressMonitor());
    }
}

