/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.model;

public class LogSystemType {
    private String system;
    private String version;
    private String parentDir;
    private String fileRegex;
    private String liveLogFilename;
    private boolean fileNumDescending;
    private SortMethod sortMethod;

    public LogSystemType(String system, String version, String parentDir, String fileRegex, String liveLog, boolean numDescending) {
        this(system, version, parentDir, fileRegex, liveLog, numDescending, SortMethod.Filename);
    }

    public LogSystemType(String system, String version, String parentDir, String fileRegex, String liveLog, boolean numDescending, SortMethod sortMethod) {
        this.system = system;
        this.version = version;
        this.parentDir = parentDir;
        this.fileRegex = fileRegex;
        this.liveLogFilename = liveLog;
        this.fileNumDescending = numDescending;
        this.sortMethod = sortMethod;
    }

    public String getSystem() {
        return this.system;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDir() {
        return this.parentDir;
    }

    public String getFileRegex() {
        return this.fileRegex;
    }

    public boolean isFileNumDescending() {
        return this.fileNumDescending;
    }

    public String getLiveLogFilename() {
        return this.liveLogFilename;
    }

    public SortMethod getSortMethod() {
        return this.sortMethod;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LogSystemType)) {
            return false;
        }
        LogSystemType o = (LogSystemType)obj;
        boolean b1 = this.system.equals(o.getSystem());
        boolean b2 = this.version.equals(o.getVersion());
        boolean b3 = this.fileRegex.equals(o.getFileRegex());
        boolean b4 = this.parentDir.equals(o.getDir());
        return b1 && b2 && b3 && b4;
    }

    public static enum SortMethod {
        Filename,
        Time,
        Filenum;

    }
}

