/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.model;

import com.vmware.vide.vlogbrowser.core.model.ISingleMatcher;
import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.model.MatcherFilter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;

public class GroupMatcherFilter
extends MatcherFilter {
    private int surroundingLines;
    private List<LogItem> items;
    private LinkedHashSet<Integer> cache = new LinkedHashSet();
    private int groupId = -1;
    private int indexPrevMatchedElement = -1;

    public GroupMatcherFilter(ISingleMatcher matcher, int surroundingLines, List<LogItem> items) {
        super(matcher);
        this.surroundingLines = surroundingLines;
        this.items = items;
    }

    @Override
    public boolean select(LogItem element) {
        ISingleMatcher m = this.getMatcher();
        int index = (int)element.getLogIndexNum() - 1;
        int pos = -1;
        if (m.matches(element)) {
            int i = 1;
            while (i <= this.surroundingLines) {
                pos = index + i;
                if (pos < this.items.size()) {
                    this.cache.add(pos);
                }
                ++i;
            }
            if (this.isDifferentGroup(index)) {
                ++this.groupId;
            }
            this.setElementGroupId(element, this.groupId);
            this.indexPrevMatchedElement = index;
            this.cache.remove(index);
            return true;
        }
        if (this.cache.contains(index)) {
            this.setElementGroupId(element, this.groupId);
            this.cache.remove(index);
            return true;
        }
        Stack<Integer> stack = new Stack<Integer>();
        int i = 1;
        while (i <= this.surroundingLines) {
            pos = index + i;
            if (pos < this.items.size()) {
                if (m.matches(this.items.get(pos))) {
                    while (!stack.empty()) {
                        this.cache.add((Integer)stack.pop());
                    }
                    if (this.isDifferentGroup(pos)) {
                        ++this.groupId;
                    }
                    this.setElementGroupId(element, this.groupId);
                    this.indexPrevMatchedElement = pos;
                    return true;
                }
                stack.push(pos);
            }
            ++i;
        }
        return false;
    }

    private void setElementGroupId(LogItem element, int id) {
        element.setAlwaysMatched(true);
        element.setGroupId(id);
    }

    private boolean isDifferentGroup(int indexCurrentMatch) {
        return this.indexPrevMatchedElement == -1 || Math.abs(this.indexPrevMatchedElement - indexCurrentMatch) > 2 * this.surroundingLines + 1;
    }
}

