/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.model;

import com.vmware.vide.vlogbrowser.core.consts.LogBrowserConsts;
import java.util.regex.Pattern;

public class FilterItem {
    private LogBrowserConsts.BooleanConnector boolConn;
    private boolean negateFlag;
    private String keyword;
    private boolean regexFlag;
    private Pattern regexPattern;

    public FilterItem() {
        this.init();
    }

    public void init() {
        this.boolConn = LogBrowserConsts.BooleanConnector.SKIP;
        this.negateFlag = false;
        this.keyword = "";
        this.regexFlag = false;
        this.regexPattern = null;
    }

    public LogBrowserConsts.BooleanConnector getBoolConnector() {
        return this.boolConn;
    }

    public void setBoolConnector(LogBrowserConsts.BooleanConnector boolConn) {
        this.boolConn = boolConn;
    }

    public boolean isNegateFlagSet() {
        return this.negateFlag;
    }

    public void setNegateFlag(boolean negateFlag) {
        this.negateFlag = negateFlag;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
        if (this.regexFlag) {
            this.regexPattern = Pattern.compile(keyword);
        }
    }

    public boolean isRegexFlagSet() {
        return this.regexFlag;
    }

    public void setRegexFlag(boolean regexFlag) {
        this.regexFlag = regexFlag;
        if (regexFlag) {
            this.regexPattern = Pattern.compile(this.keyword);
        }
    }

    public boolean evaluate(String sourceStr) {
        boolean found;
        boolean bl = this.regexFlag ? this.regexPattern.matcher(sourceStr).find() : (found = sourceStr.indexOf(this.keyword) > -1);
        return this.negateFlag ? !found : found;
    }

    public void setBoolConnector(String boolConnStr) {
        this.boolConn = boolConnStr.equals(LogBrowserConsts.BooleanConnector.AND.toString()) ? LogBrowserConsts.BooleanConnector.AND : (boolConnStr.equals(LogBrowserConsts.BooleanConnector.OR.toString()) ? LogBrowserConsts.BooleanConnector.OR : LogBrowserConsts.BooleanConnector.SKIP);
    }
}

