/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.fileops;

import com.vmware.vide.utils.net.NetUtils;
import com.vmware.vide.vlogbrowser.core.fileops.LogFileUtils;
import com.vmware.vide.vlogbrowser.core.parser.RAFile;
import com.vmware.vide.vlogbrowser.core.utils.Utils;
import java.io.File;

public class TempUnpackDir {
    public static final String UNIX_TEMP_DIR_PARENT = "/tmp";
    public static final String LOCALHOST_TEMP_DIR_PARENT = System.getProperty("java.io.tmpdir");
    private String cfgFileId;
    private String srcFileHost;
    private String srcArchivePath;
    private String srcFileParentDir;
    private String directory;

    public TempUnpackDir(String cfgFileId, RAFile raFile) throws Exception {
        String tempDirParent;
        this.cfgFileId = cfgFileId;
        this.srcFileHost = raFile.getSrcFileHost();
        this.srcArchivePath = raFile.getSrcArchivePath();
        this.srcFileParentDir = LogFileUtils.getParentDir(raFile.getSrcFilePath());
        if (NetUtils.isLocalHost((String)this.srcFileHost)) {
            tempDirParent = System.getenv("VMLB_TEMP_DIR");
            if (tempDirParent == null) {
                tempDirParent = LOCALHOST_TEMP_DIR_PARENT;
            }
        } else {
            tempDirParent = UNIX_TEMP_DIR_PARENT;
        }
        this.directory = String.valueOf(tempDirParent) + "/vLogBrowser-" + LogFileUtils.computeMD5Hash(String.valueOf(cfgFileId) + this.srcFileHost + this.srcArchivePath + this.srcFileParentDir);
    }

    public void createLocal() throws Exception {
        File myDir = new File(this.directory);
        if (!(new File(this.directory).mkdirs() || myDir.exists() && myDir.canWrite())) {
            throw new Exception("Temporary unpack directory " + this.directory + " for " + this.srcArchivePath + " could not be created or re-used.");
        }
    }

    public String getRemoteCreateCmd() {
        return "mkdir -p " + this.toString();
    }

    public String getSourceFileHost() {
        return this.srcFileHost;
    }

    public String toString() {
        return String.valueOf(this.directory) + Utils.getPathSep(this.srcFileHost);
    }

    public boolean equals(Object otherObj) {
        if (otherObj instanceof TempUnpackDir) {
            TempUnpackDir otherDir = (TempUnpackDir)otherObj;
            if (otherDir.cfgFileId.equals(this.cfgFileId) && otherDir.srcFileHost.equals(this.srcFileHost) && otherDir.srcArchivePath.equals(this.srcArchivePath) && otherDir.srcFileParentDir.equals(this.srcFileParentDir)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.directory.hashCode();
    }
}

