/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.fileops;

import com.vmware.vide.vlogbrowser.core.ILogBrowserManager;
import com.vmware.vide.vlogbrowser.core.LogBrowserPlugin;
import com.vmware.vide.vlogbrowser.core.model.LogFilter;
import com.vmware.vide.vlogbrowser.core.model.LogSystemType;
import com.vmware.vide.vlogbrowser.core.model.LogxFile;
import com.vmware.vide.vlogbrowser.core.parser.ConfigParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class LogxFileSetCreator {
    private List<LogxFile> myLxFiles = new ArrayList<LogxFile>();
    private String projectContainer = "";

    public List<LogxFile> getLxFiles() {
        return this.myLxFiles;
    }

    public void setProject(String name) {
        this.projectContainer = name;
    }

    public String getProject() {
        return this.projectContainer;
    }

    public String checkLogxFilenames() {
        for (LogxFile lxFile : this.myLxFiles) {
            if (!lxFile.isCreateThisFile()) continue;
            String fileName = lxFile.getLogxFileName();
            if (fileName == null || fileName.length() == 0) {
                return "File name for '" + lxFile.toSummaryString() + "' must be specified";
            }
            if (new File(fileName).getParent() != null) {
                return "File name for '" + lxFile.toSummaryString() + "' must not include a" + " parent directory.";
            }
            int dotLoc = fileName.lastIndexOf(46);
            if (dotLoc != -1) {
                String ext = fileName.substring(dotLoc + 1);
                if (!ext.equalsIgnoreCase("logx")) {
                    return "File extension for '" + lxFile.toSummaryString() + "' must be \"logx\"";
                }
                if (dotLoc == 0) {
                    return "File name for '" + lxFile.toSummaryString() + "' must be specified";
                }
            }
            if (!this.isUniqueInProject(lxFile.getLogxFileName())) {
                return "File name " + lxFile.getLogxFileName() + " already exists. It" + " must be unique within project " + this.projectContainer;
            }
            if (this.isFileUniqueInTable(lxFile)) continue;
            return "File name " + lxFile.getLogxFileName() + " is already in use in" + " the table.";
        }
        return null;
    }

    private boolean isUniqueInProject(String proposedName) {
        IFile file;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.projectContainer));
        IProject project = null;
        if (container != null) {
            project = container.getProject();
        }
        return project == null || !(file = project.getFile(proposedName)).exists();
    }

    private boolean isFileUniqueInTable(LogxFile lxFile) {
        for (LogxFile otherLxFile : this.myLxFiles) {
            if (!otherLxFile.isCreateThisFile() || lxFile.equals(otherLxFile) || !lxFile.getLogxFileName().equals(otherLxFile.getLogxFileName())) continue;
            return false;
        }
        return true;
    }

    public String getUniqueLogxFilename(String srcHost, String logFormat, boolean isVMSuppArc) {
        String lxFilenamePrefix = String.valueOf(srcHost) + "_" + logFormat + (isVMSuppArc ? "_vmsp" : "");
        lxFilenamePrefix = lxFilenamePrefix.replace(' ', '_');
        int count = 1;
        String uniqueNumStr = "";
        while (!this.isUniqueInProject(String.valueOf(lxFilenamePrefix) + uniqueNumStr + ".logx")) {
            uniqueNumStr = Integer.toString(count++);
        }
        return String.valueOf(lxFilenamePrefix) + uniqueNumStr + ".logx";
    }

    public String getLogxFilename(String srcHost, String logFormat, boolean isVMSuppArc) {
        String lxFilenamePrefix = String.valueOf(srcHost) + "_" + logFormat + (isVMSuppArc ? "_vmsp" : "");
        lxFilenamePrefix = lxFilenamePrefix.replace(' ', '_');
        return String.valueOf(lxFilenamePrefix) + ".logx";
    }

    public void addLogxFilesToList(String hostname, LogxFile selectedFormat, String selectedFormatName, String tgzFilepath, String parentDir, String filePatterns) throws Exception {
        this.addLogxFilesToList(hostname, selectedFormat, selectedFormatName, tgzFilepath, parentDir, filePatterns, true);
    }

    public void addLogxFilesToList(String hostname, LogxFile selectedFormat, String selectedFormatName, String tgzFilepath, String parentDir, String filePatterns, boolean allowGuiOperations) throws Exception {
        ILogBrowserManager manager = LogBrowserPlugin.getDefault().getLogBrowserManager();
        manager.setRecentHost(hostname);
        String formatToSave = selectedFormat == null ? selectedFormatName : String.valueOf(selectedFormat.getCategory()) + "/" + selectedFormat.getLogFormatName();
        manager.setRecentHostFormat(hostname, formatToSave);
        this.myLxFiles.clear();
        boolean isStdPkg = selectedFormatName.equals("[Standard Log Collection]");
        boolean isVMSuppArc = selectedFormatName.equals("[VMware Log Bundle]");
        if (isStdPkg || isVMSuppArc) {
            LogxFile[] templates = null;
            if (isStdPkg) {
                templates = allowGuiOperations ? manager.getLogFormatsByHost(hostname, true) : manager.getLogFormatsByHostService(hostname, true);
            }
            String orgHostname = hostname;
            if (isVMSuppArc) {
                LogSystemType tgzSysType = allowGuiOperations ? manager.getTgzFileType(hostname, tgzFilepath) : manager.getTgzFileTypeService(hostname, tgzFilepath);
                if (tgzSysType != null) {
                    templates = tgzSysType.getSystem() != null && tgzSysType.getSystem().equals("VC") ? manager.getLogFormatsByHosttype(tgzSysType.getSystem(), tgzSysType.getVersion(), false) : manager.getLogFormatsByHosttype(tgzSysType.getSystem(), tgzSysType.getVersion(), true);
                    orgHostname = tgzSysType.getDir();
                } else {
                    throw new IllegalArgumentException("File '" + tgzFilepath + "' does not appear to be a valid log bundle.");
                }
            }
            if (templates != null) {
                LogxFile[] logxFileArray = templates;
                int n = templates.length;
                int n2 = 0;
                while (n2 < n) {
                    LogxFile template = logxFileArray[n2];
                    String logFormatName = template.getLogFormatName();
                    String category = template.getCategory();
                    boolean okFromSupportBundle = template.isOkFromSupportBundle();
                    String templateFile = template.getTemplateFilePath();
                    LogSystemType systemType = template.getSystemType();
                    LogxFile lxFile = new LogxFile(logFormatName, category, templateFile, systemType, okFromSupportBundle);
                    lxFile.setSrcHost(hostname);
                    lxFile.setLogxFileName(this.getUniqueLogxFilename(orgHostname, logFormatName, isVMSuppArc));
                    lxFile.setCreateThisFile(true);
                    lxFile.setOpenEditor(false);
                    if (isVMSuppArc) {
                        lxFile.setArchivePath(String.valueOf(parentDir) + filePatterns);
                    }
                    if (!this.myLxFiles.contains(lxFile) && okFromSupportBundle) {
                        this.myLxFiles.add(lxFile);
                    }
                    ++n2;
                }
            }
        } else {
            LogxFile selectedTemplate = selectedFormat;
            String filePtrns = "";
            filePtrns = filePatterns.startsWith("(Regular Expression: ") ? selectedTemplate.getSystemType().getFileRegex() : filePatterns;
            LogSystemType sysType = selectedTemplate.getSystemType();
            LogSystemType newSysType = new LogSystemType(sysType.getSystem(), sysType.getVersion(), parentDir, filePtrns, sysType.getLiveLogFilename(), sysType.isFileNumDescending(), sysType.getSortMethod());
            LogxFile lxFile = new LogxFile(selectedTemplate.getLogFormatName(), selectedTemplate.getCategory(), selectedTemplate.getTemplateFilePath(), newSysType);
            lxFile.setSrcHost(hostname);
            String logxFilename = this.getUniqueLogxFilename(hostname, selectedTemplate.getLogFormatName(), isVMSuppArc);
            lxFile.setLogxFileName(logxFilename);
            lxFile.setCreateThisFile(true);
            lxFile.setOpenEditor(true);
            if (!filePatterns.startsWith("(Regular Expression: ")) {
                String[] logFileArr = filePtrns.split(";");
                ArrayList<String> logFileList = new ArrayList<String>();
                String[] stringArray = logFileArr;
                int n = logFileArr.length;
                int n3 = 0;
                while (n3 < n) {
                    String logFileStr = stringArray[n3];
                    logFileList.add(String.valueOf(logFileStr) + "$");
                    ++n3;
                }
                lxFile.setFileRegexes(logFileList);
            }
            if (!this.myLxFiles.contains(lxFile)) {
                this.myLxFiles.add(lxFile);
            }
        }
    }

    public static IResource getLogxResource(String containerName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = null;
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            project = root.getProject(containerName);
            String descStr = containerName.replaceAll("[\\:/\\\\]", "_");
            IProjectDescription projDesc = ResourcesPlugin.getWorkspace().newProjectDescription(descStr);
            projDesc.setLocation(null);
            project.create(projDesc, null);
            project.open(null);
            resource = project;
        }
        if (!resource.exists() || !(resource instanceof IContainer)) {
            return null;
        }
        return resource;
    }

    public static ConfigParser createParserForLogxFile(LogxFile lxFile) throws Exception {
        String archivePath = lxFile.getArchivePath();
        String logFilePaths = lxFile.getSystemType().getFileRegex();
        String srcHostChoice = lxFile.getSrcHost();
        String parentDir = lxFile.getSystemType().getDir();
        List<String> fileRegexList = lxFile.getFileRegexes();
        File templatePath = new File(lxFile.getTemplateFilePath());
        FileInputStream beforeStream = new FileInputStream(templatePath);
        ConfigParser cfgParser = null;
        cfgParser = new ConfigParser(null, beforeStream);
        ((InputStream)beforeStream).close();
        String[] fileRegexArr = null;
        fileRegexArr = fileRegexList != null && fileRegexList.size() > 0 ? fileRegexList.toArray(new String[fileRegexList.size()]) : new String[]{logFilePaths};
        cfgParser.addSrcLogFileNode(srcHostChoice, parentDir, archivePath, fileRegexArr);
        return cfgParser;
    }

    public static boolean createLogxFile(String containerName, LogxFile lxFile, List<LogFilter> filterOverrides, IProgressMonitor monitor) throws Exception {
        String tmpFileName;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!(tmpFileName = lxFile.getLogxFileName()).endsWith(".logx")) {
            tmpFileName = String.valueOf(tmpFileName) + ".logx";
        }
        String fileName = tmpFileName;
        monitor.beginTask("Creating " + fileName, 2);
        monitor.setTaskName("Creating " + fileName);
        ConfigParser cfgParser = null;
        try {
            cfgParser = LogxFileSetCreator.createParserForLogxFile(lxFile);
        }
        catch (Exception exception) {
            throw new CoreException(null);
        }
        if (filterOverrides != null) {
            for (LogFilter f : filterOverrides) {
                cfgParser.addLogFilterNode(f);
            }
        }
        IResource resource = LogxFileSetCreator.getLogxResource(containerName);
        IContainer container = (IContainer)resource;
        IFile file = container.getFile((IPath)new Path(fileName));
        try {
            String xmlString = cfgParser.getXmlFromDocument();
            byte[] xmlByteArr = xmlString.getBytes();
            ByteArrayInputStream afterStream = new ByteArrayInputStream(xmlByteArr);
            if (file.exists()) {
                file.setContents((InputStream)afterStream, true, true, null);
            } else {
                file.create((InputStream)afterStream, true, null);
            }
            ((InputStream)afterStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
            LogBrowserPlugin.log(e);
        }
        monitor.worked(1);
        return true;
    }
}

