/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.fileops;

import com.jcraft.jsch.JSchException;
import com.vmware.vide.target.api.ICommandOutputChangedEvent;
import com.vmware.vide.target.api.ICommandOutputListener;
import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetFile;
import com.vmware.vide.target.api.ITargetManagerInitListener;
import com.vmware.vide.target.api.TargetManagerPlugin;
import com.vmware.vide.utils.digest.DigestHelper;
import com.vmware.vide.utils.local.ArchiveUtils;
import com.vmware.vide.vlogbrowser.core.consts.LogBrowserConsts;
import com.vmware.vide.vlogbrowser.core.fileops.CommandData;
import com.vmware.vide.vlogbrowser.core.fileops.TempUnpackDir;
import com.vmware.vide.vlogbrowser.core.parser.RAFile;
import com.vmware.vide.vlogbrowser.core.utils.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.services.files.RemoteFileIOException;

public class LogFileUtils {
    public static final int ZIP_BUFFER_SIZE = 512;

    public static void uploadFile(ITarget target, String filePath, String destDir) throws Exception {
        target.connect(null);
        target.uploadFile(new File(filePath), destDir, null);
    }

    public static void downloadFile(ITarget target, String remoteFilePath, File localFile, IProgressMonitor monitor) throws Exception {
        try {
            ITargetFile srcFile = target.getTargetFile(remoteFilePath, null);
            if (!localFile.exists() || srcFile.length() != localFile.length()) {
                target.connect(null);
                target.downloadFile(remoteFilePath, localFile, monitor);
            }
        }
        catch (RemoteFileIOException e) {
            Exception remoteException = e.getRemoteException();
            if (remoteException instanceof JSchException && "channel is not opened.".equals(remoteException.getMessage())) {
                StringBuilder sb = new StringBuilder();
                sb.append("SSH exception: ");
                sb.append(remoteException.getMessage());
                sb.append("\n");
                sb.append("Please verify on the remote machine's /etc/ssh/sshd_config that MaxSession is commented or, ");
                sb.append("if it is not, its value is > than 1.");
                throw new RuntimeException(sb.toString(), e);
            }
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to download '");
            sb.append(remoteFilePath);
            sb.append("' from ");
            sb.append(target.getHostName());
            sb.append(": ");
            sb.append(e.getMessage());
            String message = sb.toString();
            throw new RuntimeException(message, e);
        }
    }

    public static File downloadBundle(ITarget target, String remoteFilePath, IProgressMonitor monitor) throws Exception {
        File bundleDir = new File(LogBrowserConsts.CACHE_DIR, "bundles");
        if (!bundleDir.exists()) {
            bundleDir.mkdirs();
        }
        File dstFile = new File(bundleDir, LogFileUtils.getFilename(remoteFilePath));
        LogFileUtils.downloadFile(target, remoteFilePath, dstFile, monitor);
        return dstFile;
    }

    public static CommandData executeCommand(ITarget target, String command) throws Exception {
        if (target == null) {
            throw new Exception("Error: cannot execute command '" + command + "' because target is null!");
        }
        target.connect(null);
        CommandData output = new CommandData();
        class OutputListener
        implements ICommandOutputListener {
            private int count = 0;
            private List<String> lines = new ArrayList<String>();

            OutputListener() {
            }

            public synchronized void commandOutputChanged(ICommandOutputChangedEvent event) {
                String[] output = event.getOutputLines();
                int i = 0;
                while (i < output.length) {
                    this.lines.add(output[i]);
                    ++i;
                }
                this.count += output.length;
            }

            public synchronized String[] getLines() {
                return this.lines.toArray(new String[this.lines.size()]);
            }
        }
        OutputListener outputListener = new OutputListener();
        try {
            int executeCommand = target.executeCommand(command, (ICommandOutputListener)outputListener, null);
            output.setReturnCode(executeCommand);
        }
        catch (Exception e) {
            System.out.println("Caught an exception trying to setReturnCode " + e.getMessage());
            e.printStackTrace();
        }
        output.setOutput(LogFileUtils.arrayToString(outputListener.getLines(), "\n"));
        return output;
    }

    public static ITarget getTarget(String targetName) throws Exception {
        LogFileUtils.waitForRSEInit();
        return TargetManagerPlugin.getTheTargetManager().findTarget(targetName);
    }

    @Deprecated
    public static String[] getAllTargetNames(IProgressMonitor myMonitor) throws Exception {
        myMonitor.subTask("Initializing Remote System Explorer...");
        LogFileUtils.waitForRSEInit();
        myMonitor.worked(1);
        myMonitor.subTask("Retrieving remote connection list...");
        ITarget[] targets = TargetManagerPlugin.getTheTargetManager().getTargets();
        ArrayList<String> targetList = new ArrayList<String>();
        targetList.add("localhost");
        int i = 0;
        while (i < targets.length) {
            String name = targets[i].getName();
            if (!name.equalsIgnoreCase("localhost") && !name.equalsIgnoreCase("local")) {
                targetList.add(name);
            }
            ++i;
        }
        myMonitor.worked(1);
        return targetList.toArray(new String[targetList.size()]);
    }

    public static List<String> getTargetList(boolean prependLocalhost) throws Exception {
        ITarget[] targets = TargetManagerPlugin.getTheTargetManager().getTargets();
        ArrayList<String> targetList = new ArrayList<String>();
        if (prependLocalhost) {
            targetList.add("Local");
        }
        int i = 0;
        while (i < targets.length) {
            String name = targets[i].getName();
            if (!name.equalsIgnoreCase("Local") && !name.equalsIgnoreCase("local")) {
                targetList.add(name);
            }
            ++i;
        }
        return targetList;
    }

    private static void waitForRSEInit() throws Exception {
        WaitForRSEInit waitForIt = new WaitForRSEInit(TargetManagerPlugin.getTheTargetManager().isInitialized());
        TargetManagerPlugin.getTheTargetManager().addInitListener((ITargetManagerInitListener)waitForIt);
        if (!TargetManagerPlugin.getTheTargetManager().isInitialized()) {
            waitForIt.waitForInit();
        }
    }

    public static void createESXTarget(String targetName, String hostNetName, String userID, String pswd) throws Exception {
        if (LogFileUtils.getTarget(targetName) != null) {
            return;
        }
        String targetType = "esx";
        ITarget myTarget = TargetManagerPlugin.getTheTargetManager().createTarget(targetType, targetName, hostNetName);
        myTarget.setUserId(userID);
        myTarget.setPassword(pswd, true);
    }

    public static String arrayToString(String[] stringArray, String delimiter) {
        StringBuffer resultBuffer = new StringBuffer();
        if (stringArray.length > 0) {
            resultBuffer.append(stringArray[0]);
            int i = 1;
            while (i < stringArray.length) {
                resultBuffer.append(delimiter);
                resultBuffer.append(stringArray[i]);
                ++i;
            }
        }
        return resultBuffer.toString();
    }

    public static CommandData runLocalCommand(String[] localCommand, String parentDir) throws Exception {
        CommandData returnData = new CommandData();
        ProcessBuilder processBuilder = new ProcessBuilder(localCommand);
        processBuilder.directory(new File(parentDir));
        Process proc = processBuilder.start();
        InputStream input = proc.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        String line = null;
        StringBuffer resultBuffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            resultBuffer.append("\n");
            resultBuffer.append(line);
        }
        returnData.setReturnCode(proc.waitFor());
        returnData.setOutput(resultBuffer.toString());
        return returnData;
    }

    public static boolean deleteDirTree(File directoryTree) {
        if (directoryTree.isFile() || directoryTree.list() != null && directoryTree.list().length == 0) {
            return directoryTree.delete();
        }
        File[] dirContents = directoryTree.listFiles();
        if (dirContents != null) {
            File[] fileArray = dirContents;
            int n = dirContents.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!LogFileUtils.deleteDirTree(file)) {
                    return false;
                }
                ++n2;
            }
        }
        return directoryTree.delete();
    }

    public static String computeMD5Hash(String plainText) throws Exception {
        return DigestHelper.getMd5((String)plainText);
    }

    public static String padZeros(String missingLeadingZeros, int places) {
        String leadingZeros = "";
        int i = 0;
        while (i < places - missingLeadingZeros.length()) {
            leadingZeros = String.valueOf(leadingZeros) + "0";
            ++i;
        }
        return String.valueOf(leadingZeros) + missingLeadingZeros;
    }

    public static String concatPath(String path, char glue) {
        String returnStr = new String(path);
        returnStr = returnStr.replace('/', glue);
        returnStr = returnStr.replace('\\', glue);
        returnStr = returnStr.replace(':', glue);
        returnStr = returnStr.replace('.', glue);
        return returnStr;
    }

    public static void localFileCopy(File src, File dest) throws Exception {
        if (!src.exists() || !src.canRead()) {
            throw new Exception("Cannot read from source file");
        }
        if (dest.isDirectory()) {
            LogFileUtils.deleteDirTree(dest);
        } else {
            dest.delete();
        }
        if (!dest.createNewFile()) {
            throw new Exception("Destination file could not be created or overwritten.");
        }
        FileChannel srcChannel = new FileInputStream(src).getChannel();
        FileChannel destChannel = new FileOutputStream(dest).getChannel();
        try {
            try {
                srcChannel.transferTo(0L, srcChannel.size(), destChannel);
            }
            catch (Exception e) {
                throw new Exception("Failed to copy " + src.getAbsolutePath() + " to " + dest.getAbsolutePath() + " " + e.getMessage());
            }
        }
        finally {
            if (srcChannel != null) {
                srcChannel.close();
            }
            if (destChannel != null) {
                destChannel.close();
            }
        }
    }

    public static void extractFileFromTgz(String tgzFile, String srcFile, File destFile) throws Exception {
        GZIPInputStream gis = new GZIPInputStream(new FileInputStream(new File(tgzFile)));
        TarInputStream tarInStrm = new TarInputStream((InputStream)gis);
        TarEntry tarEntry = null;
        while ((tarEntry = tarInStrm.getNextEntry()) != null && (tarEntry.isDirectory() || !tarEntry.getName().equals(srcFile))) {
        }
        if (tarEntry != null) {
            File targetDir = destFile.getParentFile();
            if (targetDir != null) {
                targetDir.mkdirs();
            }
            FileOutputStream outFile = new FileOutputStream(destFile);
            tarInStrm.copyEntryContents((OutputStream)outFile);
            outFile.close();
        }
    }

    public static void decompressFileInZipArchive(File archiveFile, String internalFilePath, File targetFile) throws ZipException, IOException {
        ZipFile zipFile = new ZipFile(archiveFile);
        ZipEntry zipEntry = zipFile.getEntry(internalFilePath);
        InputStream zipInputStrm = zipFile.getInputStream(zipEntry);
        BufferedInputStream buffInputStrm = new BufferedInputStream(zipInputStrm);
        byte[] byteBuffer = new byte[512];
        FileOutputStream fileOutputStrm = new FileOutputStream(targetFile);
        BufferedOutputStream buffOutputStrm = new BufferedOutputStream(fileOutputStrm, 512);
        int count = 0;
        while ((count = buffInputStrm.read(byteBuffer, 0, 512)) != -1) {
            buffOutputStrm.write(byteBuffer, 0, count);
        }
        buffOutputStrm.flush();
        buffOutputStrm.close();
        buffInputStrm.close();
    }

    public static void decompressGzipFile(File gZipFile, String outputFilePath) throws IOException {
        FileInputStream fileInputStrm = new FileInputStream(gZipFile);
        GZIPInputStream gZipInputStrm = new GZIPInputStream(fileInputStrm);
        byte[] byteBuffer = new byte[512];
        FileOutputStream fileOutputStrm = new FileOutputStream(outputFilePath);
        BufferedOutputStream buffOutputStrm = new BufferedOutputStream(fileOutputStrm, 512);
        int count = 0;
        while ((count = gZipInputStrm.read(byteBuffer, 0, 512)) != -1) {
            buffOutputStrm.write(byteBuffer, 0, count);
        }
        buffOutputStrm.flush();
        buffOutputStrm.close();
        gZipInputStrm.close();
    }

    public static void extractFileFromArchive(String srcArchivePath, String srcLogFilePath, File targetFile, String uniqueId, Set<TempUnpackDir> unpackDirs, RAFile raFile) throws Exception {
        ArrayList<String> localCommandsRun = new ArrayList<String>();
        File archive = new File(srcArchivePath);
        if (ArchiveUtils.isGZipTarFile((File)archive)) {
            if (Utils.isPlatformWindows()) {
                LogFileUtils.extractFileFromTgz(srcArchivePath, srcLogFilePath, targetFile);
            } else {
                TempUnpackDir tempUnpackDir = new TempUnpackDir(uniqueId, raFile);
                tempUnpackDir.createLocal();
                String commandParam = "tar -xzf " + LogFileUtils.escapeSpaces(srcArchivePath) + " " + " -C " + tempUnpackDir.toString() + " " + LogFileUtils.escapeSpaces(LogFileUtils.getParentDir(raFile.getSrcFilePath()));
                if (!localCommandsRun.contains(commandParam)) {
                    String[] localCommand = new String[]{"/bin/sh", "-c", commandParam};
                    LogFileUtils.runLocalCommand(localCommand, LogFileUtils.getParentDir(srcArchivePath));
                    localCommandsRun.add(commandParam);
                    unpackDirs.add(tempUnpackDir);
                }
                srcLogFilePath = String.valueOf(tempUnpackDir.toString()) + srcLogFilePath;
                LogFileUtils.localFileCopy(new File(srcLogFilePath), targetFile);
            }
        } else if (ArchiveUtils.isZipFile((File)archive)) {
            LogFileUtils.decompressFileInZipArchive(archive, srcLogFilePath, targetFile);
        }
    }

    public static String getParentDir(String fullPath, String pathSep) {
        int sepLoc;
        if (fullPath == null || fullPath.length() == 0) {
            return "";
        }
        if (pathSep == null || pathSep.isEmpty()) {
            pathSep = File.separator;
        }
        if ((sepLoc = fullPath.lastIndexOf(pathSep)) == -1) {
            return "";
        }
        return fullPath.substring(0, sepLoc + 1);
    }

    public static String getParentDir(String fullPath) {
        return LogFileUtils.getParentDir(fullPath, null);
    }

    public static String getFileName(String fullPath) {
        if (fullPath == null || fullPath.length() == 0) {
            return "";
        }
        return new File(fullPath).getName();
    }

    public static String getFileNameWithoutExt(String fullPath) {
        String fileName = LogFileUtils.getFileName(fullPath);
        return LogFileUtils.getSubStringByRegEx(fileName, "^([^\\.\\d]+)", 0);
    }

    private static String getSubStringByRegEx(String srcStr, String regEx, int regExGroup, int desiredMatchIndex) {
        String retStr = "";
        Pattern regexMatch = Pattern.compile(regEx);
        Matcher matcher = regexMatch.matcher(srcStr);
        int matchCount = 0;
        while (matcher.find()) {
            ++matchCount;
            try {
                int startIdx = matcher.start(regExGroup);
                int endIdx = matcher.end(regExGroup);
                retStr = srcStr.substring(startIdx, endIdx);
            }
            catch (Exception exception) {}
            if (matchCount == desiredMatchIndex) break;
        }
        return retStr;
    }

    public static String getSubStringByRegEx(String srcStr, String regEx, int regExGroup) {
        return LogFileUtils.getSubStringByRegEx(srcStr, regEx, regExGroup, 1);
    }

    public static String getLastSubStringByRegEx(String srcStr, String regEx, int regExGroup) {
        return LogFileUtils.getSubStringByRegEx(srcStr, regEx, regExGroup, Integer.MAX_VALUE);
    }

    public static String getFileListStr(List<RAFile> raFiles) {
        StringBuffer retBuff = new StringBuffer(100);
        int totalSizeInBytes = 0;
        int i = 0;
        while (i < raFiles.size()) {
            totalSizeInBytes += raFiles.get(i).getSizeInBytes();
            retBuff.append(String.valueOf(i) + ". " + raFiles.get(i).toDisplayString() + "\n");
            ++i;
        }
        retBuff.append("\nTotal Size = " + totalSizeInBytes / 1024 + "." + LogFileUtils.padZeros(Integer.toString(totalSizeInBytes % 1024), 3) + " KB");
        return retBuff.toString();
    }

    public static String formatElapsedTime(long timeInMillis) {
        if (timeInMillis == 0L) {
            return "0";
        }
        String sign = timeInMillis < 0L ? "-" : "+";
        timeInMillis = Math.abs(timeInMillis);
        long days = timeInMillis / 86400000L;
        long dayFraction = timeInMillis % 86400000L;
        long hours = dayFraction / 3600000L;
        long hourFraction = dayFraction % 3600000L;
        long minutes = hourFraction / 60000L;
        long minuteFraction = hourFraction % 60000L;
        long seconds = minuteFraction / 1000L;
        long secondFraction = minuteFraction % 1000L;
        return String.valueOf(sign) + (days > 0L ? String.valueOf(days) + "d " : "") + (hours > 0L ? String.valueOf(hours) + "h " : "") + (minutes > 0L ? String.valueOf(minutes) + "m " : "") + (minuteFraction > 0L ? String.valueOf(seconds) + "." + secondFraction + "s" : "");
    }

    public static String formatElapsedTime(Date myDate) {
        return LogFileUtils.formatElapsedTime(myDate.getTime());
    }

    public static String formatManifestDate(Calendar c) {
        String theString = c.get(1) + "-" + (c.get(2) + 1) + "-" + c.get(5) + " " + c.get(11) + ":" + c.get(12) + ":" + c.get(13);
        return theString;
    }

    public static String formatManifestDate(Date d) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(d);
    }

    public static boolean arrayContains(Object[] objArr, Object value) {
        if (objArr == null || objArr.length == 0 || value == null) {
            return false;
        }
        Object[] objectArray = objArr;
        int n = objArr.length;
        int n2 = 0;
        while (n2 < n) {
            Object objArrValue = objectArray[n2];
            if (objArrValue.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String escapeSpaces(String inputStr) {
        return inputStr.trim().replaceAll("\\s", Matcher.quoteReplacement("\\ "));
    }

    public static String getFilename(String absPath) {
        Matcher m = Pattern.compile("[\\.\\w]+$").matcher(absPath);
        if (m.find()) {
            return m.group();
        }
        return null;
    }

    public static String getDirectory(String absPath) {
        Matcher m = Pattern.compile(".*[\\/]").matcher(absPath);
        if (m.find()) {
            return m.group();
        }
        return null;
    }

    private static class WaitForRSEInit
    implements ITargetManagerInitListener {
        boolean initComplete;

        public WaitForRSEInit(boolean alreadyInitialized) {
            this.initComplete = alreadyInitialized;
        }

        public synchronized void phaseComplete(int phase) {
            if (phase == 0) {
                this.initComplete = true;
            }
            this.notifyAll();
        }

        public synchronized void waitForInit() throws Exception {
            while (!this.initComplete) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

