/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.fileops;

import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetFile;
import com.vmware.vide.target.utils.path.RemotePath;
import com.vmware.vide.utils.local.ArchiveUtils;
import com.vmware.vide.vlogbrowser.core.LogBrowserPlugin;
import com.vmware.vide.vlogbrowser.core.consts.LogBrowserConsts;
import com.vmware.vide.vlogbrowser.core.fileops.BaseLogWorker;
import com.vmware.vide.vlogbrowser.core.fileops.CommandData;
import com.vmware.vide.vlogbrowser.core.fileops.LogFileUtils;
import com.vmware.vide.vlogbrowser.core.fileops.TempUnpackDir;
import com.vmware.vide.vlogbrowser.core.fileops.UnknownFileFormatException;
import com.vmware.vide.vlogbrowser.core.model.LocationAndFilePattern;
import com.vmware.vide.vlogbrowser.core.model.LogSystemType;
import com.vmware.vide.vlogbrowser.core.parser.ConfigParser;
import com.vmware.vide.vlogbrowser.core.parser.ManifestFile;
import com.vmware.vide.vlogbrowser.core.parser.RAFile;
import com.vmware.vide.vlogbrowser.core.parser.SolFileParser;
import com.vmware.vide.vlogbrowser.core.utils.Utils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFileManager {
    private static final Logger logger = LoggerFactory.getLogger(LogFileManager.class);
    protected ConfigParser cfgParser;
    protected File stagingDirectory;
    protected ManifestFile mfstFile;
    public static final String LOCALHOST = "Local";
    public static final String LOCALHOSTURL = "localhost";
    public static final String SHELL_EXEC = "/bin/sh";
    public static final String SHELL_CMD_SWITCH = "-c";
    public static final String SHELL_LS_CMD = "ls";
    public static final String SHELL_TAR_CMD = "tar";
    public static final String GNU_LS_PARAMS = " -l --time-style=long-iso ";
    public static final int GNU_LS_LINE_REGEX_FILENAME_GROUP = 3;
    public static final String GNU_LS_LINE_REGEX = "[-rwx]+\\s+\\d+\\s+\\S+\\s+\\S+\\s+(\\d+)\\s(\\d\\d\\d\\d-\\d\\d-\\d\\d\\s\\d\\d:\\d\\d)\\s";
    public static final String LONG_ISO_TIMESTAMP = "yyyy-MM-dd HH:mm";
    private static final DateFormat[] LONG_ISO_TIMESTAMP_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm")};
    public static final String BUSYBOX_LS_PARAMS = " -lu -e ";
    public static final int BUSYBOX_LS_LINE_REGEX_FILENAME_GROUP = 3;
    public static final String BUSYBOX_LS_LINE_REGEX = "[-rwx]+\\s+\\d+\\s+\\S+\\s+\\S+\\s+(\\d+)\\s(\\w\\w\\w\\s\\w\\w\\w\\s+\\d+\\s\\d\\d:\\d\\d:\\d\\d\\s\\d\\d\\d\\d)\\s";
    public static final String BUSYBOX_LS_TIMESTAMP = "EEE MMM d HH:mm:ss yyyy";
    private static final DateFormat[] BUSYBOX_LS_TIMESTAMP_FORMATS = new DateFormat[]{new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy"), new SimpleDateFormat("yyyy-MM-dd HH:mm")};
    public static final String SHELL_UNZIP_CMD = "unzip";
    public static final String UNZIP_LIST_PARAMS = " -l ";
    public static final String UNZIP_EXTRACT_PARAMS = " ";
    public static final String UNZIP_LIST_LINE_REGEX = "\\s*(\\d+)\\s+(\\d\\d-\\d\\d-\\d\\d \\d+:\\d\\d)\\s+";
    public static final int UNZIP_LIST_LINE_REGEX_FILENAME_GROUP = 3;
    public static final String UNZIP_LIST_TIMESTAMP = "MM-dd-yy HH:mm";
    private static final DateFormat[] UNZIP_LIST_TIMESTAMP_FORMATS = new DateFormat[]{new SimpleDateFormat("MM-dd-yy HH:mm"), new SimpleDateFormat("yyyy-MM-dd HH:mm")};
    public static final String TGZ_LIST_PARAMS = " -tzvf ";
    public static final String TGZ_EXTRACT_PARAMS = " -xzf ";
    public static final String TGZ_CHANGE_DIR_PARAM = " -C ";
    public static final int TAR_LINE_REGEX_FILENAME_GROUP = 4;
    public static final String TAR_LINE_REGEX = "[-rwx]+\\s+\\S+\\s+(\\d+)\\s(\\d\\d\\d\\d-\\d\\d-\\d\\d\\s\\d\\d:\\d\\d(:\\d\\d)*)\\s";
    public static final String TAR_TIMESTAMP = "yyyy-MM-dd HH:mm:ss";
    private static final DateFormat[] TAR_TIMESTAMP_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mm")};
    public static final String MAC_TAR_LINE_REGEX = "[-rwx]+\\s+\\S+\\s\\S+\\s+\\S+\\s+(\\d+)\\s+(\\S+\\s+\\d+\\s+\\d+[\\:0-9]*)\\s";
    public static final String MAC_TAR_TIMESTAMP1 = "MMM dd HH:mm";
    public static final String MAC_TAR_TIMESTAMP2 = "MMM dd  yyyy";
    private static final DateFormat[] MAC_TAR_TIMESTAMP_FORMATS = new DateFormat[]{new SimpleDateFormat("MMM dd HH:mm"), new SimpleDateFormat("MMM dd  yyyy"), new SimpleDateFormat("yyyy-MM-dd HH:mm")};
    public static final int MAC_TAR_LINE_REGEX_FILENAME_GROUP = 3;
    private static Map<String, CachedArchiveInfo> archivePathToCacheInfoMap = new HashMap<String, CachedArchiveInfo>();

    public LogFileManager(ConfigParser cfgParser) throws Exception {
        this.cfgParser = cfgParser;
        String cfgFilePathID = cfgParser.getUniqueID();
        this.stagingDirectory = new File(LogBrowserConsts.CACHE_DIR, cfgFilePathID);
    }

    public static boolean isLocalHost(String host) {
        return host.equals(LOCALHOST) || host.equalsIgnoreCase(LOCALHOSTURL);
    }

    public void stageLogFiles(List<RAFile> raFiles, IProgressMonitor myMonitor, BaseLogWorker logWorker) throws Exception {
        ArrayList<String> remoteCommandsRun = new ArrayList<String>();
        HashSet<TempUnpackDir> unpackDirs = new HashSet<TempUnpackDir>();
        myMonitor.beginTask("", raFiles.size() * 2 + 2);
        myMonitor.setTaskName("Copying log files to staging directory");
        boolean isCanceled = false;
        for (RAFile raFile : raFiles) {
            block33: {
                try {
                    if (logWorker != null && logWorker.areAllJobsCanceled() || myMonitor.isCanceled()) {
                        isCanceled = true;
                        raFile.setCanceled(true);
                        continue;
                    }
                    String parentDir = LogFileUtils.getParentDir(raFile.getSrcFilePath());
                    String hashTargetDir = LogFileUtils.computeMD5Hash(String.valueOf(raFile.getSrcFileHost()) + parentDir);
                    String targetDirPath = String.valueOf(this.stagingDirectory.getAbsolutePath()) + File.separator + hashTargetDir;
                    File targetDir = new File(targetDirPath);
                    if (!targetDir.exists()) {
                        targetDir.mkdirs();
                    }
                    File targetFile = new File(String.valueOf(targetDirPath) + File.separator + raFile.getSrcFileName(false));
                    String srcLogFilePath = raFile.getSrcFilePath();
                    String srcArchivePath = raFile.getSrcArchivePath();
                    if (LogFileManager.isLocalHost(raFile.getSrcFileHost())) {
                        if (srcArchivePath != null && !srcArchivePath.isEmpty()) {
                            LogFileUtils.extractFileFromArchive(srcArchivePath, srcLogFilePath, targetFile, this.cfgParser.getUniqueID(), unpackDirs, raFile);
                        } else {
                            LogFileUtils.localFileCopy(new File(srcLogFilePath), targetFile);
                        }
                        myMonitor.worked(1);
                    } else {
                        ITarget remoteHost = LogFileUtils.getTarget(raFile.getSrcFileHost());
                        if (remoteHost.isSupportSsh()) {
                            if (srcArchivePath != null && !srcArchivePath.isEmpty()) {
                                TempUnpackDir tempUnpackDir = new TempUnpackDir(this.cfgParser.getUniqueID(), raFile);
                                String remoteCommand = "/bin/sh -c '" + tempUnpackDir.getRemoteCreateCmd() + "; " + SHELL_TAR_CMD + TGZ_EXTRACT_PARAMS + LogFileUtils.escapeSpaces(srcArchivePath) + TGZ_CHANGE_DIR_PARAM + tempUnpackDir.toString() + UNZIP_EXTRACT_PARAMS + LogFileUtils.escapeSpaces(LogFileUtils.getParentDir(raFile.getSrcFilePath(), "/")) + "'";
                                if (!remoteCommandsRun.contains(remoteCommand)) {
                                    LogFileUtils.executeCommand(remoteHost, remoteCommand);
                                    remoteCommandsRun.add(remoteCommand);
                                    unpackDirs.add(tempUnpackDir);
                                }
                                srcLogFilePath = String.valueOf(tempUnpackDir.toString()) + srcLogFilePath;
                            }
                            LogFileUtils.downloadFile(remoteHost, srcLogFilePath, targetFile, (IProgressMonitor)new SubProgressMonitor(myMonitor, 1));
                        } else if (remoteHost.isFileSystemSupported()) {
                            if (srcArchivePath != null && !srcArchivePath.isEmpty()) {
                                File bundle = LogFileUtils.downloadBundle(remoteHost, srcArchivePath, (IProgressMonitor)new SubProgressMonitor(myMonitor, 1));
                                LogFileUtils.extractFileFromArchive(bundle.getAbsolutePath(), srcLogFilePath, targetFile, this.cfgParser.getUniqueID(), unpackDirs, raFile);
                            } else {
                                LogFileUtils.downloadFile(remoteHost, srcLogFilePath, targetFile, (IProgressMonitor)new SubProgressMonitor(myMonitor, 1));
                            }
                        }
                    }
                    if (targetFile.exists()) {
                        if (targetFile.getName().endsWith(".gz")) {
                            int gzStrIdx = raFile.getSrcFileName(false).indexOf(".gz");
                            String gunzipName = raFile.getSrcFileName(false).substring(0, gzStrIdx);
                            String gunzipPath = String.valueOf(targetDirPath) + File.separator + gunzipName;
                            try {
                                LogFileUtils.decompressGzipFile(targetFile, gunzipPath);
                            }
                            catch (IOException ex) {
                                String message = String.valueOf(ex.getMessage()) + ":\n" + targetFile;
                                throw new IOException(message, ex);
                            }
                            LogFileUtils.deleteDirTree(targetFile);
                            targetFile = new File(gunzipPath);
                        } else if (targetFile.getName().endsWith(".sol")) {
                            String name = raFile.getSrcFileName(false);
                            name = name.substring(0, name.lastIndexOf(46));
                            String solLogFileName = String.valueOf(name) + ".log";
                            String solLogFilePath = String.valueOf(targetDirPath) + File.separator + solLogFileName;
                            try {
                                SolFileParser.decode(targetFile, new File(solLogFilePath));
                            }
                            catch (Exception e) {
                                String message = String.valueOf(e.getMessage()) + ":\n" + targetFile;
                                throw new Exception(message, e);
                            }
                            LogFileUtils.deleteDirTree(targetFile);
                            targetFile = new File(solLogFilePath);
                        }
                        raFile.setTargetFilePath(targetFile.getAbsolutePath());
                        break block33;
                    }
                    raFile.setCanceled(true);
                    String msg = "Unable to stage a temporary copy of file '{0}' for parsing";
                    msg = MessageFormat.format(msg, raFile.toDisplayString());
                    throw new Exception(msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LogBrowserPlugin.log(e);
                    raFile.setCanceled(true);
                    myMonitor.setCanceled(true);
                    throw new Exception("Problem staging log files: " + e.getMessage());
                }
            }
            myMonitor.worked(1);
        }
        try {
            TempUnpackDir[] dirs;
            TempUnpackDir[] tempUnpackDirArray = dirs = unpackDirs.toArray(new TempUnpackDir[0]);
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                TempUnpackDir dir = tempUnpackDirArray[n2];
                if (LogFileManager.isLocalHost(dir.getSourceFileHost())) {
                    LogFileUtils.deleteDirTree(new File(dir.toString()));
                } else {
                    ITarget target = LogFileUtils.getTarget(dir.getSourceFileHost());
                    LogFileUtils.executeCommand(target, "rm -rf " + dir.toString());
                }
                ++n2;
            }
            myMonitor.worked(1);
            if (isCanceled) {
                return;
            }
            if (this.mfstFile == null || !ManifestFile.isLegalManifest(this.mfstFile.getFile())) {
                this.mfstFile = new ManifestFile(this.stagingDirectory.getCanonicalPath(), this.cfgParser.getConfigFilePath(), false);
            }
            myMonitor.worked(1);
            this.mfstFile.addRAFiles(raFiles);
        }
        finally {
            myMonitor.done();
        }
    }

    public void prepareStagingDir(boolean forceReload) throws Exception {
        if (forceReload) {
            LogFileUtils.deleteDirTree(this.stagingDirectory);
            if (this.stagingDirectory.exists()) {
                throw new Exception("Cannot remove old temp directory to make room for new one: '" + this.stagingDirectory.getAbsolutePath() + "'.");
            }
        }
        this.stagingDirectory.mkdirs();
        if (!this.stagingDirectory.exists()) {
            throw new Exception("Cannot create temp directory '" + this.stagingDirectory.getAbsolutePath() + "'.");
        }
    }

    public List<RAFile> loadFilesFromManifest() throws IOException, Exception {
        this.mfstFile = new ManifestFile(this.stagingDirectory.getCanonicalPath(), this.cfgParser.getConfigFilePath(), false);
        if (!this.mfstFile.isValidFileList()) {
            this.mfstFile.initNewManifestFile(this.cfgParser.getConfigFilePath());
        }
        return this.mfstFile.getFileList();
    }

    public List<RAFile> getFileList() throws Exception {
        String[] sourceIDs;
        ArrayList<RAFile> raFiles = new ArrayList<RAFile>();
        String[] stringArray = sourceIDs = this.cfgParser.getSourceIDs();
        int n = sourceIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String srcID = stringArray[n2];
            String[] srcIDparts = ConfigParser.splitSourceID(srcID);
            if (srcIDparts == null) {
                throw new IllegalArgumentException("Invalid srcID '" + srcID + "'");
            }
            String host = srcIDparts[0];
            String archiveFilepath = srcIDparts[1];
            String parentDir = srcIDparts[2];
            String[] fileRegExArr = this.cfgParser.getFileRegExesInSrc(srcID);
            LogSystemType systemType = this.cfgParser.getSystemType();
            boolean fileSeqNumIsDescending = systemType.isFileNumDescending();
            ArrayList<LocationAndFilePattern> listOfLocationAndPattern = new ArrayList<LocationAndFilePattern>();
            String[] stringArray2 = fileRegExArr;
            int n3 = fileRegExArr.length;
            int n4 = 0;
            while (n4 < n3) {
                String[] paths;
                String fileRegEx = stringArray2[n4];
                String[] stringArray3 = paths = parentDir.split("\\|");
                int n5 = paths.length;
                int n6 = 0;
                while (n6 < n5) {
                    String path = stringArray3[n6];
                    listOfLocationAndPattern.add(new LocationAndFilePattern(path, fileRegEx));
                    ++n6;
                }
                ++n4;
            }
            Map<LocationAndFilePattern, List<RAFile>> map = LogFileManager.getMatchingFiles(host, archiveFilepath, listOfLocationAndPattern, fileSeqNumIsDescending, null);
            LinkedHashSet<RAFile> set = new LinkedHashSet<RAFile>();
            for (List list : map.values()) {
                for (RAFile raFile : list) {
                    set.add(raFile);
                }
            }
            if (set.size() == 0) {
                StringBuilder stringBuilder = new StringBuilder("No log files ");
                if (archiveFilepath != null) {
                    stringBuilder.append("in archive ");
                    stringBuilder.append(archiveFilepath);
                } else {
                    stringBuilder.append("on host ");
                    stringBuilder.append(host);
                }
                stringBuilder.append(" matching pattern");
                if (listOfLocationAndPattern.size() > 1) {
                    stringBuilder.append("s:\n");
                } else {
                    stringBuilder.append(":\n");
                }
                int i = 0;
                while (i < listOfLocationAndPattern.size()) {
                    LocationAndFilePattern lfp = (LocationAndFilePattern)listOfLocationAndPattern.get(i);
                    String dir = lfp.getDirectory();
                    stringBuilder.append(dir);
                    if (dir == null || !dir.endsWith("/") && !dir.endsWith("\\")) {
                        stringBuilder.append("/");
                    }
                    stringBuilder.append(lfp.getRegex());
                    stringBuilder.append("\n");
                    ++i;
                }
                throw new FileNotFoundException(stringBuilder.toString());
            }
            raFiles = new ArrayList(set);
            if (systemType.getSortMethod() == LogSystemType.SortMethod.Time) {
                Comparator<RAFile> comparator = new Comparator<RAFile>(){

                    @Override
                    public int compare(RAFile f1, RAFile f2) {
                        Date date1 = f1.getSrcFileTimestamp();
                        Date date2 = f2.getSrcFileTimestamp();
                        int comp = date1.compareTo(date2);
                        return comp;
                    }
                };
                Collections.sort(raFiles, comparator);
            } else if (systemType.getSortMethod() == LogSystemType.SortMethod.Filename) {
                Comparator<RAFile> comparator = new Comparator<RAFile>(){

                    @Override
                    public int compare(RAFile f1, RAFile f2) {
                        String name1 = f1.getSrcFileName(false);
                        String name2 = f2.getSrcFileName(false);
                        int comp = name1.compareTo(name2);
                        return comp;
                    }
                };
                Collections.sort(raFiles, comparator);
            } else {
                Collections.sort(raFiles);
            }
            ++n2;
        }
        return raFiles;
    }

    public List<RAFile> trimFileList(List<RAFile> fileList, int limitMB) {
        long size = 0L;
        long limit = limitMB;
        limit *= 0x100000L;
        int indx = fileList.size() - 1;
        while (indx >= 0) {
            RAFile f = fileList.get(indx);
            size = f.getSrcFileName(false).endsWith(".gz") ? (size += (long)(f.getSizeInBytes() * 10)) : (size += (long)f.getSizeInBytes());
            if (size > limit) {
                return fileList.subList(indx, fileList.size());
            }
            --indx;
        }
        return fileList;
    }

    private static CommandData getTarFileListFromZip(File archive) {
        StringBuilder sb;
        CommandData cmdResult;
        block15: {
            cmdResult = new CommandData();
            ZipFile zFile = null;
            sb = new StringBuilder();
            try {
                try {
                    zFile = new ZipFile(archive);
                    Enumeration e = zFile.getEntries();
                    while (e.hasMoreElements()) {
                        ZipEntry ze = (ZipEntry)e.nextElement();
                        String name = ze.getName();
                        sb.append("-r--r--r-- root/root  ");
                        sb.append(ze.getSize());
                        sb.append(" 2011-11-11 00:00:00 ");
                        sb.append(name);
                        sb.append("\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (zFile != null) {
                        try {
                            zFile.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (zFile != null) {
                    try {
                        zFile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (zFile != null) {
                try {
                    zFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        cmdResult.setOutput(sb.toString());
        return cmdResult;
    }

    private static CommandData getUnzipFileListFromZip(File archive) {
        StringBuilder sb;
        CommandData cmdResult;
        block15: {
            cmdResult = new CommandData();
            cmdResult.setReturnCode(0);
            ZipFile zFile = null;
            sb = new StringBuilder(2048);
            sb.append("Archive: ");
            sb.append(archive.getName());
            sb.append("\n");
            sb.append("Length     Date   Time    Name\n--------    ----   ----    ----\n");
            try {
                try {
                    zFile = new ZipFile(archive);
                    Enumeration e = zFile.getEntries();
                    while (e.hasMoreElements()) {
                        ZipEntry ze = (ZipEntry)e.nextElement();
                        String name = ze.getName();
                        sb.append(UNZIP_EXTRACT_PARAMS);
                        sb.append(ze.getSize());
                        sb.append(UNZIP_EXTRACT_PARAMS);
                        sb.append(UNZIP_LIST_TIMESTAMP_FORMATS[0].format(new Date(ze.getTime())));
                        sb.append(UNZIP_EXTRACT_PARAMS);
                        sb.append(name.replace("\\", "/"));
                        sb.append("\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (zFile != null) {
                        try {
                            zFile.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (zFile != null) {
                    try {
                        zFile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (zFile != null) {
                try {
                    zFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        cmdResult.setOutput(sb.toString());
        return cmdResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Map<LocationAndFilePattern, List<RAFile>> getMatchingFiles(String host, String archiveFilepath, List<LocationAndFilePattern> listOfLocationAndPattern, boolean fileSeqNumIsDescending) throws Exception {
        HashMap<LocationAndFilePattern, List<RAFile>> map;
        CommandData cmdResult;
        Object fileRegEx2;
        Object cachedArchiveInfo;
        boolean isRemoteESXi = false;
        boolean isLocalhost = LogFileManager.isLocalHost(host);
        boolean isZipFile = false;
        long archiveLastModified = 0L;
        boolean isMacLocalhost = isLocalhost && Utils.isPlatformMac();
        logger.info("getMatchingFiles isLocahost={} isMac={}", (Object)isLocalhost, (Object)Utils.isPlatformMac());
        String[] fileListLines = null;
        ITarget remoteTarget = LogFileUtils.getTarget(host);
        if (isLocalhost || remoteTarget != null && LOCALHOSTURL.equals(remoteTarget.getTargetType())) {
            if (archiveFilepath == null) {
                HashMap<LocationAndFilePattern, List<RAFile>> map2 = new HashMap<LocationAndFilePattern, List<RAFile>>();
                for (LocationAndFilePattern locationAndPattern : listOfLocationAndPattern) {
                    String fileRegEx2 = locationAndPattern.getRegex();
                    String parentDir = locationAndPattern.getDirectory();
                    List<RAFile> raFiles = LogFileManager.getLocalMatchingFiles(parentDir, fileRegEx2, fileSeqNumIsDescending);
                    map2.put(locationAndPattern, raFiles);
                }
                return map2;
            }
            File archiveFile = new File(archiveFilepath);
            archiveLastModified = archiveFile.lastModified();
            String cacheKey = String.valueOf(host) + archiveFilepath;
            cachedArchiveInfo = null;
            fileRegEx2 = archivePathToCacheInfoMap;
            synchronized (fileRegEx2) {
                cachedArchiveInfo = archivePathToCacheInfoMap.get(cacheKey);
            }
            if (cachedArchiveInfo != null && ((CachedArchiveInfo)cachedArchiveInfo).getLastModifiedTime() == archiveLastModified) {
                fileListLines = ((CachedArchiveInfo)cachedArchiveInfo).getContentListLines();
                isZipFile = ((CachedArchiveInfo)cachedArchiveInfo).isZipFile();
            } else {
                Object message;
                if (ArchiveUtils.isGZipTarFile((File)archiveFile)) {
                    logger.info("Extracting file list from tgz={}", (Object)archiveFilepath);
                    isZipFile = false;
                    if (Utils.isPlatformWindows()) {
                        String listAsString = LogFileManager.getLocalFileListFromTar(archiveFilepath);
                        fileListLines = listAsString.split("\n");
                    } else {
                        String commandParam = "tar -tzvf " + LogFileUtils.escapeSpaces(archiveFilepath);
                        String[] localCommand = new String[]{SHELL_EXEC, SHELL_CMD_SWITCH, commandParam};
                        CommandData cmdResult2 = LogFileUtils.runLocalCommand(localCommand, "/");
                        if (cmdResult2.getReturnCode() == 0) {
                            fileListLines = cmdResult2.getOutput().split("\n");
                        }
                    }
                } else if (ArchiveUtils.isZipFile((File)archiveFile)) {
                    logger.info("Extracting file list from zip={}", (Object)archiveFilepath);
                    isZipFile = true;
                    cmdResult = LogFileManager.getUnzipFileListFromZip(archiveFile);
                    if (cmdResult.getReturnCode() == 0) {
                        fileListLines = cmdResult.getOutput().split("\n");
                    }
                } else {
                    message = "Archive " + archiveFilepath + " is an unknown or unsupported format";
                    throw new Exception((String)message);
                }
                message = archivePathToCacheInfoMap;
                synchronized (message) {
                    cachedArchiveInfo = new CachedArchiveInfo();
                    ((CachedArchiveInfo)cachedArchiveInfo).setContentListLines(fileListLines);
                    ((CachedArchiveInfo)cachedArchiveInfo).setFilePath(archiveFilepath);
                    ((CachedArchiveInfo)cachedArchiveInfo).setZipFile(isZipFile);
                    ((CachedArchiveInfo)cachedArchiveInfo).setLastModifiedTime(archiveFile.lastModified());
                    archivePathToCacheInfoMap.put(cacheKey, (CachedArchiveInfo)cachedArchiveInfo);
                }
            }
        } else {
            if (remoteTarget == null) {
                throw new IOException("host " + host + " is not available");
            }
            if (archiveFilepath == null) {
                return LogFileManager.getMatchingFilesForRemoteTarget(remoteTarget, listOfLocationAndPattern, fileSeqNumIsDescending);
            }
            try {
                ITargetFile remoteFile = remoteTarget.getTargetFile(archiveFilepath, null);
                if (remoteFile != null) {
                    archiveLastModified = remoteFile.lastModified();
                }
            }
            catch (Exception e) {
                logger.error("Exception trying to fetch information on remote archive", (Throwable)e);
            }
            String cacheKey = String.valueOf(host) + archiveFilepath;
            CachedArchiveInfo cachedArchiveInfo2 = null;
            cachedArchiveInfo = archivePathToCacheInfoMap;
            synchronized (cachedArchiveInfo) {
                cachedArchiveInfo2 = archivePathToCacheInfoMap.get(cacheKey);
            }
            if (cachedArchiveInfo2 != null && cachedArchiveInfo2.getLastModifiedTime() == archiveLastModified) {
                fileListLines = cachedArchiveInfo2.getContentListLines();
                isZipFile = cachedArchiveInfo2.isZipFile();
            } else {
                if (remoteTarget.isSupportSsh()) {
                    String remoteCommand;
                    isRemoteESXi = remoteTarget.isVisor();
                    if (archiveFilepath.toLowerCase().endsWith("tgz")) {
                        isZipFile = false;
                        remoteCommand = "/bin/sh -c 'tar -tzvf " + LogFileUtils.escapeSpaces(archiveFilepath) + "'";
                        cmdResult = LogFileUtils.executeCommand(remoteTarget, remoteCommand);
                        if (cmdResult.getReturnCode() == 0) {
                            fileListLines = cmdResult.getOutput().split("\n");
                        }
                    } else if (archiveFilepath.toLowerCase().endsWith("zip")) {
                        isZipFile = true;
                        remoteCommand = "/bin/sh -c 'unzip -l " + LogFileUtils.escapeSpaces(archiveFilepath) + "'";
                        cmdResult = LogFileUtils.executeCommand(remoteTarget, remoteCommand);
                        if (cmdResult.getReturnCode() == 0) {
                            fileListLines = cmdResult.getOutput().split("\n");
                        }
                    }
                } else {
                    throw new Exception("Remote target " + host + " does not support ssh.  There is no way to gather the file list of the archive.");
                }
                if (archiveLastModified != 0L) {
                    Map<String, CachedArchiveInfo> map3 = archivePathToCacheInfoMap;
                    synchronized (map3) {
                        cachedArchiveInfo2 = new CachedArchiveInfo();
                        cachedArchiveInfo2.setContentListLines(fileListLines);
                        cachedArchiveInfo2.setFilePath(archiveFilepath);
                        cachedArchiveInfo2.setZipFile(isZipFile);
                        cachedArchiveInfo2.setLastModifiedTime(archiveLastModified);
                        archivePathToCacheInfoMap.put(cacheKey, cachedArchiveInfo2);
                    }
                }
            }
        }
        if (fileListLines != null) {
            map = new HashMap<LocationAndFilePattern, List<RAFile>>();
            for (LocationAndFilePattern locationAndFilePattern : listOfLocationAndPattern) {
                fileRegEx2 = locationAndFilePattern.getRegex();
                String parentDir = locationAndFilePattern.getDirectory();
                List<RAFile> raFiles = LogFileManager.parseFileList(host, archiveFilepath, parentDir, (String)fileRegEx2, fileListLines, fileSeqNumIsDescending, isRemoteESXi, isMacLocalhost, isZipFile);
                map.put(locationAndFilePattern, raFiles);
            }
            return map;
        }
        map = new HashMap();
        for (LocationAndFilePattern pairDirectoryRegex : listOfLocationAndPattern) {
            map.put(pairDirectoryRegex, new ArrayList());
        }
        return map;
    }

    private static Map<LocationAndFilePattern, List<RAFile>> getMatchingFilesForRemoteTarget(ITarget remoteTarget, List<LocationAndFilePattern> listOfLocationAndPattern, boolean fileSeqNumIsDescending) throws Exception {
        if (!remoteTarget.isConnected()) {
            remoteTarget.connect(null);
        }
        String host = remoteTarget.getHostName();
        char separator = remoteTarget.getTargetType() == "windows" ? (char)'\\' : '/';
        HashMap<String, ITargetFile[]> mapCacheFiles = new HashMap<String, ITargetFile[]>();
        HashMap<LocationAndFilePattern, List<RAFile>> mapResult = new HashMap<LocationAndFilePattern, List<RAFile>>();
        for (LocationAndFilePattern pairDirectoryRegex : listOfLocationAndPattern) {
            ITargetFile tf;
            String fileRegEx = pairDirectoryRegex.getRegex();
            String parentDir = pairDirectoryRegex.getDirectory();
            Pattern pt = Pattern.compile(String.valueOf(fileRegEx) + "\\S*$");
            try {
                tf = remoteTarget.getTargetFile(parentDir, null);
            }
            catch (Exception exception) {
                continue;
            }
            if (!tf.exists()) continue;
            if (tf.isFile()) {
                ArrayList<RAFile> raFiles = new ArrayList<RAFile>(1);
                RemotePath p = new RemotePath(tf);
                RAFile newRAFile = new RAFile();
                Date date = new Date(tf.lastModified());
                newRAFile.setSrcFileTimestamp(date);
                StringBuilder sb = new StringBuilder(p.toOSString());
                newRAFile.setSrcFilePath(sb.toString());
                newRAFile.setSrcFileHost(host);
                newRAFile.setSrcSeparator(separator);
                newRAFile.setSizeInBytes((int)tf.length());
                newRAFile.setSeqNumInvertedForSort(fileSeqNumIsDescending);
                newRAFile.setSrcArchivePath(null);
                raFiles.add(newRAFile);
                mapResult.put(pairDirectoryRegex, raFiles);
                continue;
            }
            ITargetFile[] filelist = (ITargetFile[])mapCacheFiles.get(parentDir);
            if (filelist == null) {
                filelist = tf.listFiles(null);
                mapCacheFiles.put(parentDir, filelist);
            }
            ArrayList<RAFile> raFiles = new ArrayList<RAFile>();
            ITargetFile[] iTargetFileArray = filelist;
            int n = filelist.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetFile f = iTargetFileArray[n2];
                RemotePath p = new RemotePath(f);
                Matcher m = pt.matcher(p.lastSegment());
                if (m.matches()) {
                    RAFile newRAFile = new RAFile();
                    Date date = new Date(f.lastModified());
                    newRAFile.setSrcFileTimestamp(date);
                    StringBuilder sb = new StringBuilder(parentDir);
                    sb.append(p.lastSegment());
                    newRAFile.setSrcFilePath(sb.toString());
                    newRAFile.setSrcFileHost(host);
                    newRAFile.setSrcSeparator(separator);
                    newRAFile.setSizeInBytes((int)f.length());
                    newRAFile.setSeqNumInvertedForSort(fileSeqNumIsDescending);
                    newRAFile.setSrcArchivePath(null);
                    raFiles.add(newRAFile);
                }
                ++n2;
            }
            mapResult.put(pairDirectoryRegex, raFiles);
        }
        return mapResult;
    }

    private static List<RAFile> getLocalMatchingFiles(String parentDir, String fileRegEx, boolean fileSeqNumIsDescending) {
        File file;
        ArrayList<RAFile> raFiles = new ArrayList<RAFile>();
        File[] fileArr = new File[]{};
        final Pattern namePattern = Pattern.compile(fileRegEx);
        try {
            if (parentDir != null && (file = new File(parentDir)).exists()) {
                if (file.isDirectory()) {
                    fileArr = file.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File path) {
                            Matcher myMatcher = namePattern.matcher(path.getName());
                            return path.isFile() && myMatcher.find();
                        }
                    });
                } else if (file.isFile()) {
                    fileArr = new File[]{file};
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File[] fileArray = fileArr;
        int n = fileArr.length;
        int n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            RAFile newRAFile = new RAFile();
            newRAFile.setSrcFileTimestamp(new Date(file.lastModified()));
            newRAFile.setSrcFilePath(file.getAbsolutePath());
            newRAFile.setSrcFileHost(LOCALHOSTURL);
            newRAFile.setSrcSeparator(File.separatorChar);
            newRAFile.setSizeInBytes((int)file.length());
            newRAFile.setSeqNumInvertedForSort(fileSeqNumIsDescending);
            raFiles.add(newRAFile);
            ++n2;
        }
        return raFiles;
    }

    private static Map<LocationAndFilePattern, List<RAFile>> getLocalFilesFromTar(String archiveFilepath, List<LocationAndFilePattern> listOfLocationAndPattern, boolean fileSeqNumIsDescending) throws Exception {
        GZIPInputStream gis = new GZIPInputStream(new FileInputStream(new File(archiveFilepath)));
        TarInputStream tarInStrm = new TarInputStream((InputStream)gis);
        TarEntry tarEntry = tarInStrm.getNextEntry();
        HashMap<LocationAndFilePattern, List<RAFile>> mapResult = new HashMap<LocationAndFilePattern, List<RAFile>>();
        while (tarEntry != null) {
            if (!tarEntry.isDirectory()) {
                for (LocationAndFilePattern locationAndPattern : listOfLocationAndPattern) {
                    String quotedParentDir;
                    Pattern dirFilePattern;
                    Matcher dirFileMatcher;
                    String fileRegEx = locationAndPattern.getRegex();
                    String parentDir = locationAndPattern.getDirectory();
                    ArrayList<RAFile> raFiles = (ArrayList<RAFile>)mapResult.get(locationAndPattern);
                    if (raFiles == null) {
                        raFiles = new ArrayList<RAFile>();
                        mapResult.put(locationAndPattern, raFiles);
                    }
                    if (!(dirFileMatcher = (dirFilePattern = Pattern.compile(String.valueOf(quotedParentDir = Pattern.quote(parentDir)) + fileRegEx)).matcher(tarEntry.getName())).find()) continue;
                    RAFile newRAFile = new RAFile();
                    newRAFile.setSrcFileTimestamp(tarEntry.getModTime());
                    newRAFile.setSrcFilePath(tarEntry.getName());
                    newRAFile.setSrcFileHost(LOCALHOSTURL);
                    newRAFile.setSrcSeparator(File.separatorChar);
                    newRAFile.setSizeInBytes((int)tarEntry.getSize());
                    newRAFile.setSeqNumInvertedForSort(fileSeqNumIsDescending);
                    newRAFile.setSrcArchivePath(archiveFilepath);
                    raFiles.add(newRAFile);
                    break;
                }
            }
            try {
                tarEntry = tarInStrm.getNextEntry();
            }
            catch (IOException ioe) {
                System.err.println("Caught an I/O exception: " + ioe.getMessage());
                throw new Exception("Tar file entry unreadable. Try re-creating the vm-support log without core files using 'vm-support -n'... " + ioe.getMessage());
            }
        }
        tarInStrm.close();
        return mapResult;
    }

    private static String getLocalFileListFromTar(String archiveFilepath) throws Exception {
        StringBuilder sb = new StringBuilder(2048);
        GZIPInputStream gis = new GZIPInputStream(new FileInputStream(new File(archiveFilepath)));
        TarInputStream tarInStrm = new TarInputStream((InputStream)gis);
        TarEntry tarEntry = tarInStrm.getNextEntry();
        new HashMap();
        while (tarEntry != null) {
            if (!tarEntry.isDirectory()) {
                sb.append("-rwxrwxrwx ");
                sb.append(tarEntry.getUserName());
                sb.append("/");
                sb.append(tarEntry.getGroupName());
                sb.append(UNZIP_EXTRACT_PARAMS);
                sb.append(Long.toString(tarEntry.getSize()));
                sb.append(UNZIP_EXTRACT_PARAMS);
                sb.append(TAR_TIMESTAMP_FORMATS[0].format(tarEntry.getModTime()));
                sb.append(UNZIP_EXTRACT_PARAMS);
                sb.append(tarEntry.getName());
                sb.append("\n");
            }
            try {
                tarEntry = tarInStrm.getNextEntry();
            }
            catch (IOException ioe) {
                logger.error("Caught an I/O exception while parsing tar: " + ioe.getMessage(), (Throwable)ioe);
                throw new Exception("Tar file entry unreadable. Try re-creating the vm-support log without core files using 'vm-support -n'... " + ioe.getMessage());
            }
        }
        tarInStrm.close();
        return sb.toString();
    }

    public static List<RAFile> parseFileList(String host, String archiveFilepath, String parentDir, String fileRegEx, String fileListStr, boolean fileSeqNumIsDescending, boolean isRemoteESXi, boolean isLocalhostMacintosh, boolean isZipFile) throws Exception {
        String[] fileListLines = fileListStr.split("\n");
        return LogFileManager.parseFileList(host, archiveFilepath, parentDir, fileRegEx, fileListLines, fileSeqNumIsDescending, isRemoteESXi, isLocalhostMacintosh, isZipFile);
    }

    public static List<RAFile> parseFileList(String host, String archiveFilepath, String parentDir, String fileRegEx, String[] fileListLines, boolean fileSeqNumIsDescending, boolean isRemoteESXi, boolean isLocalhostMacintosh, boolean isZipFile) throws Exception {
        ArrayList<RAFile> fileList = new ArrayList<RAFile>();
        String lineRegexStr = null;
        DateFormat[] dateFormats = null;
        int filenameGroup = 0;
        Date now = new Date();
        if (isLocalhostMacintosh && archiveFilepath != null && !isZipFile) {
            lineRegexStr = "^[-rwx]+\\s+\\S+\\s\\S+\\s+\\S+\\s+(\\d+)\\s+(\\S+\\s+\\d+\\s+\\d+[\\:0-9]*)\\s([^/]*" + parentDir + fileRegEx + "\\S*)$";
            dateFormats = MAC_TAR_TIMESTAMP_FORMATS;
            filenameGroup = 3;
        } else if (archiveFilepath != null && !isZipFile) {
            lineRegexStr = "^[-rwx]+\\s+\\S+\\s+(\\d+)\\s(\\d\\d\\d\\d-\\d\\d-\\d\\d\\s\\d\\d:\\d\\d(:\\d\\d)*)\\s([^/]*" + parentDir + fileRegEx + "\\S*)$";
            dateFormats = TAR_TIMESTAMP_FORMATS;
            filenameGroup = 4;
        } else if (archiveFilepath != null && isZipFile) {
            lineRegexStr = "^\\s*(\\d+)\\s+(\\d\\d-\\d\\d-\\d\\d \\d+:\\d\\d)\\s+([^/]*" + parentDir + fileRegEx + "\\S*)$";
            dateFormats = UNZIP_LIST_TIMESTAMP_FORMATS;
            filenameGroup = 3;
        } else if (isRemoteESXi) {
            lineRegexStr = "^[-rwx]+\\s+\\d+\\s+\\S+\\s+\\S+\\s+(\\d+)\\s(\\w\\w\\w\\s\\w\\w\\w\\s+\\d+\\s\\d\\d:\\d\\d:\\d\\d\\s\\d\\d\\d\\d)\\s(" + fileRegEx + "\\S*)$";
            dateFormats = BUSYBOX_LS_TIMESTAMP_FORMATS;
            filenameGroup = 3;
        } else {
            lineRegexStr = "^[-rwx]+\\s+\\d+\\s+\\S+\\s+\\S+\\s+(\\d+)\\s(\\d\\d\\d\\d-\\d\\d-\\d\\d\\s\\d\\d:\\d\\d)\\s(" + fileRegEx + "\\S*)$";
            dateFormats = LONG_ISO_TIMESTAMP_FORMATS;
            filenameGroup = 3;
        }
        Pattern lineRegexPattern = Pattern.compile(lineRegexStr);
        String[] stringArray = fileListLines;
        int n = fileListLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            try {
                Matcher lineMatcher = lineRegexPattern.matcher(line);
                String sizeValueStr = null;
                String dateValueStr = null;
                String fileNameValueStr = null;
                Date date = null;
                if (lineMatcher.matches()) {
                    sizeValueStr = line.substring(lineMatcher.start(1), lineMatcher.end(1));
                    dateValueStr = line.substring(lineMatcher.start(2), lineMatcher.end(2));
                    fileNameValueStr = line.substring(lineMatcher.start(filenameGroup), lineMatcher.end(filenameGroup));
                    if (archiveFilepath == null) {
                        fileNameValueStr = String.valueOf(parentDir) + fileNameValueStr;
                    }
                    DateFormat[] dateFormatArray = dateFormats;
                    int n3 = dateFormats.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        DateFormat dateFormat = dateFormatArray[n4];
                        try {
                            date = dateFormat.parse(dateValueStr);
                            break;
                        }
                        catch (Exception exception) {
                            ++n4;
                        }
                    }
                    if (date == null) {
                        date = now;
                    }
                    RAFile newRAFile = new RAFile();
                    newRAFile.setSrcFileTimestamp(date);
                    newRAFile.setSrcFilePath(fileNameValueStr);
                    newRAFile.setSrcFileHost(host);
                    newRAFile.setSrcSeparator('/');
                    newRAFile.setSizeInBytes(Integer.parseInt(sizeValueStr));
                    newRAFile.setSeqNumInvertedForSort(fileSeqNumIsDescending);
                    newRAFile.setSrcArchivePath(archiveFilepath);
                    fileList.add(newRAFile);
                }
            }
            catch (Exception e) {
                logger.error("Exception while parsing archive content lines " + e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        return fileList;
    }

    public ConfigParser getCfgParser() {
        return this.cfgParser;
    }

    public static Map<LocationAndFilePattern, List<RAFile>> getMatchingFiles(String host, String archiveFilepath, List<LocationAndFilePattern> listOfLocationAndPattern, boolean fileSeqNumIsDescending, IProgressMonitor monitor) throws Exception {
        ITarget target = LogFileUtils.getTarget(host);
        return archiveFilepath == null ? LogFileManager.getMatchingFilesForTarget(target, listOfLocationAndPattern, fileSeqNumIsDescending, monitor) : LogFileManager.getMatchingFilesForBundle(target, archiveFilepath, listOfLocationAndPattern, fileSeqNumIsDescending, monitor);
    }

    private static boolean isRemoteHost(ITarget target) {
        return target != null && !LOCALHOSTURL.equals(target.getTargetType());
    }

    private static Map<LocationAndFilePattern, List<RAFile>> getMatchingFilesForTarget(ITarget target, List<LocationAndFilePattern> listOfLocationAndPattern, boolean fileSeqNumIsDescending, IProgressMonitor monitor) throws Exception {
        if (LogFileManager.isRemoteHost(target)) {
            return LogFileManager.getMatchingFilesForRemoteTarget(target, listOfLocationAndPattern, fileSeqNumIsDescending);
        }
        HashMap<LocationAndFilePattern, List<RAFile>> map = new HashMap<LocationAndFilePattern, List<RAFile>>();
        for (LocationAndFilePattern locationAndPattern : listOfLocationAndPattern) {
            String fileRegEx = locationAndPattern.getRegex();
            String parentDir = locationAndPattern.getDirectory();
            List<RAFile> raFiles = LogFileManager.getLocalMatchingFiles(parentDir, fileRegEx, fileSeqNumIsDescending);
            map.put(locationAndPattern, raFiles);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<LocationAndFilePattern, List<RAFile>> getMatchingFilesForBundle(ITarget target, String archiveFilepath, List<LocationAndFilePattern> listOfLocationAndPattern, boolean fileSeqNumIsDescending, IProgressMonitor monitor) throws Exception {
        long archiveLastModified = 0L;
        boolean isRemoteHost = LogFileManager.isRemoteHost(target);
        if (isRemoteHost) {
            ITargetFile remoteFile = target.getTargetFile(archiveFilepath, null);
            if (remoteFile != null) {
                archiveLastModified = remoteFile.lastModified();
            }
        } else {
            File archiveFile = new File(archiveFilepath);
            archiveLastModified = archiveFile.lastModified();
        }
        String cacheKey = String.valueOf(target.getHostName()) + archiveFilepath;
        CachedArchiveInfo cachedArchiveInfo = null;
        Map<String, CachedArchiveInfo> map = archivePathToCacheInfoMap;
        synchronized (map) {
            cachedArchiveInfo = archivePathToCacheInfoMap.get(cacheKey);
        }
        String[] fileListLines = null;
        boolean isZipFile = false;
        if (cachedArchiveInfo != null && cachedArchiveInfo.getLastModifiedTime() == archiveLastModified) {
            isZipFile = cachedArchiveInfo.isZipFile();
            fileListLines = cachedArchiveInfo.getContentListLines();
        } else {
            isZipFile = archiveFilepath.toLowerCase().endsWith("zip");
            fileListLines = isRemoteHost ? LogFileManager.getFileListFromRemoteBundle(target, archiveFilepath, monitor).split("\n") : LogFileManager.getFileListFromLocalBundle(archiveFilepath, monitor).split("\n");
            if (archiveLastModified != 0L) {
                Map<String, CachedArchiveInfo> map2 = archivePathToCacheInfoMap;
                synchronized (map2) {
                    cachedArchiveInfo = new CachedArchiveInfo();
                    cachedArchiveInfo.setContentListLines(fileListLines);
                    cachedArchiveInfo.setFilePath(archiveFilepath);
                    cachedArchiveInfo.setZipFile(isZipFile);
                    cachedArchiveInfo.setLastModifiedTime(archiveLastModified);
                    archivePathToCacheInfoMap.put(cacheKey, cachedArchiveInfo);
                }
            }
        }
        HashMap<LocationAndFilePattern, List<RAFile>> map3 = new HashMap<LocationAndFilePattern, List<RAFile>>();
        if (fileListLines != null) {
            boolean isMacLocal = !isRemoteHost && Utils.isPlatformMac();
            for (LocationAndFilePattern locationAndFilePattern : listOfLocationAndPattern) {
                String fileRegEx = locationAndFilePattern.getRegex();
                String parentDir = locationAndFilePattern.getDirectory();
                List<RAFile> raFiles = LogFileManager.parseFileList(target.getHostName(), archiveFilepath, parentDir, fileRegEx, fileListLines, fileSeqNumIsDescending, target.isVisor(), isMacLocal, isZipFile);
                map3.put(locationAndFilePattern, raFiles);
            }
        }
        return map3;
    }

    private static String getFileListFromLocalBundle(String archiveFilepath, IProgressMonitor monitor) throws Exception {
        String result = "";
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName("Extracting log files from bundle...");
        if (archiveFilepath.toLowerCase().endsWith("tgz")) {
            logger.info("Extracting file list from tgz={}", (Object)archiveFilepath);
            result = LogFileManager.getLocalFileListFromTar(archiveFilepath);
        } else if (archiveFilepath.toLowerCase().endsWith("zip")) {
            logger.info("Extracting file list from zip={}", (Object)archiveFilepath);
            CommandData cmdResult = LogFileManager.getUnzipFileListFromZip(new File(archiveFilepath));
            if (cmdResult.getReturnCode() == 0) {
                result = cmdResult.getOutput();
            }
        } else {
            throw new UnknownFileFormatException(archiveFilepath);
        }
        return result;
    }

    private static String getFileListFromRemoteBundle(ITarget target, String archiveFilepath, IProgressMonitor monitor) throws Exception {
        if (target.isSupportSsh()) {
            return LogFileManager.getFileListFromRemoteBundleThroughShell(target, archiveFilepath, monitor);
        }
        if (target.isFileSystemSupported()) {
            return LogFileManager.getFileListFromRemoteBundleThroughFileSystem(target, archiveFilepath, monitor);
        }
        throw new Exception("Remote target " + target.getHostName() + " does not support ssh.  There is no way to gather the file list of the archive.");
    }

    private static String getFileListFromRemoteBundleThroughShell(ITarget target, String archiveFilepath, IProgressMonitor monitor) throws Exception {
        String result = "";
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName("Decompressing bundle in the remote host...");
        if (archiveFilepath.toLowerCase().endsWith("tgz")) {
            String remoteCommand = "/bin/sh -c 'tar -tzvf " + LogFileUtils.escapeSpaces(archiveFilepath) + "'";
            CommandData cmdResult = LogFileUtils.executeCommand(target, remoteCommand);
            if (cmdResult.getReturnCode() == 0) {
                result = cmdResult.getOutput();
            }
        } else if (archiveFilepath.toLowerCase().endsWith("zip")) {
            String remoteCommand = "/bin/sh -c 'unzip -l " + LogFileUtils.escapeSpaces(archiveFilepath) + "'";
            CommandData cmdResult = LogFileUtils.executeCommand(target, remoteCommand);
            if (cmdResult.getReturnCode() == 0) {
                result = cmdResult.getOutput();
            }
        } else {
            throw new UnknownFileFormatException(archiveFilepath);
        }
        return result;
    }

    private static String getFileListFromRemoteBundleThroughFileSystem(ITarget target, String archiveFilepath, IProgressMonitor monitor) throws Exception {
        String result = "";
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName("Downloading bundle...");
        File bundle = LogFileUtils.downloadBundle(target, archiveFilepath, monitor);
        String bundlePath = bundle.getAbsolutePath();
        if (archiveFilepath.toLowerCase().endsWith("tgz")) {
            logger.info("Extracting file list from tgz={}", (Object)bundlePath);
            result = LogFileManager.getLocalFileListFromTar(bundlePath);
        } else if (archiveFilepath.toLowerCase().endsWith("zip")) {
            logger.info("Extracting file list from zip={}", (Object)bundlePath);
            CommandData cmdResult = LogFileManager.getUnzipFileListFromZip(bundle);
            if (cmdResult.getReturnCode() == 0) {
                result = cmdResult.getOutput();
            }
        } else {
            throw new UnknownFileFormatException(archiveFilepath);
        }
        return result;
    }

    private static class CachedArchiveInfo {
        private String filePath = null;
        private boolean isZipFile = false;
        private long lastModifiedTime = 0L;
        private String[] contentListLines = null;

        private CachedArchiveInfo() {
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public boolean isZipFile() {
            return this.isZipFile;
        }

        public void setZipFile(boolean isZipFile) {
            this.isZipFile = isZipFile;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public void setLastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public String[] getContentListLines() {
            return this.contentListLines;
        }

        public void setContentListLines(String[] contentListLines) {
            this.contentListLines = contentListLines;
        }
    }
}

