/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.fileops;

import com.vmware.vide.vlogbrowser.core.fileops.LogFileManager;
import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.model.util.IFilteredList;
import com.vmware.vide.vlogbrowser.core.parser.LogFormat;
import com.vmware.vide.vlogbrowser.core.parser.LogParser;
import com.vmware.vide.vlogbrowser.core.parser.RAFile;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class BaseLogWorker {
    protected IFilteredList<LogItem> filterList;
    protected LogFormat logFormat;
    protected String logWorkerType;
    private LogFileManager logFileMgr;
    private LogParser parser;
    protected final String FILE_READ_ERROR = "File read error";
    protected final String FILE_ERROR_MSG = "The file could not be read.";
    protected final String FILE_COPY_ERROR = "File copy error";
    protected final String COPY_ERROR_MSG = "The file could not be copied from the source to the staging area.";
    private boolean working = true;

    public BaseLogWorker(LogParser parser) {
        this.parser = parser;
    }

    public boolean areAllJobsCanceled() {
        return false;
    }

    public void handleCopyFileException(Exception e) {
        e.printStackTrace();
    }

    public void handleReadFileException(Exception e) {
        e.printStackTrace();
    }

    public void prepareToRun(Job job) {
    }

    public void marshalLogFiles(List<RAFile> raFiles, IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask("Marshalling " + this.logFormat.getName() + " log files", 1);
                this.logFileMgr.stageLogFiles(raFiles, (IProgressMonitor)new SubProgressMonitor(monitor, 1), this);
            }
            catch (Exception e) {
                this.handleCopyFileException(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public void parseFilesIntoTable(IProgressMonitor monitor) {
        monitor.beginTask("Preparing to parse files...", 1);
        this.working = true;
        List<RAFile> fileList = this.logFormat.getRandAccFileList();
        try {
            try {
                if (fileList != null) {
                    this.parser.loadFromFiles(this.logFormat, this, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            catch (Exception e) {
                this.handleReadFileException(e);
                this.working = false;
                monitor.done();
            }
        }
        finally {
            this.working = false;
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWorking() {
        BaseLogWorker baseLogWorker = this;
        synchronized (baseLogWorker) {
            return this.working;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFinished() {
        BaseLogWorker baseLogWorker = this;
        synchronized (baseLogWorker) {
            this.working = false;
        }
    }

    public void setFilterList(IFilteredList<LogItem> eventList) {
        this.filterList = eventList;
    }

    public IFilteredList<LogItem> getFilterList() {
        return this.filterList;
    }

    public void setLogFormat(LogFormat logFormat) {
        this.logFormat = logFormat;
    }

    public void setLogWorkerType(String logWorkerType) {
        this.logWorkerType = logWorkerType;
    }

    public void setLogFileMgr(LogFileManager logFileMgr) {
        this.logFileMgr = logFileMgr;
    }
}

