/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.export;

import com.vmware.vide.vlogbrowser.core.export.ILogEntryAccessor;
import com.vmware.vide.vlogbrowser.core.export.ILogExport;
import com.vmware.vide.vlogbrowser.core.export.LogExportException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogExportXML
implements ILogExport {
    private static final Logger logger = LoggerFactory.getLogger(LogExportXML.class);
    private static final String INDENTION = "  ";
    private static final String INDENTION2 = "    ";
    private PrintStream printer = null;
    private IProgressMonitor monitor = null;
    private boolean emitExtraLines = false;

    @Override
    public void start(OutputStream outputStream, IProgressMonitor monitor, boolean emitExtraLines) throws LogExportException {
        try {
            this.printer = new PrintStream(outputStream);
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            this.monitor = monitor;
            this.emitExtraLines = emitExtraLines;
            this.printer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            this.printer.println("<logItems>");
        }
        catch (Exception e) {
            String errorMessage = "Error while exporting log file to XML format: " + e.getMessage();
            logger.error(errorMessage, (Throwable)e);
            throw new LogExportException(errorMessage, e);
        }
    }

    @Override
    public void end() throws LogExportException {
        try {
            this.printer.println("</logItems>");
            this.printer.flush();
            this.printer.close();
        }
        catch (Exception e) {
            String errorMessage = "Error while exporting log file to XML format: " + e.getMessage();
            logger.error(errorMessage, (Throwable)e);
            throw new LogExportException(errorMessage, e);
        }
    }

    @Override
    public void export(ILogEntryAccessor logAccess) throws LogExportException {
        try {
            String[] columns = logAccess.getColumns();
            int entryCount = logAccess.getEntryCount();
            this.monitor.beginTask("Exporting current log entries as XML", entryCount);
            int entry = 0;
            while (entry < entryCount) {
                if (this.monitor.isCanceled()) {
                    this.monitor.done();
                    throw new LogExportException("Export operation cancelled");
                }
                this.monitor.worked(1);
                this.printer.println("  <logItem>");
                String[] values = logAccess.getEntryValues(entry);
                int i = 0;
                while (i < columns.length) {
                    String column = columns[i];
                    String field = values[i];
                    this.emitElement(column, field);
                    ++i;
                }
                if (this.emitExtraLines) {
                    String extraLines = logAccess.getExtraLines(entry);
                    this.emitElement("ExtraLines", extraLines);
                }
                this.printer.println("  </logItem>");
                ++entry;
            }
        }
        catch (Exception e) {
            String errorMessage = "Error while exporting log file to XML format: " + e.getMessage();
            logger.error(errorMessage, (Throwable)e);
            throw new LogExportException(errorMessage, e);
        }
    }

    private void emitElement(String column, String field) {
        column = this.replaceInvalidCharacters(column);
        if (field == null || field.isEmpty()) {
            this.printer.println("    <" + column + "/>");
        } else {
            String xmlEncodedField = LogExportXML.escapeXml(field);
            this.printer.println("    <" + column + ">" + xmlEncodedField + "</" + column + ">");
        }
    }

    private static String escapeXml(String field) {
        return LogExportXML.aaronsLimitedeEscapeXml(field);
    }

    private static String aaronsLimitedeEscapeXml(String field) {
        StringBuilder sb = new StringBuilder(field.length());
        int length = field.length();
        int i = 0;
        while (i < length) {
            char c = field.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String googleXmlEscape(String s) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\n': {
                    sb.append("&#xA;");
                    break;
                }
                case '\r': {
                    sb.append("&#xD;");
                    break;
                }
                case '\t': {
                    sb.append("&#x9;");
                    break;
                }
                case '\u0000': {
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private String replaceInvalidCharacters(String tagName) {
        tagName = tagName.replaceFirst("^\\d", "_");
        tagName = tagName.replaceAll("\\W", "_");
        return tagName;
    }
}

