/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.export;

import com.vmware.vide.vlogbrowser.core.export.ILogEntryAccessor;
import com.vmware.vide.vlogbrowser.core.export.ILogExport;
import com.vmware.vide.vlogbrowser.core.export.JsonMiniWriter;
import com.vmware.vide.vlogbrowser.core.export.LogExportException;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogExportJson
implements ILogExport {
    private static final Logger logger = LoggerFactory.getLogger(LogExportJson.class);
    private JsonMiniWriter writer = null;
    private IProgressMonitor monitor = null;
    private boolean emitExtraLines = false;

    @Override
    public void start(OutputStream outputStream, IProgressMonitor monitor, boolean emitExtraLines) throws LogExportException {
        this.writer = new JsonMiniWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.monitor = monitor;
        this.emitExtraLines = emitExtraLines;
        try {
            this.writer.setIndent("    ");
            this.writer.beginObject();
            this.writer.name("logItems");
            this.writer.beginArray();
        }
        catch (Exception e) {
            String errorMessage = "Error while exporting log file to JSON format: " + e.getMessage();
            logger.error(errorMessage, (Throwable)e);
            throw new LogExportException(errorMessage, e);
        }
    }

    @Override
    public void end() throws LogExportException {
        try {
            this.writer.endArray();
            this.writer.endObject();
            this.writer.flush();
        }
        catch (Exception e) {
            String errorMessage = "Error while exporting log file to JSON format: " + e.getMessage();
            logger.error(errorMessage, (Throwable)e);
            throw new LogExportException(errorMessage, e);
        }
    }

    @Override
    public void export(ILogEntryAccessor logAccess) throws LogExportException {
        String[] columns = logAccess.getColumns();
        int entryCount = logAccess.getEntryCount();
        try {
            try {
                this.monitor.beginTask("Exporting current log entries as JSON", entryCount);
                int entry = 0;
                while (entry < entryCount) {
                    if (this.monitor.isCanceled()) {
                        this.monitor.done();
                        throw new LogExportException("Export operation cancelled");
                    }
                    this.monitor.worked(1);
                    this.writer.beginObject();
                    String[] values = logAccess.getEntryValues(entry);
                    int i = 0;
                    while (i < columns.length) {
                        String column = columns[i];
                        String field = values[i];
                        this.writer.name(column);
                        this.writer.value(field);
                        ++i;
                    }
                    if (this.emitExtraLines) {
                        String extraLines = logAccess.getExtraLines(entry);
                        this.writer.name("ExtraLines");
                        this.writer.value(extraLines);
                    }
                    this.writer.endObject();
                    ++entry;
                }
            }
            catch (Exception e) {
                String errorMessage = "Error while exporting log file to JSON format: " + e.getMessage();
                logger.error(errorMessage, (Throwable)e);
                throw new LogExportException(errorMessage, e);
            }
        }
        finally {
            this.monitor.done();
        }
    }
}

