/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.export;

import com.vmware.vide.vlogbrowser.core.export.EnumLogExport;
import com.vmware.vide.vlogbrowser.core.export.ILogExport;
import com.vmware.vide.vlogbrowser.core.export.LogExportCsv;
import com.vmware.vide.vlogbrowser.core.export.LogExportJson;
import com.vmware.vide.vlogbrowser.core.export.LogExportTxt;
import com.vmware.vide.vlogbrowser.core.export.LogExportXML;

public class LogExportFactory {
    private static LogExportFactory instance;

    private LogExportFactory() {
    }

    public static synchronized LogExportFactory getInstance() {
        if (instance == null) {
            instance = new LogExportFactory();
        }
        return instance;
    }

    public ILogExport createService(EnumLogExport type) {
        switch (type) {
            case XML: {
                return new LogExportXML();
            }
            case TXT: {
                return new LogExportTxt();
            }
            case JSON: {
                return new LogExportJson();
            }
            case CSV: {
                return new LogExportCsv();
            }
        }
        return null;
    }
}

