/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core;

import com.vmware.vide.utils.local.VMWBConfig;
import com.vmware.vide.vlogbrowser.core.ILogBrowserManager;
import com.vmware.vide.vlogbrowser.core.ILogBrowserManagerProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class LogBrowserPlugin
extends Plugin {
    private static LogBrowserPlugin instance;
    private ILogBrowserManager manager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        super.stop(context);
    }

    public static LogBrowserPlugin getDefault() {
        return instance;
    }

    public static void log(Throwable t) {
        String pluginId = LogBrowserPlugin.getDefault().getBundle().getSymbolicName();
        Status status = new Status(4, pluginId, "Error", t);
        LogBrowserPlugin.getDefault().getLog().log((IStatus)status);
    }

    public ILogBrowserManager getLogBrowserManager() {
        if (this.manager == null) {
            boolean headless = VMWBConfig.isHeadless();
            String id = this.getBundle().getSymbolicName();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(id, "provider");
            if (point != null) {
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                block2: while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        try {
                            String value = element.getAttribute("headless");
                            if (headless == Boolean.parseBoolean(value)) {
                                Object object = element.createExecutableExtension("class");
                                ILogBrowserManagerProvider provider = (ILogBrowserManagerProvider)object;
                                this.manager = provider.getLogBrowserManager();
                                break block2;
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        return this.manager;
    }
}

