/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.init;

import com.vmware.vide.init.IConfigChangeListener;
import com.vmware.vide.utils.local.VMWBConfig;
import com.vmware.vide.utils.symbol.IVariableReplacer;
import com.vmware.vide.utils.symbol.MapVariableReplacer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.EventListenerList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class vIDEConfigInfo {
    private static final String EXTENSION_POINT_NEW_PROJECT_DIR = "com.vmware.vide.init.newProjectDir";
    private static final String TAG_EXTENSION_DIR = "dir";
    private static final String TAG_VIDECONFIG = "videconfig";
    private static final String TAG_CFGROOTPATH = "root";
    private static final String TAG_CFGFILEFORMAT = "fileformat";
    private static final String TAG_KIT = "kit";
    private static final String TAG_COMMON = "common";
    private static final String TAG_ID = "id";
    public static final String TAG_VERSION = "version";
    public static final String TAG_TYPE = "type";
    public static final String TAG_TITLE = "title";
    public static final String TAG_NAME = "name";
    public static final String TAG_PROJECTIDENTITY = "projectidentity";
    public static final String TAG_DESCRIPTION = "description";
    private static final String TAG_OPTION = "option";
    private static final String TAG_PATH = "path";
    private static final String KEYPATH_PROJECTNATURE = "project.projectnature";
    private static final String KEYPATH_SYSTEM = "system";
    private static final String RES_CONFIGFILE = "/resources/config-base.xml";
    private static final String VERSIONED_CONFIGFILE_PATTERN = ".*-(\\d+\\.\\d+\\.\\d+_\\d+)\\.xml";
    private static final String OPT_INSTALLED_DEVKIT_BUILDNO = "INSTALLED_DEVKIT_BUILDNO";
    private static final String OPT_INSTALLED_DEVKIT_VERSION = "INSTALLED_DEVKIT_VERSION";
    private static final String OPT_INSTALLED_DEVKIT_RELEASE = "INSTALLED_DEVKIT_RELEASE";
    private static final String OPT_VERSIONED_DEVKIT_BUILDNO = "VERSIONED_DEVKIT_BUILDNO";
    private static final String OPT_VERSIONED_DEVKIT_VERSION = "VERSIONED_DEVKIT_VERSION";
    private static final String TOKEN_VALUE_SEPARATOR = ":";
    private static final String ATTR_OS = "os";
    private static final String KEY_BUNDLE_ID = "BUNDLE_ID";
    private static final String KEY_BUNDLE_PATH = "BUNDLE_PATH";
    private static final String KEY_BUNDLE_VERSION = "BUNDLE_VERSION";
    private static final String KEY_BUNDLE_VERSION_MMM = "BUNDLE_VERSION_MMM";
    private static final String KEY_BUNDLE_VERSION_QUALIFIER = "BUNDLE_VERSION_QUALIFIER";
    private File basecfgfile;
    private Document basedom;
    private List<Path> cfgrootpaths;
    private String cfgfileformat;
    private Node basecfgnode;
    private List<File> cfgfiles;
    private final Map<String, Map<String, String>> configFilePathToBundleInfoMap = new LinkedHashMap<String, Map<String, String>>();
    private Hashtable<String, ConfigRootNode> cfgrootnodes;
    protected EventListenerList eventlistener = new EventListenerList();

    public vIDEConfigInfo() {
        this.initialize();
    }

    private void initialize() {
        this.cfgrootnodes = new Hashtable();
        this.cfgrootpaths = new ArrayList<Path>();
        this.basecfgfile = this.getResource(RES_CONFIGFILE);
        if (this.basecfgfile != null && this.basecfgfile.exists()) {
            this.basedom = this.parseXml(this.basecfgfile);
            if (this.basedom != null) {
                String rootpath = this.getTextNodeValueFromDocument(this.basedom, TAG_VIDECONFIG, TAG_CFGROOTPATH);
                this.cfgfileformat = this.getTextNodeValueFromDocument(this.basedom, TAG_VIDECONFIG, TAG_CFGFILEFORMAT);
                this.cfgrootpaths = this.getConfigRootPaths(rootpath);
            }
        }
        List<Path> additionalRootPaths = this.getAdditionalRootPathsFromExtensionPoints();
        this.cfgrootpaths.addAll(additionalRootPaths);
        if (this.cfgrootpaths.isEmpty()) {
            System.err.println("unable to find the root path");
            return;
        }
        this.cfgfiles = this.getFilteredConfigFiles(this.cfgfileformat);
        if (this.cfgfiles.isEmpty()) {
            return;
        }
        NodeList nodes = this.basedom.getElementsByTagName(TAG_KIT);
        if (nodes.getLength() > 0) {
            this.basecfgnode = nodes.item(0);
        }
        if (this.basecfgnode == null) {
            System.err.println("unable to find the base configuration information");
            return;
        }
        for (File cfgfile : this.cfgfiles) {
            try {
                ConfigRootNode rnode;
                if (!cfgfile.exists()) continue;
                MapVariableReplacer replacerForCfgFile = null;
                Map<String, String> nameValueMapForPlugin = this.configFilePathToBundleInfoMap.get(cfgfile.getAbsolutePath());
                if (nameValueMapForPlugin != null) {
                    replacerForCfgFile = new MapVariableReplacer(nameValueMapForPlugin);
                }
                if (!(rnode = new ConfigRootNode((IVariableReplacer)replacerForCfgFile, this.basecfgnode, cfgfile)).isValid()) {
                    System.err.println("fail to parse configuration file " + cfgfile);
                    continue;
                }
                this.cfgrootnodes.put(rnode.getId(), rnode);
            }
            catch (Exception exception) {
                System.err.println("fail to parse configuration file " + cfgfile);
            }
        }
    }

    public String[] getKitIds() {
        return this.cfgrootnodes.keySet().toArray(new String[this.cfgrootnodes.size()]);
    }

    public Map<String, String> getKitInfo(String kitid) {
        if (this.cfgrootnodes.containsKey(kitid)) {
            return this.cfgrootnodes.get(kitid).getKitInfo();
        }
        return null;
    }

    public Map<String, File> getConfigFiles() {
        HashMap<String, File> cfgfiles = new HashMap<String, File>();
        Enumeration<String> e = this.cfgrootnodes.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            cfgfiles.put(key, this.cfgrootnodes.get(key).cfgfile);
        }
        return cfgfiles;
    }

    public String[] getKitIdsMatching(String keypath, String value, boolean casesensitive) {
        ArrayList<String> ids = new ArrayList<String>();
        Map<String, String> values = this.getAllConfigValues(keypath);
        for (Map.Entry<String, String> e : values.entrySet()) {
            if ((!casesensitive || !e.getValue().equals(value)) && (casesensitive || !e.getValue().equalsIgnoreCase(value))) continue;
            ids.add(e.getKey());
        }
        return ids.toArray(new String[ids.size()]);
    }

    public String getFirstConfigValue(String kitid, String keypath) {
        if (kitid != null && this.cfgrootnodes.containsKey(kitid)) {
            return this.cfgrootnodes.get(kitid).getFirstConfigValue(keypath);
        }
        return "";
    }

    public boolean isFirstConfigValue(String kitid, String keypath, String value, boolean casesensitive) {
        if (kitid != null && this.cfgrootnodes.containsKey(kitid)) {
            String firstvalue = this.cfgrootnodes.get(kitid).getFirstConfigValue(keypath);
            return casesensitive && firstvalue.equals(value) || !casesensitive && firstvalue.equalsIgnoreCase(value);
        }
        return false;
    }

    public Map<String, String> getFirstConfigValueFromKeys(String kitid, String[] keypaths) {
        if (kitid != null && this.cfgrootnodes.containsKey(kitid)) {
            return this.cfgrootnodes.get(kitid).getFirstConfigValueFromKeys(keypaths);
        }
        return new HashMap<String, String>();
    }

    public String[] getConfigValues(String kitid, String keypath) {
        if (kitid != null && this.cfgrootnodes.containsKey(kitid)) {
            return this.cfgrootnodes.get(kitid).getConfigValues(keypath);
        }
        return new String[0];
    }

    public Map<String, Map<String, String>> getAllConfigValues(String kitid, String keypath) {
        if (kitid != null && this.cfgrootnodes.containsKey(kitid)) {
            return this.cfgrootnodes.get(kitid).getAllConfigValues(keypath);
        }
        return null;
    }

    public int getConfigCount(String kitid, String keypath) {
        return this.getConfigNodes(kitid, keypath).length;
    }

    public String getConfigValueByIndex(String kitid, String parentkeypath, String nodename, int index) {
        ConfigNode[] nodes = this.getConfigNodes(kitid, parentkeypath);
        if (nodes.length > index) {
            return nodes[index].getChildNodeValue(nodename, 0);
        }
        return "";
    }

    public Map<String, String> getChildrenNodeValuesByIndex(String kitid, String parentkeypath, int index) {
        ConfigNode[] nodes = this.getConfigNodes(kitid, parentkeypath);
        if (nodes.length > index) {
            return nodes[index].getChildrenNodeValues();
        }
        return null;
    }

    public Map<String, String> getAttributes(String kitid, String keypath) {
        if (kitid != null && this.cfgrootnodes.containsKey(kitid)) {
            return this.cfgrootnodes.get(kitid).getAttributes(keypath);
        }
        return null;
    }

    public ArrayList<Map<String, Object>> getAllNodeValues(String kitid, String keypath) {
        if (kitid != null && this.cfgrootnodes.containsKey(kitid)) {
            return this.cfgrootnodes.get(kitid).getAllNodeValues(keypath);
        }
        return null;
    }

    public Node[] getConfigNode(String kitid, String keypath) {
        ConfigNode[] nodes;
        ArrayList<Node> domnodes = new ArrayList<Node>();
        if (kitid != null && this.cfgrootnodes.containsKey(kitid) && (nodes = this.getConfigNodes(kitid, keypath)).length > 0) {
            int i = 0;
            while (i < nodes.length) {
                domnodes.add(nodes[i].domnode);
                ++i;
            }
        }
        return domnodes.toArray(new Node[domnodes.size()]);
    }

    public Document getConfigDocument(String kitid) {
        if (kitid != null && this.cfgrootnodes.containsKey(kitid)) {
            return this.cfgrootnodes.get(kitid).cfgdom;
        }
        return null;
    }

    private ConfigNode[] getConfigNodes(String kitid, String keypath) {
        if (kitid != null && this.cfgrootnodes.containsKey(kitid)) {
            return this.cfgrootnodes.get(kitid).getConfigNodes(keypath);
        }
        return new ConfigNode[0];
    }

    private Map<String, String> getAllConfigValues(String keypath) {
        HashMap<String, String> info = new HashMap<String, String>();
        Enumeration<ConfigRootNode> e = this.cfgrootnodes.elements();
        while (e.hasMoreElements()) {
            String value;
            ConfigRootNode rootnode = e.nextElement();
            if (!rootnode.isValid() || (value = rootnode.getFirstConfigValue(keypath)) == null || value.isEmpty()) continue;
            info.put(rootnode.getId(), value);
        }
        return info;
    }

    public Map<String, ConfigNode[]> getAllConfigNodes(String keypath) {
        HashMap<String, ConfigNode[]> info = new HashMap<String, ConfigNode[]>();
        Enumeration<ConfigRootNode> e = this.cfgrootnodes.elements();
        while (e.hasMoreElements()) {
            ConfigNode[] nodes;
            ConfigRootNode rootnode = e.nextElement();
            if (!rootnode.isValid() || (nodes = rootnode.getConfigNodes(keypath)) == null || nodes.length <= 0) continue;
            info.put(rootnode.getId(), nodes);
        }
        return info;
    }

    public Map<String, String> getProjectNatureInfo(String kitid, String projnatureid) {
        if (kitid != null && this.cfgrootnodes.containsKey(kitid)) {
            return this.cfgrootnodes.get(kitid).getProjectNatureInfo(projnatureid);
        }
        return null;
    }

    public ArrayList<Map<String, String>> getProjectNatureOptions(String kitid, String projnatureid) {
        if (kitid != null && this.cfgrootnodes.containsKey(kitid)) {
            return this.cfgrootnodes.get(kitid).getProjectNatureOptions(projnatureid);
        }
        return null;
    }

    public List<Map<String, String>> getProjectNaturePaths(String kitid, String projnatureid) {
        if (kitid != null && this.cfgrootnodes.containsKey(kitid)) {
            return this.cfgrootnodes.get(kitid).getProjectNaturePaths(projnatureid);
        }
        return null;
    }

    public Map<String, String> getSystemOptions(String kitid) {
        if (kitid != null && this.cfgrootnodes.containsKey(kitid)) {
            return this.cfgrootnodes.get(kitid).getSystemOptions();
        }
        return null;
    }

    public String getInstalledDevkitBuildNo(String kitid) {
        if (kitid != null && this.cfgrootnodes.containsKey(kitid)) {
            if (this.cfgrootnodes.get(kitid).isVersioned()) {
                return this.cfgrootnodes.get(kitid).getVersionedBuildNo();
            }
            return this.cfgrootnodes.get((Object)kitid).installeddevkitbuildno;
        }
        return null;
    }

    public String getInstalledDevkitVersion(String kitid) {
        if (kitid != null && this.cfgrootnodes.containsKey(kitid)) {
            if (this.cfgrootnodes.get(kitid).isVersioned()) {
                return this.cfgrootnodes.get(kitid).getVersionedVersion();
            }
            return this.cfgrootnodes.get((Object)kitid).installeddevkitversion;
        }
        return null;
    }

    private List<Path> getConfigRootPaths(String path) {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (path != null && !path.trim().isEmpty()) {
            ArrayList<String> dirs = new ArrayList<String>();
            dirs.add(path);
            String install = VMWBConfig.getInstallDir();
            if (install != null) {
                dirs.add(String.valueOf(install) + path);
            }
            for (String dir : dirs) {
                Path rootpath = new Path(dir);
                File rootDir = rootpath.toFile();
                if (!rootDir.exists() || !rootDir.isDirectory() || rootDir.listFiles().length <= 0) continue;
                paths.add(rootpath);
            }
        }
        return paths;
    }

    private List<Path> getAdditionalRootPathsFromExtensionPoints() {
        ArrayList<Path> additionalRootPaths = new ArrayList<Path>();
        IConfigurationElement[] configElementList = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_NEW_PROJECT_DIR);
        try {
            IConfigurationElement[] iConfigurationElementArray = configElementList;
            int n = configElementList.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                String tagName = configElement.getName();
                if (tagName.equals(TAG_EXTENSION_DIR)) {
                    File projectDir;
                    String pathValue = configElement.getValue();
                    Path dir = new Path(pathValue);
                    if (!dir.isAbsolute()) {
                        String bundleId = "?";
                        try {
                            bundleId = configElement.getNamespaceIdentifier();
                            Bundle bundle = Platform.getBundle((String)bundleId);
                            URL fileURL = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)dir, null));
                            dir = new Path(fileURL.getFile());
                            this.addInfoForBundle(bundleId, dir);
                        }
                        catch (IOException ex) {
                            System.err.println("Error while parsing extension from bundle='" + bundleId + "' path='" + pathValue);
                            throw ex;
                        }
                    }
                    if ((projectDir = dir.toFile()).exists() && projectDir.isDirectory()) {
                        additionalRootPaths.add(dir);
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return additionalRootPaths;
    }

    private void addInfoForBundle(String bundleId, Path relativeDirToScanForConfigFiles) {
        try {
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle == null) {
                return;
            }
            URL locationUrl = bundle.getEntry("/");
            URL fileUrl = FileLocator.toFileURL((URL)locationUrl);
            String bundleRootDirPath = fileUrl.getPath();
            if (bundleRootDirPath.endsWith("/") || bundleRootDirPath.endsWith("\\")) {
                bundleRootDirPath = bundleRootDirPath.substring(0, bundleRootDirPath.length() - 1);
            }
            Version version = bundle.getVersion();
            LinkedHashMap<String, String> bundleVariableMap = new LinkedHashMap<String, String>(3);
            bundleVariableMap.put(KEY_BUNDLE_ID, bundleId);
            bundleVariableMap.put(KEY_BUNDLE_PATH, bundleRootDirPath);
            bundleVariableMap.put(KEY_BUNDLE_VERSION, version.toString());
            bundleVariableMap.put(KEY_BUNDLE_VERSION_MMM, String.format("%d.%d.%d", version.getMajor(), version.getMinor(), version.getMicro()));
            bundleVariableMap.put(KEY_BUNDLE_VERSION_QUALIFIER, version.getQualifier());
            ArrayList<Path> pathList = new ArrayList<Path>(1);
            pathList.add(relativeDirToScanForConfigFiles);
            List<File> configFilesForBundleList = vIDEConfigInfo.getFilteredConfigFiles(pathList, this.cfgfileformat);
            for (File cfgFileForBundle : configFilesForBundleList) {
                this.configFilePathToBundleInfoMap.put(cfgFileForBundle.getAbsolutePath(), bundleVariableMap);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private List<ConfigNode> getValidNodeList(ArrayList<ConfigNode> nodes) {
        if (!this.hasOsAttr(nodes)) {
            return nodes;
        }
        ArrayList<ConfigNode> qualifiedNodes = new ArrayList<ConfigNode>();
        ArrayList<ConfigNode> defaultNodes = new ArrayList<ConfigNode>();
        String os = Platform.getOS().toLowerCase().substring(0, 3);
        for (ConfigNode node : nodes) {
            if (node.hasAttribute(ATTR_OS)) {
                String[] oses;
                String[] stringArray = oses = node.getAttrValue(ATTR_OS).split(TOKEN_VALUE_SEPARATOR);
                int n = oses.length;
                int n2 = 0;
                while (n2 < n) {
                    String o = stringArray[n2];
                    if (o.equals(os)) {
                        qualifiedNodes.add(node);
                    }
                    ++n2;
                }
                continue;
            }
            defaultNodes.add(node);
        }
        if (qualifiedNodes.isEmpty()) {
            qualifiedNodes = defaultNodes;
        }
        return qualifiedNodes;
    }

    private boolean hasOsAttr(List<ConfigNode> nodes) {
        for (ConfigNode n : nodes) {
            if (!n.hasAttribute(ATTR_OS)) continue;
            return true;
        }
        return false;
    }

    private static List<File> getFilteredConfigFiles(List<Path> directoriesToScan, final String filespec) {
        final ArrayList<File> files = new ArrayList<File>();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (filespec != null && !filespec.isEmpty()) {
                    Pattern p = Pattern.compile(filespec);
                    Matcher m = p.matcher(f.getName());
                    if (m.matches()) {
                        files.add(f);
                        return true;
                    }
                    return false;
                }
                files.add(f);
                return true;
            }
        };
        for (Path path : directoriesToScan) {
            File rootDir = path.toFile();
            rootDir.listFiles(filter);
        }
        return files;
    }

    private List<File> getFilteredConfigFiles(String filespec) {
        return vIDEConfigInfo.getFilteredConfigFiles(this.cfgrootpaths, filespec);
    }

    private File getResource(String path) {
        URL url;
        block4: {
            try {
                if (Platform.getOS().equals("win32")) {
                    path = path.replace("\\", "/");
                }
                if ((url = FileLocator.toFileURL((URL)this.getClass().getResource(path))) != null && url.getFile() != null && new File(url.getFile()).exists()) break block4;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return new File(url.getFile());
    }

    public void addEventListener(IConfigChangeListener listener) {
        this.eventlistener.add(IConfigChangeListener.class, listener);
    }

    public void removeEventListener(IConfigChangeListener listener) {
        this.eventlistener.remove(IConfigChangeListener.class, listener);
    }

    public void refreshAll() {
        this.initialize();
        this.sendRefreshAllEvent();
    }

    private void sendRefreshAllEvent() {
        EventObject event = new EventObject("all");
        Object[] eventlisteners = this.eventlistener.getListenerList();
        int i = 0;
        while (i < eventlisteners.length) {
            if (eventlisteners[i] == IConfigChangeListener.class) {
                ((IConfigChangeListener)eventlisteners[i + 1]).ConfigRefreshed(event);
            }
            ++i;
        }
    }

    public ArrayList<ConfigNode> createConfigNodes(IVariableReplacer variableReplacer, Node basenode, Node cfgnodes, String parentid) {
        ArrayList<ConfigNode> nodes = new ArrayList<ConfigNode>();
        if (basenode != null && cfgnodes != null) {
            String nodename = basenode.getNodeName();
            Node[] foundnode = this.lookupNodeFromParentNode(cfgnodes, nodename);
            int i = 0;
            while (i < foundnode.length) {
                ConfigNode node = new ConfigNode(variableReplacer, basenode, cfgnodes, parentid, foundnode[i]);
                if (node.isValid()) {
                    nodes.add(node);
                }
                ++i;
            }
        }
        return nodes;
    }

    private Document parseXml(Object input) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            dbf.setIgnoringComments(true);
            if (input instanceof File) {
                return db.parse((File)input);
            }
            if (input instanceof String) {
                return db.parse((String)input);
            }
            if (input instanceof InputStream) {
                return db.parse((InputStream)input);
            }
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean isTextNode(Node node) {
        if (node.getFirstChild() == null) {
            return false;
        }
        return node.getFirstChild().getNodeType() == 3;
    }

    private String getTextNodeValue(Node node) {
        if (!this.isTextNode(node)) {
            return null;
        }
        return node.getFirstChild().getNodeValue();
    }

    private String getTextNodeValueFromDocument(Document dom, String tagname, String nodename) {
        NodeList nl = dom.getElementsByTagName(tagname);
        if (nl != null && nl.getLength() > 0) {
            return this.getTextNodeValueFromNode(nl.item(0), nodename);
        }
        return null;
    }

    private String getTextNodeValueFromNode(Node node, String nodename) {
        NodeList nl = node.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equals(nodename)) {
                return this.getTextNodeValue(nl.item(i));
            }
            ++i;
        }
        return null;
    }

    private Node lookupFirstNodeFromParentNode(Node parentnode, String nodename) {
        NodeList nl = parentnode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equals(nodename)) {
                return nl.item(i);
            }
            ++i;
        }
        return null;
    }

    private Node[] lookupNodeFromParentNode(Node parentnode, String nodename) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList nl = parentnode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equals(nodename)) {
                nodes.add(nl.item(i));
            }
            ++i;
        }
        return nodes.toArray(new Node[nodes.size()]);
    }

    private String getChildTextNodeValueFromParentNode(Node parentnode, String nodename, String childnodename) {
        Node node = this.lookupFirstNodeFromParentNode(parentnode, nodename);
        if (node != null) {
            return this.getTextNodeValueFromNode(node, childnodename);
        }
        return null;
    }

    public static String getCommandResult(String command) {
        StringBuffer rpminfo;
        block9: {
            String linesep = System.getProperty("line.separator");
            rpminfo = new StringBuffer();
            File tempfile = null;
            try {
                try {
                    tempfile = File.createTempFile("temp", ".sh");
                    BufferedWriter fwriter = new BufferedWriter(new FileWriter(tempfile));
                    fwriter.write(command);
                    ((Writer)fwriter).close();
                    tempfile.setExecutable(true, false);
                    Process proc = Runtime.getRuntime().exec(tempfile.getAbsolutePath());
                    BufferedReader cmdinput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    String line = null;
                    while ((line = cmdinput.readLine()) != null) {
                        rpminfo.append(line).append(linesep);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    if (tempfile != null) {
                        tempfile.delete();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (tempfile != null) {
                    tempfile.delete();
                }
                throw throwable;
            }
            if (tempfile != null) {
                tempfile.delete();
            }
        }
        return rpminfo.toString();
    }

    private class ConfigNode {
        private static final String TAG_VALUE = "value";
        private static final String TOKEN_ID_SEPARATOR = ".";
        private final IVariableReplacer variableReplacer;
        private String nodeid;
        private String nodename;
        private String nodevalue;
        private Node basenode;
        private Node domnode;
        private Hashtable<String, ArrayList<String>> attributes;
        private Hashtable<String, ArrayList<ConfigNode>> children;
        public boolean isrecursive;

        public ConfigNode(IVariableReplacer variableReplacer, Node basenode, Node cfgnodes, String parentid, Node foundnode) {
            this.variableReplacer = variableReplacer;
            if (basenode == null || cfgnodes == null) {
                this.nodename = "";
                return;
            }
            this.isrecursive = false;
            this.children = new Hashtable();
            this.attributes = new Hashtable();
            this.domnode = foundnode;
            this.basenode = basenode;
            this.nodename = basenode.getNodeName();
            this.nodeid = parentid != null && !parentid.isEmpty() ? String.valueOf(parentid) + TOKEN_ID_SEPARATOR + this.nodename : this.nodename;
            this.setNodeValue(foundnode);
            this.parseAttribute(foundnode);
            this.updateNodeValue();
            NodeList nodes = basenode.getChildNodes();
            ArrayList<Node> childnodes = new ArrayList<Node>();
            int i = 0;
            while (i < nodes.getLength()) {
                childnodes.add(nodes.item(i));
                ++i;
            }
            if (this.isrecursive) {
                childnodes.add(basenode);
            }
            i = 0;
            while (i < childnodes.size()) {
                Node node = (Node)childnodes.get(i);
                if (node.getNodeName() != null && node.getNodeName().indexOf("#text") == -1) {
                    ArrayList<ConfigNode> cnodes = vIDEConfigInfo.this.createConfigNodes(variableReplacer, node, foundnode, this.nodeid);
                    int j = 0;
                    while (j < cnodes.size()) {
                        ConfigNode cnode = cnodes.get(j);
                        ArrayList<ConfigNode> list = this.children.containsKey(cnode.getName()) ? this.children.get(cnode.getName()) : new ArrayList<ConfigNode>();
                        list.add(cnode);
                        this.children.put(cnode.getName(), list);
                        ++j;
                    }
                }
                ++i;
            }
        }

        public boolean isValid() {
            return this.nodename != null && !this.nodename.isEmpty();
        }

        public String getName() {
            return this.nodename;
        }

        public String getNodeValue() {
            return this.nodevalue;
        }

        public String getChildNodeValue(String childkeypath, int index) {
            if (this.children.containsKey(childkeypath) && this.children.get(childkeypath).size() > index) {
                return this.children.get(childkeypath).get(index).getNodeValue();
            }
            return "";
        }

        public Map<String, String> getChildrenNodeValues() {
            HashMap<String, String> values = new HashMap<String, String>();
            if (this.children.size() == 0) {
                return values;
            }
            Enumeration<String> e = this.children.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                List list = vIDEConfigInfo.this.getValidNodeList(this.children.get(key));
                if (list.size() <= 0) continue;
                values.put(key, ((ConfigNode)list.get(0)).getNodeValue());
            }
            return values;
        }

        public NODEKEY verifyKey(String keypath) {
            if (keypath != null && !keypath.isEmpty()) {
                if (keypath.equalsIgnoreCase(this.nodeid)) {
                    return NODEKEY.FOUND;
                }
                if (keypath.toLowerCase().startsWith(this.nodeid.toLowerCase())) {
                    return NODEKEY.PARENT;
                }
            }
            return NODEKEY.NOTFOUND;
        }

        public Map<String, String> getAttributes(String keypath) {
            ArrayList<ConfigNode> nodes;
            String nextnode;
            NODEKEY nkeypath = this.verifyKey(keypath);
            if (nkeypath == NODEKEY.FOUND) {
                return this.getAttributes();
            }
            if (nkeypath == NODEKEY.PARENT && !(nextnode = this.getNextChildNodeId(keypath)).isEmpty() && this.children.containsKey(nextnode) && (nodes = this.children.get(nextnode)).size() > 0) {
                return nodes.get(0).getAttributes(keypath);
            }
            return new HashMap<String, String>();
        }

        private Map<String, String> getAttributes() {
            HashMap<String, String> attrs = new HashMap<String, String>();
            Enumeration<String> e = this.attributes.keys();
            while (e.hasMoreElements()) {
                String attr = e.nextElement();
                String attrvalue = this.getAttributeValue(attr);
                if (attrvalue == null || attrvalue.isEmpty()) continue;
                attrs.put(attr, attrvalue);
            }
            return attrs;
        }

        public boolean hasAttribute(String attr) {
            return this.attributes.containsKey(attr) && !this.getAttributeValue(attr).isEmpty();
        }

        public String getAttributeValue(String attr) {
            if (this.attributes.containsKey(attr)) {
                return this.getAttrValue(attr);
            }
            return "";
        }

        public Object getAllNodeValues() {
            if (this.children == null || this.children.size() == 0) {
                return this.getNodeValue();
            }
            ArrayList values = new ArrayList();
            Enumeration<String> e = this.children.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                List nodelist = vIDEConfigInfo.this.getValidNodeList(this.children.get(key));
                int i = 0;
                while (i < nodelist.size()) {
                    HashMap<String, Object> nodevalue = new HashMap<String, Object>();
                    nodevalue.put(((ConfigNode)nodelist.get(i)).getName(), ((ConfigNode)nodelist.get(i)).getAllNodeValues());
                    values.add(nodevalue);
                    ++i;
                }
            }
            return values;
        }

        public ConfigNode[] getConfigNodes(String keypath) {
            ConfigNode[] empty = new ConfigNode[]{};
            if (keypath != null && !keypath.isEmpty()) {
                String nodekeypath;
                NODEKEY nkeypath = this.verifyKey(keypath);
                if (nkeypath == NODEKEY.FOUND) {
                    return new ConfigNode[]{this};
                }
                if (nkeypath == NODEKEY.PARENT && !(nodekeypath = this.removeNodeId(keypath)).isEmpty()) {
                    if (nodekeypath.indexOf(TOKEN_ID_SEPARATOR) == -1) {
                        if (this.children.containsKey(nodekeypath)) {
                            List nodes = vIDEConfigInfo.this.getValidNodeList(this.children.get(nodekeypath));
                            return nodes.toArray(new ConfigNode[nodes.size()]);
                        }
                    } else if (this.children.containsKey(nodekeypath = this.getFirstNodeId(nodekeypath)) && this.children.containsKey(nodekeypath)) {
                        ArrayList<ConfigNode> nodes = this.children.get(nodekeypath);
                        int i = 0;
                        while (i < nodes.size()) {
                            ConfigNode[] foundnodes = nodes.get(i).getConfigNodes(keypath);
                            if (foundnodes != null && foundnodes.length > 0) {
                                return foundnodes;
                            }
                            ++i;
                        }
                    }
                }
            }
            return empty;
        }

        public String getOutput(String header) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("* nodename    : " + this.getName());
            if (this.getNodeValue() != null && !this.getNodeValue().trim().isEmpty()) {
                lines.add("  - value   : " + this.getNodeValue());
            }
            if (this.attributes.size() > 0) {
                String info = "  - attributes  : ";
                Enumeration<String> e = this.attributes.keys();
                while (e.hasMoreElements()) {
                    String keypath = e.nextElement();
                    info = info.concat("[" + keypath + "=");
                    ArrayList<String> values = this.attributes.get(keypath);
                    int i = 0;
                    while (i < values.size()) {
                        info = info.concat(String.valueOf(values.get(i)) + ",");
                        ++i;
                    }
                    info = info.concat("] ");
                }
                lines.add(info);
            }
            String output = "";
            int i = 0;
            while (i < lines.size()) {
                output = output.concat(String.valueOf(header) + (String)lines.get(i) + "\n");
                ++i;
            }
            if (this.children.size() > 0) {
                output = output.concat(String.valueOf(header) + "  - children    : \n");
                Enumeration<ArrayList<ConfigNode>> e = this.children.elements();
                while (e.hasMoreElements()) {
                    ArrayList<ConfigNode> list = e.nextElement();
                    int i2 = 0;
                    while (i2 < list.size()) {
                        output = output.concat(list.get(i2).getOutput(String.valueOf(header) + "   "));
                        ++i2;
                    }
                }
            }
            return output;
        }

        private void parseAttribute(Node node) {
            if (this.basenode == null || node == null) {
                return;
            }
            NamedNodeMap baseattrs = this.basenode.getAttributes();
            NamedNodeMap attrs = node.getAttributes();
            if (baseattrs != null && attrs != null) {
                int i = 0;
                while (i < baseattrs.getLength()) {
                    Node baseattr = baseattrs.item(i);
                    String baseattrvalue = vIDEConfigInfo.this.getTextNodeValue(baseattr);
                    if (baseattr.getNodeName().equals("recursive") && baseattrvalue.equals("true")) {
                        this.isrecursive = true;
                    }
                    ArrayList<String> attrvalues = new ArrayList<String>();
                    attrvalues.add(baseattrvalue);
                    int j = 0;
                    while (j < attrs.getLength()) {
                        String attrvalue;
                        Node attr = attrs.item(j);
                        if (baseattr.getNodeName().equals(attr.getNodeName()) && (attrvalue = vIDEConfigInfo.this.getTextNodeValue(attr)) != null) {
                            if (baseattrvalue == null || baseattrvalue.trim().isEmpty()) {
                                attrvalues.add(attrvalue);
                            } else if (baseattrvalue.indexOf(vIDEConfigInfo.TOKEN_VALUE_SEPARATOR) != -1) {
                                String[] tokens = baseattrvalue.split(vIDEConfigInfo.TOKEN_VALUE_SEPARATOR);
                                String[] values = attrvalue.split(vIDEConfigInfo.TOKEN_VALUE_SEPARATOR);
                                boolean findAll = true;
                                String[] stringArray = values;
                                int n = values.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String value = stringArray[n2];
                                    if (!this.findAttr(value, tokens)) {
                                        findAll = false;
                                        System.out.println(String.format("Invalid attribute[%s] against [%s]", value, baseattrvalue));
                                        break;
                                    }
                                    ++n2;
                                }
                                if (findAll) {
                                    attrvalues.add(attrvalue);
                                }
                            } else if (baseattrvalue.equals(attrvalue)) {
                                attrvalues.add(attrvalue);
                            }
                        }
                        ++j;
                    }
                    this.attributes.put(baseattr.getNodeName(), attrvalues);
                    ++i;
                }
            }
        }

        private boolean findAttr(String attr, String[] attrs) {
            String[] stringArray = attrs;
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                String a = stringArray[n2];
                if (a.equals(attr)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private String replaceVariables(String value) {
            if (this.variableReplacer != null) {
                value = this.variableReplacer.replaceVariables(value);
            }
            return value;
        }

        private void setNodeValue(Node node) {
            String value = vIDEConfigInfo.this.getTextNodeValue(node);
            this.nodevalue = value == null ? "" : value.trim();
            this.nodevalue = this.replaceVariables(this.nodevalue);
        }

        private void updateNodeValue() {
            if (this.nodevalue == null || this.nodevalue.trim().isEmpty()) {
                return;
            }
            this.nodevalue = this.replaceVariables(this.nodevalue);
            String values = this.getAttrBaseValue(TAG_VALUE);
            if (!values.isEmpty()) {
                if (values.indexOf(vIDEConfigInfo.TOKEN_VALUE_SEPARATOR) == -1) {
                    if (!values.equalsIgnoreCase(this.nodevalue)) {
                        this.nodevalue = "";
                    }
                } else {
                    String[] tokens = values.split(vIDEConfigInfo.TOKEN_VALUE_SEPARATOR);
                    int i = 0;
                    while (i < tokens.length) {
                        if (tokens[i].equalsIgnoreCase(this.nodevalue)) {
                            return;
                        }
                        ++i;
                    }
                    this.nodevalue = "";
                }
            }
        }

        private String getAttributeValue(String attr, int index) {
            if (this.attributes.containsKey(attr) && this.attributes.get(attr).size() > index) {
                return this.attributes.get(attr).get(index);
            }
            return "";
        }

        private String getAttrBaseValue(String attr) {
            return this.getAttributeValue(attr, 0);
        }

        private String getAttrValue(String attr) {
            return this.getAttributeValue(attr, 1);
        }

        private String removeNodeId(String text) {
            if (!text.equals(this.nodeid) && text.startsWith(this.nodeid)) {
                return text.substring(this.nodeid.length() + 1);
            }
            return "";
        }

        private String getFirstNodeId(String text) {
            int index = text.indexOf(TOKEN_ID_SEPARATOR);
            if (index != -1) {
                return text.substring(0, index);
            }
            return text;
        }

        private String getNextChildNodeId(String text) {
            String childnodeid = this.removeNodeId(text);
            if (!childnodeid.isEmpty()) {
                return this.getFirstNodeId(childnodeid);
            }
            return "";
        }
    }

    private class ConfigRootNode {
        private static final String KEYPATH_RPMPACKAGEFULLNAME = "system.rpmpackagename";
        private Document cfgdom;
        private final Node basenode;
        private Node cfgnode;
        private Hashtable<String, ArrayList<ConfigNode>> cfgnodes;
        private String id;
        private final String version;
        private final File cfgfile;
        private final boolean valid;
        private final IVariableReplacer variableReplacer;
        private HashMap<String, String> kitinfo;
        public String installeddevkitbuildno;
        public String installeddevkitversion;
        public String installeddevkitrelease;
        public boolean allrpminstalled;

        public ConfigRootNode(IVariableReplacer variableReplacer, Node basenode, File file) {
            this.variableReplacer = variableReplacer;
            this.basenode = basenode;
            this.cfgfile = file;
            this.version = this.getVersionByFilename();
            this.kitinfo = null;
            this.valid = this.refreshInfo();
        }

        private String getVersionByFilename() {
            String v = new String();
            String filename = this.cfgfile.getName();
            Pattern p = Pattern.compile(vIDEConfigInfo.VERSIONED_CONFIGFILE_PATTERN);
            Matcher m = p.matcher(filename);
            if (m.matches()) {
                v = m.group(1);
            }
            return v;
        }

        private boolean refreshInfo() {
            this.cfgnodes = new Hashtable();
            if (!this.cfgfile.exists()) {
                return false;
            }
            this.cfgdom = vIDEConfigInfo.this.parseXml(this.cfgfile);
            if (this.cfgdom == null) {
                return false;
            }
            NodeList cnodes = this.cfgdom.getElementsByTagName(vIDEConfigInfo.TAG_KIT);
            if (cnodes == null || cnodes.getLength() == 0) {
                return false;
            }
            this.cfgnode = cnodes.item(0);
            NodeList basenodelist = this.basenode.getChildNodes();
            int i = 0;
            while (i < basenodelist.getLength()) {
                Node node = basenodelist.item(i);
                if (node.getNodeName() != null && node.getNodeName().indexOf("#text") == -1) {
                    ArrayList<ConfigNode> cnodelist = vIDEConfigInfo.this.createConfigNodes(this.variableReplacer, node, this.cfgnode, "");
                    int j = 0;
                    while (j < cnodelist.size()) {
                        ConfigNode cnode = cnodelist.get(j);
                        ArrayList<ConfigNode> list = this.cfgnodes.containsKey(cnode.getName()) ? this.cfgnodes.get(cnode.getName()) : new ArrayList<ConfigNode>();
                        list.add(cnode);
                        this.cfgnodes.put(cnode.getName(), list);
                        ++j;
                    }
                }
                ++i;
            }
            this.allrpminstalled = this.setInstalledDevkitRPMInfo();
            return true;
        }

        public boolean isValid() {
            return this.valid && this.getId() != null && !this.getId().isEmpty() && this.allrpminstalled;
        }

        public String getRootName() {
            return vIDEConfigInfo.this.getChildTextNodeValueFromParentNode(this.cfgnode, vIDEConfigInfo.TAG_COMMON, vIDEConfigInfo.TAG_NAME);
        }

        public String getTitle() {
            return vIDEConfigInfo.this.getChildTextNodeValueFromParentNode(this.cfgnode, vIDEConfigInfo.TAG_COMMON, vIDEConfigInfo.TAG_TITLE);
        }

        public String getVersion() {
            return this.version;
        }

        private boolean isVersioned() {
            return !this.version.isEmpty();
        }

        private String getVersionedVersion() {
            if (this.isVersioned()) {
                return this.version.substring(0, this.version.indexOf(95));
            }
            return "";
        }

        private String getVersionedBuildNo() {
            if (this.isVersioned()) {
                return this.version.substring(this.version.indexOf(95) + 1);
            }
            return "";
        }

        public String getId() {
            if (this.id == null || this.id.isEmpty()) {
                this.id = vIDEConfigInfo.this.getChildTextNodeValueFromParentNode(this.cfgnode, vIDEConfigInfo.TAG_COMMON, vIDEConfigInfo.TAG_ID);
            }
            return String.valueOf(this.id) + this.getVersion();
        }

        public String getProjectIdentityID() {
            return vIDEConfigInfo.this.getChildTextNodeValueFromParentNode(this.cfgnode, vIDEConfigInfo.TAG_COMMON, vIDEConfigInfo.TAG_PROJECTIDENTITY);
        }

        public String getDescription() {
            return vIDEConfigInfo.this.getChildTextNodeValueFromParentNode(this.cfgnode, vIDEConfigInfo.TAG_COMMON, vIDEConfigInfo.TAG_DESCRIPTION);
        }

        public String getType() {
            return vIDEConfigInfo.this.getChildTextNodeValueFromParentNode(this.cfgnode, vIDEConfigInfo.TAG_COMMON, vIDEConfigInfo.TAG_TYPE);
        }

        public Map<String, String> getKitInfo() {
            if (this.kitinfo == null) {
                this.kitinfo = new HashMap();
                this.kitinfo.put(vIDEConfigInfo.TAG_VERSION, this.getVersion());
                this.kitinfo.put(vIDEConfigInfo.TAG_TYPE, this.getType());
                this.kitinfo.put(vIDEConfigInfo.TAG_NAME, this.getRootName());
                this.kitinfo.put(vIDEConfigInfo.TAG_TITLE, this.getTitle());
                this.kitinfo.put(vIDEConfigInfo.TAG_PROJECTIDENTITY, this.getProjectIdentityID());
                this.kitinfo.put(vIDEConfigInfo.TAG_DESCRIPTION, this.getDescription());
            }
            return this.kitinfo;
        }

        public String getOutput(String header) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("=================================================");
            lines.add("* name        : " + this.getRootName());
            lines.add("* title       : " + this.getTitle());
            lines.add("* id          : " + this.getId());
            lines.add("* type        : " + this.getType());
            lines.add("* description : " + this.getDescription());
            String output = "";
            int i = 0;
            while (i < lines.size()) {
                output = output.concat(String.valueOf(header) + (String)lines.get(i) + "\n");
                ++i;
            }
            Enumeration<ArrayList<ConfigNode>> e = this.cfgnodes.elements();
            while (e.hasMoreElements()) {
                ArrayList<ConfigNode> list = e.nextElement();
                int i2 = 0;
                while (i2 < list.size()) {
                    output = output.concat(list.get(i2).getOutput(String.valueOf(header) + "   "));
                    ++i2;
                }
            }
            return output;
        }

        public ConfigNode[] getConfigNodes(String keypath) {
            Enumeration<ArrayList<ConfigNode>> e = this.cfgnodes.elements();
            while (e.hasMoreElements()) {
                ArrayList<ConfigNode> list = e.nextElement();
                int i = 0;
                while (i < list.size()) {
                    ConfigNode node = list.get(i);
                    if (node.verifyKey(keypath) != NODEKEY.NOTFOUND) {
                        return node.getConfigNodes(keypath);
                    }
                    ++i;
                }
            }
            return new ConfigNode[0];
        }

        public ArrayList<Map<String, Object>> getAllNodeValues(String keypath) {
            ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
            ConfigNode[] nodes = this.getConfigNodes(keypath);
            int i = 0;
            while (i < nodes.length) {
                HashMap<String, Object> nodevalues = new HashMap<String, Object>();
                nodevalues.put(nodes[i].getName(), nodes[i].getAllNodeValues());
                values.add(nodevalues);
                ++i;
            }
            return values;
        }

        public String[] getConfigValues(String keypath) {
            ArrayList<String> values = new ArrayList<String>();
            ConfigNode[] node = this.getConfigNodes(keypath);
            int i = 0;
            while (i < node.length) {
                values.add(node[i].getNodeValue());
                ++i;
            }
            return values.toArray(new String[values.size()]);
        }

        public Map<String, Map<String, String>> getAllConfigValues(String keypath) {
            HashMap<String, Map<String, String>> values = new HashMap<String, Map<String, String>>();
            ConfigNode[] node = this.getConfigNodes(keypath);
            int i = 0;
            while (i < node.length) {
                values.put(node[i].getNodeValue(), node[i].getAttributes());
                ++i;
            }
            return values;
        }

        public String getFirstConfigValue(String keypath) {
            ConfigNode[] node = this.getConfigNodes(keypath);
            if (node.length > 0) {
                return node[0].getNodeValue();
            }
            return "";
        }

        public Map<String, String> getFirstConfigValueFromKeys(String[] keypaths) {
            HashMap<String, String> values = new HashMap<String, String>();
            int i = 0;
            while (i < keypaths.length) {
                String value = this.getFirstConfigValue(keypaths[i]);
                if (value != null && !value.isEmpty()) {
                    values.put(keypaths[i], value);
                }
                ++i;
            }
            return values;
        }

        public Map<String, String> getAttributes(String keypath) {
            Enumeration<ArrayList<ConfigNode>> e = this.cfgnodes.elements();
            while (e.hasMoreElements()) {
                ArrayList<ConfigNode> list = e.nextElement();
                int i = 0;
                while (i < list.size()) {
                    ConfigNode node = list.get(i);
                    if (node.verifyKey(keypath) != NODEKEY.NOTFOUND) {
                        return node.getAttributes(keypath);
                    }
                    ++i;
                }
            }
            return null;
        }

        public ArrayList<Map<String, String>> getOptionValues(ConfigNode node) {
            if (node == null || node.children.size() == 0) {
                return null;
            }
            ArrayList<Map<String, String>> options = new ArrayList<Map<String, String>>();
            HashMap<String, String> option = null;
            Hashtable children = node.children;
            for (String key : children.keySet()) {
                if (!key.equals(vIDEConfigInfo.TAG_OPTION)) continue;
                ArrayList optionnodes = (ArrayList)children.get(key);
                int j = 0;
                while (j < optionnodes.size()) {
                    if (((ConfigNode)optionnodes.get(j)).children.size() != 0) {
                        option = new HashMap<String, String>();
                        Hashtable optionchildren = ((ConfigNode)optionnodes.get(j)).children;
                        for (String childrenkey : optionchildren.keySet()) {
                            List nodes = vIDEConfigInfo.this.getValidNodeList((ArrayList)optionchildren.get(childrenkey));
                            if (nodes == null || nodes.size() <= 0) continue;
                            option.put(childrenkey, ((ConfigNode)nodes.get(0)).getNodeValue());
                        }
                        if (option.size() > 0) {
                            options.add(option);
                        }
                    }
                    ++j;
                }
            }
            return options;
        }

        List<Map<String, String>> getProjectNaturePaths(ConfigNode node) {
            ArrayList<Map<String, String>> paths = new ArrayList<Map<String, String>>();
            if (node != null && !node.children.isEmpty() && node.children.containsKey(vIDEConfigInfo.TAG_PATH)) {
                List pathNodes = (List)node.children.get(vIDEConfigInfo.TAG_PATH);
                pathNodes = vIDEConfigInfo.this.getValidNodeList((ArrayList)pathNodes);
                for (ConfigNode n : pathNodes) {
                    Set es = n.children.entrySet();
                    HashMap<String, String> path = new HashMap<String, String>();
                    for (Map.Entry e : es) {
                        ConfigNode nv = (ConfigNode)vIDEConfigInfo.this.getValidNodeList((ArrayList)e.getValue()).get(0);
                        path.put((String)e.getKey(), nv.getNodeValue());
                    }
                    paths.add(path);
                }
            }
            return paths;
        }

        public Map<String, String> getProjectNatureInfo(String projnatureid) {
            HashMap<String, String> info = new HashMap<String, String>();
            ConfigNode[] node = this.getConfigNodes(vIDEConfigInfo.KEYPATH_PROJECTNATURE);
            int i = 0;
            while (i < node.length) {
                String idvalue = node[i].getChildNodeValue(vIDEConfigInfo.TAG_ID, 0);
                if (idvalue != null && idvalue.equals(projnatureid)) {
                    Hashtable children = node[i].children;
                    for (String key : children.keySet()) {
                        ArrayList nodes = (ArrayList)children.get(key);
                        if (nodes == null || nodes.size() <= 0) continue;
                        info.put(key, ((ConfigNode)nodes.get(0)).getNodeValue());
                    }
                }
                ++i;
            }
            return info;
        }

        public ArrayList<Map<String, String>> getProjectNatureOptions(String projnatureid) {
            ConfigNode[] node = this.getConfigNodes(vIDEConfigInfo.KEYPATH_PROJECTNATURE);
            int i = 0;
            while (i < node.length) {
                String idvalue = node[i].getChildNodeValue(vIDEConfigInfo.TAG_ID, 0);
                if (idvalue != null && idvalue.equals(projnatureid)) {
                    return this.getOptionValues(node[i]);
                }
                ++i;
            }
            return null;
        }

        List<Map<String, String>> getProjectNaturePaths(String projnatureid) {
            ConfigNode[] nodes;
            ConfigNode[] configNodeArray = nodes = this.getConfigNodes(vIDEConfigInfo.KEYPATH_PROJECTNATURE);
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ConfigNode node = configNodeArray[n2];
                String idv = node.getChildNodeValue(vIDEConfigInfo.TAG_ID, 0);
                if (idv != null && idv.equals(projnatureid)) {
                    return this.getProjectNaturePaths(node);
                }
                ++n2;
            }
            return null;
        }

        public Map<String, String> getSystemOptions() {
            HashMap<String, String> systemoptions = new HashMap<String, String>();
            ConfigNode[] node = this.getConfigNodes(vIDEConfigInfo.KEYPATH_SYSTEM);
            if (node.length > 0) {
                ArrayList<Map<String, String>> options = this.getOptionValues(node[0]);
                int i = 0;
                while (i < options.size()) {
                    String name = null;
                    String value = null;
                    if (options.get(i).containsKey(vIDEConfigInfo.TAG_NAME)) {
                        name = options.get(i).get(vIDEConfigInfo.TAG_NAME);
                    }
                    if (options.get(i).containsKey("value")) {
                        value = options.get(i).get("value");
                    }
                    if (name != null && value != null) {
                        systemoptions.put(name, value);
                    }
                    ++i;
                }
            }
            if (this.isVersioned()) {
                systemoptions.put(vIDEConfigInfo.OPT_VERSIONED_DEVKIT_BUILDNO, this.getVersionedBuildNo());
                systemoptions.put(vIDEConfigInfo.OPT_VERSIONED_DEVKIT_VERSION, this.getVersionedVersion());
            }
            if (this.installeddevkitbuildno != null && !this.installeddevkitbuildno.isEmpty()) {
                systemoptions.put(vIDEConfigInfo.OPT_INSTALLED_DEVKIT_BUILDNO, this.installeddevkitbuildno);
            }
            if (this.installeddevkitversion != null && !this.installeddevkitversion.isEmpty()) {
                systemoptions.put(vIDEConfigInfo.OPT_INSTALLED_DEVKIT_VERSION, this.installeddevkitversion);
            }
            if (this.installeddevkitrelease != null && !this.installeddevkitrelease.isEmpty()) {
                systemoptions.put(vIDEConfigInfo.OPT_INSTALLED_DEVKIT_RELEASE, this.installeddevkitrelease);
            }
            return systemoptions;
        }

        private boolean setInstalledDevkitRPMInfo() {
            String[] rpmnames = this.getConfigValues(KEYPATH_RPMPACKAGEFULLNAME);
            if (rpmnames == null || rpmnames.length == 0) {
                return true;
            }
            String[] stringArray = rpmnames;
            int n = rpmnames.length;
            int n2 = 0;
            while (n2 < n) {
                String rpmname = stringArray[n2];
                String version = vIDEConfigInfo.getCommandResult("rpm -q --queryformat '%{VERSION}' " + rpmname);
                String release = vIDEConfigInfo.getCommandResult("rpm -q --queryformat '%{RELEASE}' " + rpmname);
                if (version == null || release == null) {
                    return false;
                }
                if (this.installeddevkitversion == null && this.installeddevkitrelease == null) {
                    this.installeddevkitversion = version.trim();
                    this.installeddevkitrelease = release.trim();
                    this.installeddevkitbuildno = release.substring(release.lastIndexOf(".") + 1).trim();
                }
                ++n2;
            }
            return true;
        }
    }

    public static enum NODEKEY {
        FOUND,
        NOTFOUND,
        PARENT;

    }
}

