/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui.supportbundle.contributor;

import com.vmware.vide.logging.PlatformLoggingController;
import com.vmware.vide.logging.supportbundle.FileBundleContribution;
import com.vmware.vide.logging.supportbundle.ISupportBundleContribution;
import com.vmware.vide.logging.supportbundle.ISupportBundleContributor;
import com.vmware.vide.logging.supportbundle.StringBundleContribution;
import com.vmware.vide.utils.ui.supportbundle.contributor.CommandOutputContribution;
import com.vmware.vide.utils.ui.supportbundle.contributor.DirectoryListingBundleContribution;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbenchBaseInfoContributor
implements ISupportBundleContributor {
    private static final Logger logger = LoggerFactory.getLogger(WorkbenchBaseInfoContributor.class);
    private static final boolean isLinux = System.getProperty("os.name").toLowerCase().contains("linux");

    public List<ISupportBundleContribution> getContributions() {
        LinkedList<ISupportBundleContribution> contributions = new LinkedList<ISupportBundleContribution>();
        this.getLogFiles(contributions);
        this.getEnvironmentVariables(contributions);
        this.getSystemInfo(contributions);
        this.getLinuxInfo(contributions);
        this.getWorkbenchDirectoryListings(contributions);
        return contributions;
    }

    private void getLogFiles(List<ISupportBundleContribution> contributions) {
        try {
            File[] children;
            File dir = new File(PlatformLoggingController.getInstance().getLogDirPath());
            File[] fileArray = children = dir.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile()) {
                    contributions.add((ISupportBundleContribution)new FileBundleContribution(f, "logs/" + f.getName()));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.error("Unexpected exception while getting log files", (Throwable)e);
        }
    }

    private void getEnvironmentVariables(List<ISupportBundleContribution> contributions) {
        try {
            StringBuilder envsb = new StringBuilder(1024);
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                envsb.append(entry.getKey()).append('=').append(entry.getValue()).append('\n');
            }
            contributions.add((ISupportBundleContribution)new StringBundleContribution("system-env.txt", "System env variables", envsb.toString()));
        }
        catch (Exception e) {
            logger.error("Unexpected exception while getting env vars", (Throwable)e);
        }
    }

    private void getSystemInfo(List<ISupportBundleContribution> contributions) {
        try {
            StringBuilder sb = new StringBuilder(1024);
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                sb.append(entry.getKey()).append('=').append(entry.getValue()).append('\n');
            }
            contributions.add((ISupportBundleContribution)new StringBundleContribution("system-properties.txt", "Java system properties", sb.toString()));
        }
        catch (Exception e) {
            logger.error("Unexpected exception while getting system properties", (Throwable)e);
        }
    }

    private void getWorkbenchDirectoryListings(List<ISupportBundleContribution> contributions) {
        if (isLinux) {
            String[] nonRecursiveDirs;
            String[] stringArray = nonRecursiveDirs = new String[]{"/build", "/build/toolchain", "/build/toolchain/lin32", "/build/toolchain/lin64", "/build/toolchain/noarch", "/opt/vmware", "/opt/vmware/toolchain", "/opt/vmware/toolchain/lin32", "/opt/vmware/toolchain/lin64", "/opt/vmware/toolchain/noarch"};
            int n = nonRecursiveDirs.length;
            int n2 = 0;
            while (n2 < n) {
                String dir = stringArray[n2];
                String nameInArchive = dir.replace('/', '-').substring(1);
                contributions.add(new DirectoryListingBundleContribution("dir-listings/" + nameInArchive + ".txt", String.valueOf(dir) + " directory listings", new File(dir), false, false));
                ++n2;
            }
            contributions.add(new DirectoryListingBundleContribution("dir-listings/opt-vmware-vide.txt", "/opt/vmware/vide directory listings", new File("/opt/vmware/vide"), true, false));
        }
    }

    private void getLinuxInfo(List<ISupportBundleContribution> contributions) {
        try {
            if (isLinux) {
                contributions.add((ISupportBundleContribution)new FileBundleContribution(new File("/proc/version"), "linux/proc/version", "Linux /proc/version file system version info"));
                contributions.add((ISupportBundleContribution)new FileBundleContribution(new File("/proc/cpuinfo"), "linux/proc/cpuinfo", "Linux /proc/cpuinfo info"));
                contributions.add((ISupportBundleContribution)new FileBundleContribution(new File("/proc/modules"), "linux/proc/modules", "Linux /proc/modules info"));
                contributions.add(new CommandOutputContribution("linux/rpm-db.txt", "The output of 'rpm -qa'", "rpm -qa"));
            }
        }
        catch (Exception e) {
            logger.error("Unexpected exception while getting linux files", (Throwable)e);
        }
    }
}

