/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui.commands;

import com.vmware.vide.utils.net.HttpLogger;
import com.vmware.vide.utils.ui.Activator;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class HTTPLoggerCommand
extends AbstractHandler
implements IHandler {
    private static final String PARAMETER_ID = "com.vmware.vide.utils.ui.commands.httplogger.parameter";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String proxyIp;
        Map parameters = null;
        try {
            AbstractParameterValueConverter converter = event.getCommand().getParameterType(PARAMETER_ID).getValueConverter();
            parameters = (Map)converter.convertToObject(event.getParameter(PARAMETER_ID));
        }
        catch (Exception e) {
            throw new ExecutionException("Failed convert parameters.", (Throwable)e);
        }
        String activity = (String)parameters.get("activity");
        if (activity == null || activity.isEmpty()) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.vmware.vide.utils.ui", "'activity' is not specified."));
            return null;
        }
        long milliSeconds = 0L;
        String interval = (String)parameters.get("beaconCheckMilliseconds");
        if (interval != null && !interval.isEmpty()) {
            try {
                milliSeconds = Long.parseLong(interval);
            }
            catch (NumberFormatException e) {
                String msg = String.format("Non long number is spcified for 'beaconCheckMilliseconds'.", new Object[0]);
                Activator.getDefault().getLog().log((IStatus)new Status(4, "com.vmware.vide.utils.ui", msg, (Throwable)e));
            }
        }
        if ((proxyIp = (String)parameters.get("proxyIp")) != null && proxyIp.isEmpty()) {
            proxyIp = null;
        }
        HttpLogger.logActivity((String)activity, (String)((String)parameters.get("programId")), (String)((String)parameters.get("subProgramId")), (String)proxyIp, (long)milliSeconds);
        return null;
    }
}

