/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.browser.BrowserViewer;

public class WBBrowserWindow
extends ApplicationWindow {
    private String url;
    private boolean newSite = true;

    public WBBrowserWindow(Shell parentShell, String url) {
        super(parentShell);
        this.url = url;
        this.addStatusLine();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        MyBrowserViewer browser = new MyBrowserViewer(composite, 6);
        browser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("title")) {
                    WBBrowserWindow.this.getShell().setText((String)event.getNewValue());
                }
            }
        });
        browser.getBrowser().addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
                WBBrowserWindow.this.setStatus(event.text);
            }
        });
        browser.getBrowser().addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
                if (event.total <= 0) {
                    return;
                }
                StatusLineManager manager = WBBrowserWindow.this.getStatusLineManager();
                if (manager != null) {
                    int progress = event.current * 100 / event.total;
                    IProgressMonitor mon = manager.getProgressMonitor();
                    if (progress == 100) {
                        mon.done();
                        WBBrowserWindow.this.newSite = true;
                    } else if (WBBrowserWindow.this.newSite) {
                        mon.beginTask("", event.total);
                        WBBrowserWindow.this.newSite = false;
                    } else {
                        mon.worked(progress);
                    }
                }
            }

            public void completed(ProgressEvent event) {
                StatusLineManager manager = WBBrowserWindow.this.getStatusLineManager();
                if (manager != null) {
                    manager.getProgressMonitor().done();
                }
            }
        });
        if (this.url != null && !this.url.isEmpty()) {
            browser.setURL(this.url);
        }
        parent.setSize(800, 600);
        return composite;
    }

    private class MyBrowserViewer
    extends BrowserViewer {
        public MyBrowserViewer(Composite parent, int style) {
            super(parent, style);
        }

        protected void updateBackNextBusy() {
            if (this.isDisposed()) {
                return;
            }
            if (this.back.isDisposed() || this.forward.isDisposed() || this.busy.isDisposed()) {
                return;
            }
            super.updateBackNextBusy();
        }

        protected void updateHistory() {
            if (this.combo.isDisposed()) {
                return;
            }
            super.updateHistory();
        }
    }
}

