/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui;

import com.vmware.vide.utils.ui.ColumnData;
import com.vmware.vide.utils.ui.IVTableSorter;
import com.vmware.vide.utils.ui.UIUtilsImages;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeColumn;

public class VMWBTreeViewer
extends TreeViewer {
    private static final int MINIMUM_COLUMN_WIDTH = 5;
    private static final String VISUAL_DATA_KEY = "visualdata";
    public static final String TAG_COLUMN_WIDTH = "column_width";
    public static final String TAG_COLUMN_VISIBLE = "column_visible";
    public static final String TAG_VIEW_STATE_STORED = "view_state_stored";
    public static final String TAG_SAVED = "saved";
    protected ColumnData[] columns;
    protected boolean useCharsWidth;
    protected IPreferenceStore store;
    protected String viewId;

    public VMWBTreeViewer(Composite parent) {
        super(parent, 2818);
    }

    public VMWBTreeViewer(Composite parent, boolean isVirtual) {
        super(parent, 0xB02 | (isVirtual ? 0x10000000 : 0));
    }

    public void createColumns(ColumnData[] columnData, String viewId, IPreferenceStore store, final IVTableSorter sorter) {
        this.store = store;
        this.viewId = viewId;
        this.columns = columnData;
        this.setUseCharsWidth(true);
        if (store != null && !store.getString(String.valueOf(viewId) + TAG_VIEW_STATE_STORED).isEmpty()) {
            int i = 0;
            while (i < columnData.length) {
                this.columns[i].visible = store.getBoolean(String.valueOf(viewId) + TAG_COLUMN_VISIBLE + i);
                this.columns[i].width = store.getInt(String.valueOf(viewId) + TAG_COLUMN_WIDTH + i);
                ++i;
            }
            this.setUseCharsWidth(false);
        }
        PixelConverter converter = new PixelConverter((Control)this.getTree().getParent());
        ColumnData[] columnDataArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnData data = columnDataArray[n2];
            TreeViewerColumn tvc = new TreeViewerColumn((TreeViewer)this, 0);
            tvc.getColumn().setText(data.header);
            tvc.getColumn().setToolTipText(data.desc);
            tvc.getColumn().setMoveable(true);
            tvc.getColumn().setData(VISUAL_DATA_KEY, (Object)data);
            int pixwidth = this.getColumnWidth(data, converter);
            tvc.getColumn().setWidth(pixwidth);
            data.width = pixwidth;
            tvc.getColumn().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    TreeColumn col = (TreeColumn)e.getSource();
                    ColumnData data = (ColumnData)col.getData(VMWBTreeViewer.VISUAL_DATA_KEY);
                    if (col.getWidth() < 5 && data.visible) {
                        col.setWidth(5);
                    }
                }
            });
            tvc.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TreeColumn col = (TreeColumn)e.getSource();
                    ColumnData data = (ColumnData)col.getData(VMWBTreeViewer.VISUAL_DATA_KEY);
                    sorter.sort(col, data);
                }
            });
            tvc.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof String) {
                        String l = (String)element;
                        return l;
                    }
                    return null;
                }
            });
            tvc.setEditingSupport(new EditingSupport((ColumnViewer)this){

                protected CellEditor getCellEditor(Object element) {
                    return null;
                }

                protected boolean canEdit(Object element) {
                    return false;
                }

                protected Object getValue(Object element) {
                    return null;
                }

                protected void setValue(Object element, Object value) {
                }
            });
            ++n2;
        }
        this.setUseCharsWidth(false);
    }

    public void setColumnViewStrategies() {
        TreeViewerFocusCellManager focusCellManager = new TreeViewerFocusCellManager((TreeViewer)this, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                switch (event.eventType) {
                    case 2: {
                        return true;
                    }
                    case 5: {
                        return true;
                    }
                    case 1: {
                        if (event.keyCode != 13) break;
                        return true;
                    }
                    case 4: {
                        return true;
                    }
                }
                return false;
            }
        };
        TreeViewerEditor.create((TreeViewer)this, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        this.getColumnViewerEditor().addEditorActivationListener(new ColumnViewerEditorActivationListener(){

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
                ViewerCell cell = (ViewerCell)event.getSource();
                VMWBTreeViewer.this.getTree().showColumn(VMWBTreeViewer.this.getTree().getColumn(cell.getColumnIndex()));
            }

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }
        });
    }

    public void setVisibleColumn(int index, boolean b) {
        this.columns[index].visible = b;
        PixelConverter converter = new PixelConverter((Control)this.getTree().getParent());
        TreeColumn[] treeColumnArray = this.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn col = treeColumnArray[n2];
            ColumnData d = (ColumnData)col.getData(VISUAL_DATA_KEY);
            int pixwidth = this.getColumnWidth(d, converter);
            col.setWidth(pixwidth);
            ++n2;
        }
    }

    protected int getColumnWidth(ColumnData data, PixelConverter converter) {
        int pixwidth = 0;
        if (data.visible) {
            pixwidth = this.isUseCharsWidth() ? converter.convertWidthInCharsToPixels(data.width) : data.width;
        }
        return pixwidth;
    }

    public void updateSortDirection(TreeColumn column, ColumnData data, ColumnData.SortDirection direction) {
        data.sortedType = direction;
        TreeColumn[] treeColumnArray = this.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn col = treeColumnArray[n2];
            if (column == col) {
                if (direction == ColumnData.SortDirection.ASCENDING) {
                    col.setImage(UIUtilsImages.getAscendingImage());
                } else {
                    col.setImage(UIUtilsImages.getDescendingImage());
                }
            } else {
                ColumnData d = (ColumnData)col.getData(VISUAL_DATA_KEY);
                d.sortedType = ColumnData.SortDirection.NONE;
                col.setImage(null);
            }
            ++n2;
        }
    }

    public void resetColumnSortDirection() {
        TreeColumn[] treeColumnArray = this.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn col = treeColumnArray[n2];
            ColumnData d = (ColumnData)col.getData(VISUAL_DATA_KEY);
            d.sortedType = ColumnData.SortDirection.NONE;
            col.setImage(null);
            ++n2;
        }
    }

    public void saveState() {
        if (this.store == null) {
            return;
        }
        TreeColumn[] cols = this.getTree().getColumns();
        int i = 0;
        while (i < this.columns.length) {
            this.store.setValue(String.valueOf(this.viewId) + TAG_COLUMN_VISIBLE + i, this.columns[i].visible);
            this.store.setValue(String.valueOf(this.viewId) + TAG_COLUMN_WIDTH + i, cols[i].getWidth());
            ++i;
        }
    }

    public void setUseCharsWidth(boolean b) {
        this.useCharsWidth = b;
    }

    public boolean isUseCharsWidth() {
        return this.useCharsWidth;
    }
}

