/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextFilterDialog {
    private Text filterText;
    private Button regExButton;
    private Button matchCaseButton;
    private String filterValue;
    private boolean regExEnabled;
    private boolean matchCaseEnabled;
    private boolean cancelled;
    private Shell shell;

    public TextFilterDialog(Composite parent) {
        Display myDisplay = Display.getDefault();
        this.shell = new Shell(myDisplay);
        this.shell.setLayout((Layout)new GridLayout(3, false));
        this.shell.setText("Filter");
        this.shell.setBounds(120, 120, 400, 250);
        Label label = new Label((Composite)this.shell, 0);
        label.setText("Filter &string:");
        GridData gd = new GridData(768);
        Text text = new Text((Composite)this.shell, 2048);
        gd = new GridData(768);
        gd.minimumWidth = 300;
        gd.horizontalSpan = 2;
        text.setLayoutData((Object)gd);
        this.filterText = text;
        new Label((Composite)this.shell, 0);
        this.regExButton = new Button((Composite)this.shell, 32);
        this.regExButton.setText("Use regular &expression");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.regExButton.setLayoutData((Object)gd);
        this.regExButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TextFilterDialog.this.setMatchCaseEnabled();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label((Composite)this.shell, 0);
        this.matchCaseButton = new Button((Composite)this.shell, 32);
        this.matchCaseButton.setText("Match &case");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.matchCaseButton.setLayoutData((Object)gd);
        new Label((Composite)this.shell, 0);
        Button ok = new Button((Composite)this.shell, 8);
        ok.setText("   &OK   ");
        Button cancel = new Button((Composite)this.shell, 8);
        cancel.setText("  &Cancel  ");
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextFilterDialog.this.filterValue = TextFilterDialog.this.filterText.getText().trim();
                TextFilterDialog.this.regExEnabled = TextFilterDialog.this.regExButton.getSelection();
                TextFilterDialog.this.matchCaseEnabled = TextFilterDialog.this.matchCaseButton.getSelection();
                TextFilterDialog.this.shell.dispose();
            }
        });
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextFilterDialog.this.shell.dispose();
                TextFilterDialog.this.cancelled = true;
            }
        });
        this.shell.pack();
    }

    public boolean open() {
        this.cancelled = false;
        this.setMatchCaseEnabled();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return !this.cancelled;
    }

    public void setFilterValue(String value) {
        this.filterValue = value;
        if (value != null) {
            this.filterText.setText(value);
        }
    }

    public void setRegExEnabled(boolean value) {
        this.regExEnabled = value;
        this.regExButton.setSelection(value);
    }

    public void setMatchCaseEnabled(boolean value) {
        this.matchCaseEnabled = value;
        this.matchCaseButton.setSelection(value);
    }

    public String getFilterValue() {
        return this.filterValue;
    }

    public boolean isRegExEnabled() {
        return this.regExEnabled;
    }

    public boolean isMatchCaseEnabled() {
        return this.matchCaseEnabled;
    }

    private void setMatchCaseEnabled() {
        this.matchCaseButton.setEnabled(!this.regExButton.getSelection());
    }
}

