/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.ui.cimbrowser;

import com.vmware.vide.cimtools.core.cimcore.CIMClassData;
import com.vmware.vide.cimtools.core.cimcore.CIMHost;
import java.util.SortedSet;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class SearchCIMClassPage
extends WizardPage {
    private static final String WIZARDPAGE_TITLE = "Search a CIM Class";
    private static final String WIZARDPAGE_DESCRIPTION = "Select a CIM class";
    private static final String LABEL_CIMCLASS = "CIM Class";
    private static final String ERROR_NOCIMCLASS = "CIM class not found";
    private static final String KEY_CIMCLASSDATA = "CIMClassData";
    private SortedSet<Object> allclasses;
    private Text classtext;
    String inputtext;
    private TableViewer classviewer;
    private Table classtable;

    protected SearchCIMClassPage(CIMHost host, String inputtext) {
        super(WIZARDPAGE_TITLE);
        this.setTitle(WIZARDPAGE_TITLE);
        this.setDescription(WIZARDPAGE_DESCRIPTION);
        this.inputtext = inputtext;
        if (host != null) {
            this.allclasses = host.getSortedCIMClasses();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label classlabel = new Label(composite, 8);
        classlabel.setText(LABEL_CIMCLASS);
        classlabel.setData("name", (Object)"ClassLabel");
        classlabel.setLayoutData((Object)new GridData(0, 0, false, false));
        this.classtext = new Text(composite, 2048);
        this.classtext.setData("name", (Object)"Classname");
        this.classtext.setLayoutData((Object)new GridData(4, 0, true, true));
        this.classtext.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                SearchCIMClassPage.this.classviewer.refresh();
                SearchCIMClassPage.this.classtext.setData(SearchCIMClassPage.KEY_CIMCLASSDATA, (Object)SearchCIMClassPage.this.getTypedCIMClassData());
                SearchCIMClassPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.classtext.setText(this.inputtext);
        this.classtable = new Table(composite, 2816);
        this.classtable.setHeaderVisible(false);
        this.classtable.setLinesVisible(false);
        this.classtable.setData("name", (Object)"ClassTable");
        GridData griddata = new GridData(4, 4, true, true, 2, 1);
        griddata.heightHint = 200;
        this.classtable.setLayoutData((Object)griddata);
        this.classviewer = new TableViewer(this.classtable);
        this.classviewer.setData("name", (Object)"ClassViewer");
        this.classviewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof CIMClassData) {
                    return ((CIMClassData)element).getCIMClassName();
                }
                return element.toString();
            }
        });
        this.classviewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object element) {
                return SearchCIMClassPage.this.getCIMClasses();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.classviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] selections = new Object[]{};
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    selections = ((IStructuredSelection)selection).toArray();
                }
                if (selections.length > 0 && selections[0] instanceof CIMClassData) {
                    CIMClassData classdata = (CIMClassData)selections[0];
                    SearchCIMClassPage.this.classtext.setText(classdata.getCIMClassName());
                    SearchCIMClassPage.this.classtext.setData(SearchCIMClassPage.KEY_CIMCLASSDATA, (Object)classdata);
                    SearchCIMClassPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        this.classviewer.setInput((Object)this);
    }

    public boolean isPageComplete() {
        return this.classtext.getData(KEY_CIMCLASSDATA) != null;
    }

    public Object[] getCIMClasses() {
        if (this.allclasses == null || this.allclasses.isEmpty()) {
            return new Object[]{ERROR_NOCIMCLASS};
        }
        String classname = this.classtext.getText();
        if (classname.isEmpty()) {
            return this.allclasses.toArray();
        }
        Object[] classes = this.allclasses.subSet(classname, String.valueOf(classname) + "z").toArray();
        return classes;
    }

    public CIMClassData getSelectedCimClassData() {
        Object data = this.classtext.getData(KEY_CIMCLASSDATA);
        return data instanceof CIMClassData ? (CIMClassData)data : null;
    }

    private CIMClassData getTypedCIMClassData() {
        if (this.classtable.getItemCount() == 0) {
            return null;
        }
        CIMClassData classdata = (CIMClassData)this.classtable.getItem(0).getData();
        return classdata.getCIMClassName().equals(this.classtext.getText()) ? classdata : null;
    }
}

