/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.ui.cimbrowser;

import com.vmware.vide.cimtools.core.cimbrowser.CIMBrowserEngine;
import com.vmware.vide.cimtools.core.cimcore.CIMHost;
import com.vmware.vide.cimtools.ui.cimbrowser.AddCIMClassPage;
import com.vmware.vide.cimtools.ui.cimbrowser.AddHostPage;
import com.vmware.vide.cimtools.utils.CIMToolsException;
import com.vmware.vide.cimtools.utils.UtilDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class CIMBrowserWizard
extends Wizard
implements INewWizard {
    private static final String WIZARD_TITLE = "Workbench CIM Browser";
    private static final String CONTEXT_HELP_CONTENTS_ID = "context-cimbrowser-wizard";
    private static final String ERROR_VIEWREFRESH = "Failed to refresh CIM browser view";
    private static final String ERROR_UNKNOWNHOST = "Unable to access Host";
    private AddHostPage addhostpage;
    private AddCIMClassPage addcimclasspage;
    private String viewid;
    private CIMHost cimhost;
    private boolean openhostselpage;
    private boolean selclassonly;

    public CIMBrowserWizard(CIMHost cimhost, String viewid, boolean openhostselpage, boolean selclassonly) {
        this.setWindowTitle(WIZARD_TITLE);
        this.openhostselpage = openhostselpage;
        this.selclassonly = selclassonly;
        this.addhostpage = new AddHostPage();
        this.addcimclasspage = new AddCIMClassPage(this.selclassonly);
        this.cimhost = cimhost;
        this.viewid = viewid;
    }

    public void addPages() {
        super.addPages();
        if (this.openhostselpage) {
            this.addPage((IWizardPage)this.addhostpage);
        }
        this.addPage((IWizardPage)this.addcimclasspage);
        if (this.getShell() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.vmware.vide.cimtools.help.context-cimbrowser-wizard");
        }
    }

    public boolean performFinish() {
        CIMHost host;
        CIMHost cIMHost = host = this.openhostselpage ? this.addhostpage.getSelectedCIMHost() : this.cimhost;
        if (host == null || !host.isValid()) {
            UtilDialog.openDialog(CIMToolsException.createCommonException(ERROR_UNKNOWNHOST, null));
            return false;
        }
        try {
            String[] classnames = this.addcimclasspage.getAddedClassnames();
            CIMBrowserEngine.addCIMClassesInView(this.viewid, host, this.addcimclasspage.isAllCIMClassSelected(), classnames);
            return true;
        }
        catch (CIMToolsException e) {
            UtilDialog.openDialog(e);
        }
        catch (Exception e) {
            UtilDialog.openDialog(CIMToolsException.createCommonException(ERROR_VIEWREFRESH, e));
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(WIZARD_TITLE);
    }
}

