/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.ui.cimbrowser;

import com.vmware.vide.cimtools.CIMToolsPlugin;
import com.vmware.vide.cimtools.core.cimbrowser.CIMBrowserEngine;
import com.vmware.vide.cimtools.core.cimcore.CIMHost;
import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetChangedEvent;
import com.vmware.vide.target.api.ITargetListener;
import com.vmware.vide.target.api.ITargetManagerInitListener;
import com.vmware.vide.target.api.TargetManagerPlugin;
import java.io.IOException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.ui.wizards.newconnection.RSEMainNewConnectionWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class AddHostPage
extends WizardPage {
    private static final ILog logger = CIMToolsPlugin.getDefault().getLog();
    private static final String WIZARDPAGE_TITLE = "Add Host";
    private static final String WIZARDPAGE_DESCRIPTION = "Select a Host to add";
    private static final String LABEL_HOST = "CIM Host";
    private static final String LABEL_NAMESPACE = "CIM Namespace";
    private static final String LABEL_PROTOCOL = "Protocol";
    private static final String LABEL_PORT = "Port";
    private static final String CONTEXT_HELP_CONTENTS_ID = "context-cimbrowserwizard-addhostpage";
    private static final String MSG_INVALID_PORT = "Invalid port information";
    private static final String MSG_NEED_NAMESPACE = "namespace is required";
    private static final String MSG_NEED_PROTOCOL = "protocol is required";
    private static final String MSG_SAME_HOSTNAME = "The same host already exists in the CIM Class Browser";
    private static final String NAMESPACE_CIMV2 = "root/cimv2";
    private static final String NAMESPACE_INTEROP = "root/interop";
    private static final String PROTOCOL_HTTPS = "https";
    private static final String PROTOCOL_HTTP = "http";
    private static final String PORT_DEF_HTTPS = "5989";
    private static final String PORT_DEF_HTTP = "5988";
    private static final String[] DEF_NAMESPACES = new String[]{"root/cimv2", "root/interop"};
    private static final String[] DEF_PROTOCOLS = new String[]{"https", "http"};
    private static final String[] DEF_PORTS = new String[]{"5989", "5988"};
    private static final String LABEL_SSL_PROTOCOL = "SSL Protocol";
    private static final String[] DEF_SSL_PROTOCOLS = new String[]{"SSL"};
    private static final String ADD_HOST_DIALOG_SECTION = "cimtools.add.host";
    private static final String KEY_LAST_SSL_PROTOCOL = "last.ssl.protocol";
    private static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";
    private Combo hostcombo;
    private Combo protocolcombo;
    private Combo portcombo;
    private Combo namespacecombo;
    private Combo sslProtocolCombo;
    private ITarget host;
    private int port;
    private TargetManagerListener targetlistener;

    protected AddHostPage() {
        super(WIZARDPAGE_TITLE);
        this.setTitle(WIZARDPAGE_TITLE);
        this.setDescription(WIZARDPAGE_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite workcomposite = new Composite(parent, 0);
        this.setControl((Control)workcomposite);
        workcomposite.setLayout((Layout)new GridLayout());
        workcomposite.setLayoutData((Object)new GridData(1808));
        this.createUI(workcomposite);
        if (this.getShell() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.vmware.vide.cimtools.help.context-cimbrowserwizard-addhostpage");
        }
    }

    public boolean isPageComplete() {
        if (this.port == -1) {
            this.setErrorMessage(MSG_INVALID_PORT);
            return false;
        }
        if (this.namespacecombo.getText().isEmpty()) {
            this.setErrorMessage(MSG_NEED_NAMESPACE);
            return false;
        }
        if (this.protocolcombo.getText().isEmpty()) {
            this.setErrorMessage(MSG_NEED_PROTOCOL);
            return false;
        }
        this.setDescription(WIZARDPAGE_DESCRIPTION);
        this.setErrorMessage(null);
        return this.host != null;
    }

    public void dispose() {
        if (this.targetlistener != null) {
            TargetManagerPlugin.getTheTargetManager().removeInitListener((ITargetManagerInitListener)this.targetlistener);
        }
        super.dispose();
    }

    public CIMHost getSelectedCIMHost() {
        CIMHost host = new CIMHost(this.getHost(), this.protocolcombo.getText(), this.port, this.namespacecombo.getText(), this.sslProtocolCombo.getText());
        return host.isValid() ? host : null;
    }

    private void createUI(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Label targetlabel = new Label(composite, 8);
        targetlabel.setText(LABEL_HOST);
        targetlabel.setData("name", (Object)"HostLabel");
        targetlabel.setLayoutData((Object)new GridData(0, 0, false, false));
        this.hostcombo = new Combo(composite, 8);
        this.hostcombo.setData("name", (Object)"HostCombo");
        this.hostcombo.setLayoutData((Object)new GridData(4, 0, true, true));
        this.hostcombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String hostname = AddHostPage.this.hostcombo.getText();
                if (hostname != null && !hostname.isEmpty()) {
                    if (CIMBrowserEngine.isHostExist(hostname)) {
                        AddHostPage.this.setErrorMessage(AddHostPage.MSG_SAME_HOSTNAME);
                    } else {
                        AddHostPage.this.host = TargetManagerPlugin.getTheTargetManager().findTarget(hostname);
                    }
                    AddHostPage.this.setPageComplete(AddHostPage.this.isPageComplete());
                }
            }
        });
        this.targetlistener = new TargetManagerListener(this.hostcombo);
        TargetManagerPlugin.getTheTargetManager().addInitListener((ITargetManagerInitListener)this.targetlistener);
        TargetManagerPlugin.getTheTargetManager().addTargetListener((ITargetListener)this.targetlistener);
        this.targetlistener.updateComboList();
        Button addhost = new Button(composite, 8);
        addhost.setLayoutData((Object)new GridData(0, 0, false, false));
        addhost.setImage(CIMToolsPlugin.getDefault().getImage("addhost.png"));
        addhost.setText("Add Target...");
        addhost.setToolTipText("Add a target system to the Remote System Explorer.");
        addhost.setData("name", (Object)"addHostButton");
        addhost.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddHostPage.openRSEDialog();
            }
        });
        Label nslabel = new Label(composite, 8);
        nslabel.setText(LABEL_NAMESPACE);
        nslabel.setData("name", (Object)"NamespaceLabel");
        nslabel.setLayoutData((Object)new GridData(0, 0, false, false));
        this.namespacecombo = new Combo(composite, 0);
        this.namespacecombo.setData("name", (Object)"NamespaceText");
        this.namespacecombo.setLayoutData((Object)new GridData(4, 0, true, true, 2, 1));
        this.namespacecombo.setItems(DEF_NAMESPACES);
        this.namespacecombo.select(0);
        this.namespacecombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddHostPage.this.setPageComplete(AddHostPage.this.isPageComplete());
            }
        });
        Label protocollabel = new Label(composite, 8);
        protocollabel.setText(LABEL_PROTOCOL);
        protocollabel.setData("name", (Object)"ProtocolLabel");
        protocollabel.setLayoutData((Object)new GridData(0, 0, false, false));
        this.protocolcombo = new Combo(composite, 0);
        this.protocolcombo.setData("name", (Object)"ProtocolCombo");
        this.protocolcombo.setLayoutData((Object)new GridData(4, 0, true, true, 2, 1));
        this.protocolcombo.setItems(DEF_PROTOCOLS);
        this.protocolcombo.select(0);
        this.protocolcombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AddHostPage.this.protocolcombo.getText().equals(AddHostPage.PROTOCOL_HTTPS)) {
                    AddHostPage.this.portcombo.setText(AddHostPage.PORT_DEF_HTTPS);
                } else if (AddHostPage.this.protocolcombo.getText().equals(AddHostPage.PROTOCOL_HTTP)) {
                    AddHostPage.this.portcombo.setText(AddHostPage.PORT_DEF_HTTP);
                }
                AddHostPage.this.setPageComplete(AddHostPage.this.isPageComplete());
            }
        });
        Label portlabel = new Label(composite, 8);
        portlabel.setText(LABEL_PORT);
        portlabel.setData("name", (Object)"PortLabel");
        portlabel.setLayoutData((Object)new GridData(0, 0, false, false));
        this.portcombo = new Combo(composite, 0);
        this.portcombo.setData("name", (Object)"PortCombo");
        this.portcombo.setLayoutData((Object)new GridData(4, 0, true, true, 2, 1));
        this.portcombo.setItems(DEF_PORTS);
        this.portcombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                try {
                    AddHostPage.this.port = Integer.parseInt(AddHostPage.this.portcombo.getText());
                }
                catch (Exception exception) {
                    AddHostPage.this.port = -1;
                }
                AddHostPage.this.setPageComplete(AddHostPage.this.isPageComplete());
            }
        });
        this.portcombo.select(0);
        Label label = new Label(composite, 0);
        label.setText(LABEL_SSL_PROTOCOL);
        label.setData("name", (Object)"SslProtocol");
        label.setLayoutData((Object)new GridData(0, 0, false, false));
        Combo combo = new Combo(composite, 8);
        combo.setData("name", (Object)"SslProtocolCombo");
        combo.setLayoutData((Object)new GridData(4, 0, true, true, 2, 1));
        this.initializeSslProtocolList(combo);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo c = (Combo)e.getSource();
                AddHostPage.this.setLastSslProtocol(c.getText());
            }
        });
        this.sslProtocolCombo = combo;
    }

    private void initializeSslProtocolList(Combo combo) {
        int index;
        String[] protocols = DEF_SSL_PROTOCOLS;
        try {
            SSLSocket socket = (SSLSocket)SSLSocketFactory.getDefault().createSocket();
            protocols = socket.getSupportedProtocols();
        }
        catch (IOException e) {
            String msg = "Failed to get the supported SSL protocol list. Set the default SSL protocols.";
            logger.log((IStatus)new Status(4, "com.vmware.vide.cimtools", msg, (Throwable)e));
        }
        combo.setItems(protocols);
        combo.select(0);
        String initialProtocol = DEFAULT_SSL_PROTOCOL;
        String lastProtocol = this.getLastSslProtocol();
        if (lastProtocol != null && !lastProtocol.isEmpty()) {
            initialProtocol = lastProtocol;
        }
        if ((index = combo.indexOf(initialProtocol)) != -1) {
            combo.select(index);
        }
    }

    private String getLastSslProtocol() {
        return this.getSettings().get(KEY_LAST_SSL_PROTOCOL);
    }

    private void setLastSslProtocol(String protocol) {
        this.getSettings().put(KEY_LAST_SSL_PROTOCOL, protocol);
    }

    private IDialogSettings getSettings() {
        IDialogSettings settings = CIMToolsPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(ADD_HOST_DIALOG_SECTION);
        if (section == null) {
            section = settings.addNewSection(ADD_HOST_DIALOG_SECTION);
        }
        return section;
    }

    private ITarget getHost() {
        String targetname = this.hostcombo.getText();
        if (targetname != null && !targetname.isEmpty()) {
            return TargetManagerPlugin.getTheTargetManager().findTarget(targetname);
        }
        return null;
    }

    private static void openRSEDialog() {
        RSEMainNewConnectionWizard wizard = new RSEMainNewConnectionWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection());
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private class TargetManagerListener
    implements ITargetManagerInitListener,
    ITargetListener {
        private final Combo combobox;

        public TargetManagerListener(Combo combobox) {
            this.combobox = combobox;
        }

        public void updateComboList() {
            if (this.combobox == null || this.combobox.isDisposed()) {
                return;
            }
            String cursel = this.combobox.getText();
            this.combobox.removeAll();
            boolean isselavailable = false;
            ITarget[] hosts = TargetManagerPlugin.getTheTargetManager().getTargets();
            int i = 0;
            while (i < hosts.length) {
                this.combobox.add(hosts[i].getName());
                if (cursel != null && !cursel.isEmpty() && cursel.equals(hosts[i].getName())) {
                    isselavailable = true;
                }
                ++i;
            }
            this.combobox.setText(isselavailable ? cursel : "");
        }

        public void phaseComplete(int phase) {
            this.combobox.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    TargetManagerListener.this.updateComboList();
                }
            });
        }

        public void targetChanged(ITargetChangedEvent event) {
            this.combobox.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    TargetManagerListener.this.updateComboList();
                }
            });
        }
    }
}

