/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.ui.cimbrowser;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddCIMClassPage
extends WizardPage {
    private static final String WIZARDPAGE_TITLE = "Add CIM Class(es)";
    private static final String WIZARDPAGE_DESCRIPTION = "Select CIM Classes in CIM Browser";
    private static final String TOOLTIP_ADDCIMCALSS = "Type CIM Class name to add";
    private static final String RADIO_ALLCIMCLASS = "Browse all CIM classes";
    private static final String RADIO_NOCIMCLASS = "Browse no CIM Class (add a CIM Host only)";
    private static final String RADIO_SELECTEDCIMCLASS = "Browse selected CIM Classes";
    private static final String RADIO_CIMCLASSFROMMOF = "Browser CIM Classes from MOF file(s)";
    private static final int INDEX_RADIO_ALLCIMCLASS = 0;
    private static final int INDEX_RADIO_NOCIMCLASS = 1;
    private static final int INDEX_RADIO_SELECTEDCIMCLASS = 2;
    private static final int INDEX_RADIO_CIMCLASSFROMMOF = 3;
    private static final int NUM_RADIO_BUTTONS = 4;
    private static final String[] RADIO_TEXTS = new String[4];
    private static final String LABEL_CIMCLASS = "CIM Class name";
    private static final String BUTTON_ADD = "      Add      ";
    private static final String BUTTON_DELETE = "     Delete    ";
    private static final String CONTEXT_HELP_CONTENTS_ID = "context-cimbrowserwizardt-addcimclasspage";
    Composite addclasscomposite;
    private Text classnametext;
    private String selradiotext;
    List cimclasslist;
    Label namelabel;
    Button addclassbtn;
    Button delclassbtn;
    boolean selclassonly;

    static {
        AddCIMClassPage.RADIO_TEXTS[0] = RADIO_ALLCIMCLASS;
        AddCIMClassPage.RADIO_TEXTS[1] = RADIO_NOCIMCLASS;
        AddCIMClassPage.RADIO_TEXTS[2] = RADIO_SELECTEDCIMCLASS;
        AddCIMClassPage.RADIO_TEXTS[3] = RADIO_CIMCLASSFROMMOF;
    }

    protected AddCIMClassPage(boolean selclassonly) {
        super(WIZARDPAGE_TITLE);
        this.setTitle(WIZARDPAGE_TITLE);
        this.setDescription(WIZARDPAGE_DESCRIPTION);
        this.selradiotext = RADIO_ALLCIMCLASS;
        this.selclassonly = selclassonly;
    }

    public void createControl(Composite parent) {
        Composite workcomposite = new Composite(parent, 0);
        this.setControl((Control)workcomposite);
        workcomposite.setLayout((Layout)new GridLayout());
        workcomposite.setLayoutData((Object)new GridData(1808));
        if (this.selclassonly) {
            this.createAddCIMClassUI(workcomposite);
            this.selradiotext = RADIO_SELECTEDCIMCLASS;
            this.setEnableAddCIMClassUI(true);
        } else {
            this.createAllUI(workcomposite);
        }
        if (this.getShell() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.vmware.vide.cimtools.help.context-cimbrowserwizardt-addcimclasspage");
        }
    }

    public boolean isPageComplete() {
        return !this.selradiotext.equals(RADIO_SELECTEDCIMCLASS) || this.getAddedClassnames().length != 0;
    }

    public String[] getAddedClassnames() {
        return this.cimclasslist.getItems();
    }

    public boolean isAllCIMClassSelected() {
        return this.selradiotext.equals(RADIO_ALLCIMCLASS);
    }

    private void createAllUI(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Listener radiobtnlistener = new Listener(){

            public void handleEvent(Event event) {
                Button button;
                if (event.widget instanceof Button && (button = (Button)event.widget).getSelection()) {
                    AddCIMClassPage.this.selradiotext = button.getText();
                    AddCIMClassPage.this.setEnableAddCIMClassUI(AddCIMClassPage.this.selradiotext.equals(AddCIMClassPage.RADIO_SELECTEDCIMCLASS));
                    AddCIMClassPage.this.getWizard().getContainer().updateButtons();
                }
            }
        };
        Button[] radiobtn = new Button[4];
        int i = 0;
        while (i < radiobtn.length) {
            radiobtn[i] = new Button(composite, 16);
            radiobtn[i].setText(RADIO_TEXTS[i]);
            radiobtn[i].setLayoutData((Object)new GridData(768));
            radiobtn[i].addListener(13, radiobtnlistener);
            if (i == 2) {
                this.createAddCIMClassUI(parent);
            }
            ++i;
        }
        radiobtn[0].setSelection(true);
        this.setEnableAddCIMClassUI(false);
        radiobtn[3].setEnabled(false);
    }

    private void createAddCIMClassUI(Composite parent) {
        this.addclasscomposite = new Composite(parent, 2048);
        this.addclasscomposite.setLayout((Layout)new GridLayout(3, false));
        this.addclasscomposite.setLayoutData((Object)new GridData(1808));
        this.namelabel = new Label(this.addclasscomposite, 8);
        this.namelabel.setText(LABEL_CIMCLASS);
        this.namelabel.setData("name", (Object)"NameLabel");
        this.namelabel.setLayoutData((Object)new GridData(0, 0, false, false));
        this.classnametext = new Text(this.addclasscomposite, 2048);
        this.classnametext.setData("name", (Object)"ClassNameText");
        this.classnametext.setLayoutData((Object)new GridData(4, 0, true, true));
        this.classnametext.setToolTipText(TOOLTIP_ADDCIMCALSS);
        this.addclassbtn = new Button(this.addclasscomposite, 8);
        this.addclassbtn.setLayoutData((Object)new GridData(0, 0, false, false));
        this.addclassbtn.setText(BUTTON_ADD);
        this.addclassbtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.addCIMClassInList();
            }

            public void widgetSelected(SelectionEvent e) {
                this.addCIMClassInList();
            }

            private void addCIMClassInList() {
                if (!AddCIMClassPage.this.classnametext.getText().isEmpty() && AddCIMClassPage.this.cimclasslist.indexOf(AddCIMClassPage.this.classnametext.getText()) == -1) {
                    AddCIMClassPage.this.cimclasslist.add(AddCIMClassPage.this.classnametext.getText());
                    AddCIMClassPage.this.classnametext.setText("");
                }
                AddCIMClassPage.this.getWizard().getContainer().updateButtons();
            }
        });
        Composite listcomposite = new Composite(this.addclasscomposite, 0);
        listcomposite.setLayout((Layout)new GridLayout(2, false));
        listcomposite.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.cimclasslist = new List(listcomposite, 2560);
        GridData griddata = new GridData(4, 4, true, true);
        griddata.heightHint = 3 * this.cimclasslist.getItemHeight();
        this.cimclasslist.setLayoutData((Object)griddata);
        this.delclassbtn = new Button(listcomposite, 8);
        this.delclassbtn.setLayoutData((Object)new GridData(0, 0, false, false));
        this.delclassbtn.setText(BUTTON_DELETE);
        this.delclassbtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.deleteCIMClassInList();
            }

            public void widgetSelected(SelectionEvent e) {
                this.deleteCIMClassInList();
            }

            private void deleteCIMClassInList() {
                String[] selections;
                String[] stringArray = selections = AddCIMClassPage.this.cimclasslist.getSelection();
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    String selection = stringArray[n2];
                    AddCIMClassPage.this.cimclasslist.remove(selection);
                    ++n2;
                }
                AddCIMClassPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    private void setEnableAddCIMClassUI(boolean enabled) {
        this.addclasscomposite.setEnabled(enabled);
        this.cimclasslist.setEnabled(enabled);
        this.cimclasslist.setEnabled(enabled);
        this.namelabel.setEnabled(enabled);
        this.addclassbtn.setEnabled(enabled);
        this.delclassbtn.setEnabled(enabled);
        this.classnametext.setEnabled(enabled);
    }
}

