/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.core.cimcore;

import com.vmware.vide.cimtools.CIMToolsPlugin;
import com.vmware.vide.cimtools.core.cimcore.CIMClassData;
import com.vmware.vide.cimtools.core.cimcore.CIMHost;
import java.util.ArrayList;
import javax.cim.CIMObjectPath;
import org.eclipse.swt.graphics.Image;

public class CIMTreeData {
    protected static final int TREEGROUP_INSTANCES = 0;
    protected static final int TREEGROUP_REFERENCES = 1;
    protected static final int TREEGROUP_METHODS = 2;
    protected static final int TREEGROUP_PROPERTIES = 3;
    protected static final int TREEGROUP_QUALIFIERS = 4;
    protected static final String[] TREEGROUP_TITLE = new String[]{"Instances", "References", "Methods", "Properties", "Qualifiers"};
    protected static final int COL_NAME = 0;
    protected static final int COL_TYPE = 1;
    protected static final int COL_VALUE = 2;
    protected CIMTreeData parent;
    protected String name;
    protected int level;
    protected Image image;
    protected ArrayList<CIMTreeData> children;
    protected ArrayList<CIMClassData> schemaelements;
    protected ArrayList<CIMTreeData> subtreeelements;

    public CIMTreeData(CIMTreeData parent, String name, Image image, ArrayList<CIMTreeData> children, ArrayList<CIMClassData> schemaelements, ArrayList<CIMTreeData> subtreeelements) {
        this.parent = parent;
        this.name = name;
        this.level = parent != null && parent instanceof CIMTreeData ? parent.level + 1 : 1;
        this.image = image;
        this.children = children != null ? children : new ArrayList();
        this.schemaelements = schemaelements != null ? schemaelements : new ArrayList();
        this.subtreeelements = subtreeelements != null ? subtreeelements : new ArrayList();
    }

    public CIMTreeData(CIMTreeData parent, String name, Image image) {
        this(parent, name, image, new ArrayList<CIMTreeData>(), new ArrayList<CIMClassData>(), new ArrayList<CIMTreeData>());
    }

    public CIMTreeData(CIMTreeData parent, String name) {
        this(parent, name, null);
    }

    public boolean isValid() {
        return true;
    }

    public Object[] getChildren(String viewid, int treetype) {
        if (treetype == 1 && this.isSchemaView(viewid)) {
            return this.getSchemaChildren();
        }
        return this.children.toArray();
    }

    public boolean hasChildren(String viewid, int treetype) {
        return this.getChildren(viewid, treetype).length > 0;
    }

    public CIMClassData[] getSchemaChildren() {
        return this.schemaelements.toArray(new CIMClassData[this.schemaelements.size()]);
    }

    public CIMTreeData[] getSubTreeChildren() {
        return this.subtreeelements.toArray(new CIMTreeData[this.subtreeelements.size()]);
    }

    public CIMTreeData getParent() {
        return this.parent;
    }

    public String getText() {
        return this.name;
    }

    public String getColumnText(int colindex) {
        if (colindex == 0) {
            return this.name;
        }
        return "";
    }

    public Image getImage() {
        return this.image;
    }

    public Image getColumnImage(int colindex) {
        if (colindex == 0) {
            return this.image;
        }
        return null;
    }

    public int getLevel() {
        return this.level;
    }

    public String getCIMClassName() {
        return "";
    }

    public ArrayList<CIMTreeData> getAllTreeObjects() {
        ArrayList<CIMTreeData> treeobjects = this.parent != null && this.parent instanceof CIMTreeData ? this.parent.getAllTreeObjects() : new ArrayList<CIMTreeData>();
        treeobjects.add(this);
        return treeobjects;
    }

    public CIMHost getCIMHost() {
        CIMTreeData rootparent = this.parent;
        while (rootparent != null) {
            if (rootparent instanceof CIMHost) {
                return (CIMHost)rootparent;
            }
            rootparent = rootparent.getParent();
        }
        return null;
    }

    public String getCIMInfo() {
        return "";
    }

    protected void cleanSchemaElements() {
        this.schemaelements.clear();
        for (CIMTreeData element : this.children) {
            element.cleanSchemaElements();
        }
    }

    protected CIMObjectPath getObjectPath() {
        return null;
    }

    protected boolean isInheritanceView(String viewid) {
        return "com.vmware.vide.cimtools.inheritanceview".equals(viewid);
    }

    protected boolean isSchemaView(String viewid) {
        return "com.vmware.vide.cimtools.schemaview".equals(viewid);
    }

    protected boolean isInstanceView(String viewid) {
        return "com.vmware.vide.cimtools.instanceview".equals(viewid);
    }

    protected boolean isWBEMOperationView(String viewid) {
        return "com.vmware.vide.cimtools.wbemoperationview".equals(viewid);
    }

    protected static Image getImage(String imageid) {
        return CIMToolsPlugin.getDefault().getImage(imageid);
    }

    protected static String getGroupTitle(int type) {
        return type < 6 ? TREEGROUP_TITLE[type] : "";
    }

    public static CIMTreeData getErrorMesgTreeData(String errormsg) {
        return new CIMTreeData(null, errormsg, CIMTreeData.getImage("error.png"), null, null, null);
    }

    public static CIMTreeData getWraningMsgTreeData(String warningmsg) {
        return new CIMTreeData(null, warningmsg, CIMTreeData.getImage("warning.png"), null, null, null);
    }
}

