/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.core.cimcore;

import com.vmware.vide.cimtools.core.cimclient.EnumCIMReferences;
import com.vmware.vide.cimtools.core.cimcore.CIMInstanceData;
import com.vmware.vide.cimtools.core.cimcore.CIMTreeData;
import com.vmware.vide.cimtools.ui.cimbrowser.BrowserView;
import com.vmware.vide.cimtools.utils.CIMToolsException;
import com.vmware.vide.cimtools.utils.UtilDialog;
import java.util.ArrayList;
import javax.cim.CIMInstance;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class CIMReferenceGroup
extends CIMTreeData {
    private CIMInstanceData refdata;
    private ArrayList<CIMInstanceData> instances;

    public CIMReferenceGroup(CIMInstanceData ref) {
        super(ref, CIMReferenceGroup.getGroupTitle(1));
        this.refdata = ref;
        this.instances = null;
        this.image = CIMReferenceGroup.getImage("reference.png");
    }

    @Override
    public boolean isValid() {
        return this.refdata != null;
    }

    @Override
    public Object[] getChildren(String viewid, int viewtype) {
        if (this.instances == null) {
            this.instances = new ArrayList();
            final String currentviewid = viewid;
            final EnumCIMReferences job = new EnumCIMReferences(this.refdata.getCIMHost(), this.refdata.getObjectPath(), null);
            job.schedule();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    try {
                        if (event.getResult().isOK()) {
                            ArrayList<CIMInstance> refs = job.getWBEMResult();
                            for (CIMInstance ref : refs) {
                                CIMInstanceData instdata = new CIMInstanceData(CIMReferenceGroup.this.parent, CIMReferenceGroup.this.refdata, ref);
                                if (!instdata.isValid()) continue;
                                CIMReferenceGroup.this.instances.add(instdata);
                            }
                            BrowserView.refreshView(currentviewid, false, null);
                            return;
                        }
                        if (job.getException() != null) {
                            UtilDialog.openDialog(job.getException());
                        }
                    }
                    catch (CIMToolsException e) {
                        UtilDialog.openDialog(e);
                    }
                    catch (Exception e) {
                        UtilDialog.openDialog(CIMToolsException.createCommonException(e.getMessage(), e));
                    }
                    CIMReferenceGroup.this.instances = null;
                }
            });
            return new Object[0];
        }
        return this.instances.toArray();
    }
}

