/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.core.cimcore;

import com.vmware.vide.cimtools.core.cimcore.CIMClassData;
import com.vmware.vide.cimtools.core.cimcore.CIMPropertyData;
import com.vmware.vide.cimtools.core.cimcore.CIMReferenceGroup;
import com.vmware.vide.cimtools.core.cimcore.CIMTreeData;
import java.util.ArrayList;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;

public class CIMInstanceData
extends CIMTreeData {
    CIMTreeData cimparent;
    CIMClassData cimclass;
    CIMInstance ciminstance;
    String instancetype;
    ArrayList<CIMPropertyData> cimproperties;

    public CIMInstanceData(CIMTreeData parent, CIMTreeData cimparent, CIMInstance inst) {
        super(parent, inst != null ? inst.getClassName() : null);
        if (inst == null) {
            return;
        }
        this.ciminstance = inst;
        this.cimparent = cimparent;
        this.cimclass = this.getCIMHost().find(this.ciminstance.getClassName());
        this.addChildren();
        this.name = this.getInstanceName();
        this.image = CIMInstanceData.getImage(this.cimclass.isAssociation() ? "assoc-instance.png" : "class-instance.png");
    }

    public CIMInstanceData(CIMTreeData parent, CIMInstance inst) {
        this(parent, parent, inst);
    }

    @Override
    public boolean isValid() {
        return this.ciminstance != null;
    }

    @Override
    public String getCIMClassName() {
        return this.ciminstance.getClassName();
    }

    @Override
    public Object[] getChildren(String viewid, int viewtype) {
        if (viewtype == 2) {
            return this.subtreeelements.toArray();
        }
        return super.getChildren(viewid, viewtype);
    }

    @Override
    public CIMObjectPath getObjectPath() {
        return this.ciminstance.getObjectPath();
    }

    @Override
    public String getCIMInfo() {
        return this.ciminstance.toString();
    }

    private String getInstanceName() {
        StringBuffer name = new StringBuffer(this.ciminstance.getClassName());
        for (CIMPropertyData property : this.cimproperties) {
            if (!property.cimproperty.isKey() || property.getValueString().isEmpty()) continue;
            name.append(name.toString().isEmpty() ? ":" : ",");
            name.append(property.getNameValueString());
        }
        return name.toString();
    }

    private void addChildren() {
        CIMProperty[] properties;
        CIMTreeData propgroup = new CIMTreeData(this, CIMInstanceData.getGroupTitle(3), CIMInstanceData.getImage("property.png"));
        this.cimproperties = new ArrayList();
        CIMProperty[] cIMPropertyArray = properties = this.ciminstance.getProperties();
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            CIMProperty property = cIMPropertyArray[n2];
            CIMPropertyData propdata = new CIMPropertyData((CIMTreeData)this, property);
            if (propdata.isValid()) {
                this.cimproperties.add(propdata);
                propgroup.children.add(propdata);
            }
            ++n2;
        }
        this.subtreeelements.add(propgroup);
        if (this.cimclass.isAssociation()) {
            this.children.add(propgroup);
        } else {
            CIMReferenceGroup refgroup = new CIMReferenceGroup(this);
            if (refgroup.isValid()) {
                this.children.add(refgroup);
            }
        }
    }
}

