/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.core.cimcore;

import com.vmware.vide.cimtools.core.cimcore.CIMAssocClassData;
import com.vmware.vide.cimtools.core.cimcore.CIMClassPropertyData;
import com.vmware.vide.cimtools.core.cimcore.CIMHost;
import com.vmware.vide.cimtools.core.cimcore.CIMIndClassData;
import com.vmware.vide.cimtools.core.cimcore.CIMInstanceGroup;
import com.vmware.vide.cimtools.core.cimcore.CIMMethodData;
import com.vmware.vide.cimtools.core.cimcore.CIMQualifierData;
import com.vmware.vide.cimtools.core.cimcore.CIMTreeData;
import java.util.ArrayList;
import java.util.List;
import javax.cim.CIMClass;
import javax.cim.CIMObjectPath;

public class CIMClassData
extends CIMTreeData {
    CIMClass cimclass;
    CIMInstanceGroup instgroup;
    ArrayList<CIMClassPropertyData> cimproperties;
    List<CIMTreeData> wbemelements;

    public CIMClassData(CIMTreeData parent, CIMClass cls) {
        super(parent, cls != null ? cls.getName() : null, CIMClassData.getImage("cimclass.png"));
        this.cimclass = cls;
        this.cimproperties = new ArrayList();
        this.instgroup = new CIMInstanceGroup(this);
        this.subtreeelements = new ArrayList();
        if (this.instgroup.isValid()) {
            this.subtreeelements.add(this.instgroup);
        }
        this.subtreeelements.addAll(this.getSubtreeItems());
        this.wbemelements = this.getSubtreeItems();
    }

    @Override
    public boolean isValid() {
        return this.cimclass != null;
    }

    @Override
    public Object[] getChildren(String viewid, int viewtype) {
        if (this.isInstanceView(viewid)) {
            return this.instgroup.getChildren(viewid, viewtype);
        }
        if (this.isWBEMOperationView(viewid)) {
            return this.wbemelements.toArray();
        }
        return super.getChildren(viewid, viewtype);
    }

    @Override
    public String getCIMClassName() {
        return this.cimclass.getName();
    }

    @Override
    public CIMObjectPath getObjectPath() {
        return this.cimclass.getObjectPath();
    }

    @Override
    public String getCIMInfo() {
        return this.cimclass.toString();
    }

    private List<CIMTreeData> getSubtreeItems() {
        ArrayList<CIMTreeData> elements = new ArrayList<CIMTreeData>();
        ArrayList<CIMTreeData> methods = new ArrayList<CIMTreeData>();
        int i = 0;
        while (i < this.cimclass.getMethodCount()) {
            CIMMethodData cimmethod = new CIMMethodData(this, this.cimclass.getMethod(i));
            if (cimmethod.isValid()) {
                methods.add(cimmethod);
            }
            ++i;
        }
        CIMTreeData methoddata = new CIMTreeData(this, CIMClassData.getGroupTitle(2), CIMClassData.getImage("method.png"), methods, null, null);
        elements.add(methoddata);
        ArrayList<CIMTreeData> properties = new ArrayList<CIMTreeData>();
        int i2 = 0;
        while (i2 < this.cimclass.getPropertyCount()) {
            CIMClassPropertyData cimproperty = new CIMClassPropertyData(this, this.cimclass.getProperty(i2));
            if (cimproperty.isValid()) {
                properties.add(cimproperty);
                this.cimproperties.add(cimproperty);
            }
            ++i2;
        }
        CIMTreeData propertydata = new CIMTreeData(this, CIMClassData.getGroupTitle(3), CIMClassData.getImage("property.png"), properties, null, null);
        elements.add(propertydata);
        ArrayList<CIMTreeData> qualifiers = new ArrayList<CIMTreeData>();
        int i3 = 0;
        while (i3 < this.cimclass.getQualifierCount()) {
            CIMQualifierData cimqualifier = new CIMQualifierData(this, this.cimclass.getQualifier(i3));
            if (cimqualifier.isValid()) {
                qualifiers.add(cimqualifier);
            }
            ++i3;
        }
        CIMTreeData qualifierdata = new CIMTreeData(this, CIMClassData.getGroupTitle(4), CIMClassData.getImage("qualifier.png"), qualifiers, null, null);
        elements.add(qualifierdata);
        return elements;
    }

    public CIMClassData getRootCIMClass() {
        CIMTreeData parent;
        CIMClassData superclass = this;
        do {
            if (!((parent = superclass.getParent()) instanceof CIMHost)) continue;
            return superclass;
        } while ((superclass = parent instanceof CIMClassData ? (CIMClassData)parent : null) != null);
        return null;
    }

    public String getClassName() {
        return this.cimclass.getName();
    }

    public String getSuperClassName() {
        return this.cimclass.getSuperClassName();
    }

    public boolean isAssociation() {
        return this.cimclass.isAssociation();
    }

    public boolean isSuperClassOf(CIMClass cls, boolean append) {
        if (cls.getSuperClassName().equals(this.cimclass.getName())) {
            CIMClassData data;
            if (append && (data = CIMClassData.createCIMClassData(this, cls)).isValid()) {
                this.children.add(data);
            }
            return true;
        }
        int i = 0;
        while (i < this.children.size()) {
            Object child = this.children.get(i);
            if (child instanceof CIMClassData && ((CIMClassData)child).isSuperClassOf(cls, append)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public CIMClassData find(String classname) {
        if (this.name.equalsIgnoreCase(classname)) {
            return this;
        }
        for (CIMTreeData child : this.children) {
            CIMClassData data;
            if (!(child instanceof CIMClassData) || (data = ((CIMClassData)child).find(classname)) == null) continue;
            return data;
        }
        return null;
    }

    public CIMClassData find(CIMClassData classdata) {
        if (this == classdata) {
            return this;
        }
        if (this.getCIMClassName().equalsIgnoreCase(classdata.getClassName())) {
            return this;
        }
        for (CIMTreeData child : this.children) {
            CIMClassData data;
            if (!(child instanceof CIMClassData) || (data = ((CIMClassData)child).find(classdata)) == null) continue;
            return data;
        }
        return null;
    }

    public void addAssociatedClass(CIMClassData data) {
        if (!this.schemaelements.contains(data)) {
            this.schemaelements.add(data);
        }
    }

    public List<CIMClassData> getAllCIMClass() {
        ArrayList<CIMClassData> allclasses = new ArrayList<CIMClassData>();
        allclasses.add(this);
        for (CIMTreeData child : this.children) {
            if (!(child instanceof CIMClassData)) continue;
            allclasses.addAll(((CIMClassData)child).getAllCIMClass());
        }
        return allclasses;
    }

    public static CIMClassData createCIMClassData(CIMTreeData parent, CIMClass cimclass) {
        if (cimclass.isAssociation()) {
            return new CIMAssocClassData(parent, cimclass);
        }
        if (CIMIndClassData.isIndicationClass(parent, cimclass)) {
            return new CIMIndClassData(parent, cimclass);
        }
        return new CIMClassData(parent, cimclass);
    }
}

